//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVICONS.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Graphic icons manager                |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string
#define uses_colors
#define uses_comlin
#define uses_config
#define uses_dc
#define uses_icons
#define uses_ini
#define uses_system

#define DECLARE_PVICONS
#include "PVuses.h"
#undef DECLARE_PVICONS

#if !defined( NOICONS ) && !defined( HGR )

#define GRAPH_COUNT8 39
char graph_set8[32] = {
  0x0E,0x08,0xDC,0x30,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xEE,0xFF,0xFF,0x0B,0x00,0x80,0x00,0x0C
};
char graph_chars8[GRAPH_COUNT8][8] = {
  { 0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80 },
  { 0xF7,0xF3,0x81,0x80,0x80,0x81,0xF3,0xF7 },
  { 0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81 },
  { 0x11,0x42,0x88,0x11,0x42,0x88,0x11,0x42 },
  { 0xFE,0x00,0xFE,0x00,0xFE,0x00,0xFE,0x00 },
  { 0x00,0x54,0xAA,0x54,0xAA,0x54,0xAA,0x54 },
  { 0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00 },
  { 0xFE,0xFC,0xF8,0xF8,0xF8,0xF8,0xFC,0xFE },
  { 0x80,0xC0,0xE0,0xE0,0xE0,0xE0,0xC0,0x80 },
  { 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 },
  { 0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18 },
  { 0xFF,0xFF,0x00,0x81,0xC3,0xE7,0xFF,0xFF },
  { 0xFF,0xFF,0xE7,0xC3,0x81,0x00,0xFF,0xFF },
  { 0xFF,0xE7,0xC3,0x81,0xFF,0x81,0xC3,0xE7 },
  { 0xFF,0x87,0x81,0x85,0x85,0xDD,0xC1,0xFF },
  { 0xFF,0xFF,0xFF,0x81,0x81,0xFF,0xFF,0xFF },
  { 0xEF,0xCF,0x81,0x01,0x01,0x81,0xCF,0xEF },
  { 0xFF,0xC3,0xC3,0xC3,0x00,0x81,0xC3,0xE7 },
  { 0xE7,0xC3,0x81,0x00,0xC3,0xC3,0xC3,0xFF },
  { 0x81,0xBD,0x81,0xBD,0x81,0xBD,0x81,0xBD },
  { 0xFF,0x00,0x55,0x55,0x55,0x55,0x00,0xFF },
  { 0x3C,0x42,0x81,0x81,0x81,0x42,0x3C,0x00 },
  { 0x3C,0x42,0x99,0xBD,0x99,0x42,0x3C,0x00 },
  { 0xFF,0x81,0x81,0x81,0x81,0x81,0xFF,0x00 },
  { 0xFF,0x83,0x87,0xED,0xBD,0x99,0xFF,0x00 },
  { 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00 },
  { 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF },
  { 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF },
  { 0x00,0x00,0x00,0x00,0xFF,0x80,0x80,0x80 },
  { 0x00,0x00,0x00,0x00,0xFF,0x01,0x01,0x01 },
  { 0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80 },
  { 0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01 },
  { 0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01 },
  { 0x7C,0xFE,0xFE,0xFE,0xFE,0xFE,0x7C,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00 },
  { 0x00,0x01,0x03,0x06,0x0C,0xD8,0x70,0x20 }
};

#define GRAPH_COUNT14 59
char graph_set14[32] = {
  0xFE,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xEE,0xFF,0xFF,0x0B,0x00,0xE0,0x00,0x0C
};
char graph_chars14[GRAPH_COUNT14][14] = {
  { 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 },
  { 0x00,0x00,0xF8,0xFC,0xFC,0x0C,0x1C,0x3C,0x7C,0xFC,0xFC,0xF8,0x00,0x00 },
  { 0x00,0x00,0xF8,0xFC,0xFC,0x7C,0x3C,0x1C,0x0C,0xFC,0xFC,0xF8,0x00,0x00 },
  { 0x00,0x00,0xF8,0x7C,0x3C,0x1C,0xFC,0xFC,0x1C,0x3C,0x7C,0xF8,0x00,0x00 },
  { 0x00,0x00,0xF8,0xFC,0x3C,0x0C,0x2C,0x2C,0xEC,0x0C,0xFC,0xF8,0x00,0x00 },
  { 0x00,0x00,0xF8,0xFC,0xFC,0xFC,0x1C,0x1C,0xFC,0xFC,0xFC,0xF8,0x00,0x00 },
  { 0x00,0x00,0xF8,0xFC,0xBC,0x9C,0x0C,0x0C,0x9C,0xBC,0xFC,0xF8,0x00,0x00 },
  { 0x00,0x00,0xF8,0x7C,0x7C,0x7C,0x7C,0x7C,0x1C,0x3C,0x7C,0xF8,0x00,0x00 },
  { 0x00,0x00,0xF8,0x7C,0x3C,0x1C,0x7C,0x7C,0x7C,0x7C,0x7C,0xF8,0x00,0x00 },
  { 0xFC,0x04,0xFC,0x04,0xFC,0x04,0xFC,0x04,0xFC,0x04,0xFC,0x04,0xFC,0x04 },
  { 0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA },
  { 0x00,0xE0,0x10,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x10,0xE0,0x00,0x00 },
  { 0x00,0xE0,0x10,0x08,0xC4,0xE4,0xE4,0xE4,0xC4,0x08,0x10,0xE0,0x00,0x00 },
  { 0x00,0xFC,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0xFC,0x00,0x00 },
  { 0x00,0xFC,0x04,0x34,0x64,0x64,0xC4,0xC4,0x84,0x84,0x04,0xFC,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0xC0,0xF0,0xFC,0xFF,0xFC,0xF0,0xC0,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x03,0x0F,0x3F,0xFF,0x3F,0x0F,0x03,0x00,0x00,0x00 },
  { 0x00,0x00,0xFC,0x00,0xFC,0x00,0xFC,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00 },
  { 0x99,0x24,0x42,0x99,0x42,0x24,0x99,0x99,0x24,0x42,0x99,0x42,0x24,0x99 },
  { 0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0 },
  { 0xFF,0xFC,0xF8,0xF0,0xF0,0xE0,0xE0,0xE0,0xE0,0xF0,0xF0,0xF8,0xFC,0xFF },
  { 0x00,0xC0,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xE0,0xC0,0x00 },
  { 0x00,0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x04,0x06,0xFF,0xFF,0x06,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x20,0x60,0xFF,0xFF,0x60,0x20,0x00,0x00,0x00,0x00 },
  { 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18 },
  { 0xFF,0xFF,0xE0,0xC0,0xC0,0xCF,0xC7,0xC3,0xC1,0xC0,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC0,0xC1,0xC3,0xC7,0xCF,0xC0,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC1,0xC3,0xC7,0xC0,0xC0,0xC7,0xC3,0xC1,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xCF,0xCF,0xCF,0xCF,0xC2,0xC3,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC0,0xC0,0xC7,0xC7,0xC0,0xC0,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC2,0xC6,0xCF,0xCF,0xC6,0xC2,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC1,0xC1,0xC1,0xC1,0xC1,0xC7,0xC3,0xC1,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC1,0xC3,0xC7,0xC1,0xC1,0xC1,0xC1,0xC1,0xE0,0xFF,0xFF },
  { 0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF },
  { 0xFF,0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x00,0xFF },
  { 0x00,0x07,0x08,0x10,0x20,0x20,0x20,0x20,0x20,0x10,0x08,0x07,0x00,0x00 },
  { 0x00,0x07,0x08,0x10,0x23,0x27,0x27,0x27,0x23,0x10,0x08,0x07,0x00,0x00 },
  { 0x00,0x3F,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3F,0x00,0x00 },
  { 0x00,0x3F,0x20,0x20,0x20,0x20,0x2C,0x26,0x23,0x21,0x20,0x3F,0x00,0x00 },
  { 0x00,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00 },
  { 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF },
  { 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x03,0x03,0x03,0x03,0x03 },
  { 0xFF,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 },
  { 0xFF,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03 },
  { 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xFF },
  { 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xFF },
  { 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03 },
  { 0x7C,0xFE,0xFE,0xFE,0xFE,0x7C,0x00,0x7C,0xFE,0xFE,0xFE,0xFE,0x7C,0x00 },
  { 0x7C,0xFE,0xFE,0xFE,0xFE,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0xFE,0xFE,0xFE,0xFE,0x7C,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00 },
  { 0x00,0x01,0x03,0x02,0x06,0x04,0x0C,0x88,0xD8,0x50,0x70,0x20,0x00,0x00 }
};

#define GRAPH_COUNT16 59
char graph_set16[32] = {
  0xFE,0xFF,0xFF,0x3F,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xEE,0xFF,0xFF,0x0B,0x00,0xE0,0x00,0x0C
};
char graph_chars16[GRAPH_COUNT16][16] = {
  { 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 },
  { 0x00,0x00,0xFC,0xFE,0xFE,0xFE,0x0E,0x1E,0x3E,0x7E,0xFE,0xFE,0xFE,0xFC,0x00,0x00 },
  { 0x00,0x00,0xFC,0xFE,0xFE,0xFE,0x7E,0x3E,0x1E,0x0E,0xFE,0xFE,0xFE,0xFC,0x00,0x00 },
  { 0x00,0x00,0xFC,0x7E,0x3E,0x1E,0x0E,0xFE,0xFE,0x0E,0x1E,0x3E,0x7E,0xFC,0x00,0x00 },
  { 0x00,0x00,0xFC,0xFE,0x1E,0x06,0x16,0x16,0x16,0x16,0xF6,0x06,0xFE,0xFC,0x00,0x00 },
  { 0x00,0x00,0xFC,0xFE,0xFE,0xFE,0xFE,0x0E,0x0E,0xFE,0xFE,0xFE,0xFE,0xFC,0x00,0x00 },
  { 0x00,0x00,0xFC,0xFE,0xFE,0xDE,0xCE,0x06,0x06,0xCE,0xDE,0xFE,0xFE,0xFC,0x00,0x00 },
  { 0x00,0x00,0xFC,0xFE,0x7E,0x7E,0x7E,0x7E,0x7E,0x1E,0x3E,0x7E,0xFE,0xFC,0x00,0x00 },
  { 0x00,0x00,0xFC,0xFE,0x7E,0x3E,0x1E,0x7E,0x7E,0x7E,0x7E,0x7E,0xFE,0xFC,0x00,0x00 },
  { 0xFE,0x02,0xFE,0x02,0xFE,0x02,0xFE,0x02,0xFE,0x02,0xFE,0x02,0xFE,0x02,0xFE,0x02 },
  { 0x42,0x88,0x11,0x42,0x88,0x11,0x42,0x88,0x11,0x42,0x88,0x11,0x42,0x88,0x11,0x42 },
  { 0x00,0xE0,0x10,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x10,0xE0,0x00,0x00,0x00,0x00 },
  { 0x00,0xE0,0x10,0x08,0x84,0xC4,0xC4,0xC4,0x84,0x08,0x10,0xE0,0x00,0x00,0x00,0x00 },
  { 0x00,0xFC,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0xFC,0x00,0x00,0x00,0x00 },
  { 0x00,0xFC,0x04,0x34,0x64,0x64,0xC4,0xC4,0x84,0x84,0x04,0xFC,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0xC0,0xF0,0xFC,0xFF,0xFC,0xF0,0xC0,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x03,0x0F,0x3F,0xFF,0x3F,0x0F,0x03,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0xFE,0x00,0xFE,0x00,0xFE,0x00,0xFE,0x00,0xFE,0x00,0x00,0x00,0x00 },
  { 0x00,0x54,0xAA,0x54,0xAA,0x54,0xAA,0x54,0x00,0x54,0xAA,0x54,0xAA,0x54,0xAA,0x54 },
  { 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0 },
  { 0xFF,0xFC,0xF8,0xF0,0xF0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xF0,0xF0,0xF8,0xFC,0xFF },
  { 0x00,0xC0,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xE0,0xC0,0x00 },
  { 0x00,0x00,0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x04,0x06,0xFF,0xFF,0x06,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x20,0x60,0xFF,0xFF,0x60,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 },
  { 0xFF,0xFF,0xE0,0xC0,0xC0,0xC0,0xCF,0xC7,0xC3,0xC1,0xC0,0xC0,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC0,0xC0,0xC1,0xC3,0xC7,0xCF,0xC0,0xC0,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC1,0xC3,0xC7,0xCF,0xC0,0xC0,0xCF,0xC7,0xC3,0xC1,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xC2,0xC3,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC0,0xC0,0xC0,0xC7,0xC7,0xC0,0xC0,0xC0,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC0,0xC2,0xC6,0xCF,0xCF,0xC6,0xC2,0xC0,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC1,0xC1,0xC1,0xC1,0xC1,0xC7,0xC3,0xC1,0xC0,0xE0,0xFF,0xFF },
  { 0xFF,0xFF,0xE0,0xC0,0xC1,0xC3,0xC7,0xC1,0xC1,0xC1,0xC1,0xC1,0xC0,0xE0,0xFF,0xFF },
  { 0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF,0xC0,0xDF },
  { 0xFF,0x00,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x00,0xFF },
  { 0x00,0x07,0x08,0x10,0x20,0x20,0x20,0x20,0x20,0x10,0x08,0x07,0x00,0x00,0x00,0x00 },
  { 0x00,0x07,0x08,0x10,0x21,0x23,0x23,0x23,0x21,0x10,0x08,0x07,0x00,0x00,0x00,0x00 },
  { 0x00,0x3F,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3F,0x00,0x00,0x00,0x00 },
  { 0x00,0x3F,0x20,0x20,0x20,0x20,0x2C,0x26,0x23,0x21,0x20,0x3F,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00 },
  { 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF },
  { 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01 },
  { 0xFF,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 },
  { 0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01 },
  { 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xFF },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01 },
  { 0x7E,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x00,0x7E,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x00 },
  { 0x7E,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x03,0x02,0x06,0x04,0x0C,0x88,0xD8,0x50,0x70,0x20,0x00,0x00,0x00,0x00 }
};

static Tscreen_mode_proc old_mode_proc;

void swap_chars( void )
{
  uint i,j;

  open_font_map();
  j = 0;
  switch( scr_char_size )
  {
    case  8:
      for( i = 0; i < 256; i++ )
        if( IN( graph_set8, i ) )
          xchg_char_def( i, graph_chars8[j++] );
      break;
    case 14:
      for( i = 0; i < 256; i++ )
        if( IN( graph_set14, i ) )
          xchg_char_def( i, graph_chars14[j++] );
      break;
    case 16:
      for( i = 0; i < 256; i++ )
        if( IN( graph_set16, i ) )
          xchg_char_def( i, graph_chars16[j++] );
      break;
  }
  close_font_map();
  graph_flag = !graph_flag;
}

void set_graph_chars( void )
{
  if( scr_forced_g0 ) return;
  if( !graph_flag ) swap_chars();
}

void restore_graph_chars( void )
{
  if( scr_forced_g0 ) return;
  if( graph_flag ) swap_chars();
}

#endif //NOICONS

void update_icons( void )
{
#ifndef NOICONS
  if( !scr_forced_g0 )
  {
    i_desktop = '';
    if( scr_char_size == 8 )
    {
      i_close = "|i";
      i_resize = "";
      i_maximize = "";
      i_minimize = "";
      i_maximized = "";
      i_buttonl = "|i";
      i_buttonr = "";
      i_sb_up = "";
      i_sb_down = "";
      i_sb_left = "";
      i_sb_right = "";
      i_vsb_blank = "";
      i_vsb_bar = "";
      i_hsb_blank = "";
      i_hsb_bar = "";
      i_left_line = "";
      i_right_line = "";
      i_combo_closed = "";
      i_combo_open = "";
      i_box_ul = "";
      i_box_ur = "";
      i_box_dl[0] = frame_normal[1]; i_box_dl[1] = 0;
      i_box_dr[0] = frame_normal[1]; i_box_dr[1] = 0;
      i_upper_frame = '';
      i_upper_frame_r = '';
      i_check_off = "";
      i_check_on = "";
      i_radio_off = "";
      i_radio_on = "";
      i_warning = "     \n    \n    \n    \n    \n     \n    \n     ";
      i_question = "     \n  \n   \n    \n    \n     \n    \n     ";
      i_info = "     \n    \n     \n   \n    \n    \n  \n     ";
    }
    else
    {
      i_close = "|i|i";
      i_resize = "|i|i";
      i_maximize = "|i|i";
      i_minimize = "|i|i";
      i_maximized = "|i|i";
      i_buttonl = "|i";
      i_buttonr = "";
      i_sb_up = "|i\011|i";
      i_sb_down = "|i|i";
      i_sb_left = "|i";
      i_sb_right = "|i";
      i_vsb_blank = "";
      i_vsb_bar = "|i\012|i";
      i_hsb_blank = "";
      i_hsb_bar = "";
      i_left_line = "";
      i_right_line = "";
      i_combo_closed = "|i|i";;
      i_combo_open = "|i|i";
      i_box_ul = "";
      i_box_ur = "";
      i_box_dl[0] = frame_normal[1]; i_box_dl[1] = 0;
      i_box_dr[0] = frame_normal[1]; i_box_dr[1] = 0;
      i_upper_frame = '';
      i_upper_frame_r = '';
      i_check_off = "";
      i_check_on = "";
      i_radio_off = "";
      i_radio_on = "\015";
      i_warning = "    \n    \n    \n    ";
      i_question = "  \n  \n    \n    ";
      i_info = "    \n   \n    \n  ";
    }
  }
#endif //NOICONS

  i_close_len = (char) smart_len( i_close );
  i_resize_len = (char) smart_len( i_resize );
  i_maximize_len = (char) smart_len( i_maximize );
  i_minimize_len = (char) smart_len( i_minimize );
  i_maximized_len = (char) smart_len( i_maximized );
  i_sb_up_len = (char) smart_len( i_sb_up );
  i_sb_down_len = (char) smart_len( i_sb_down );
  i_sb_left_len = (char) smart_len( i_sb_left );
  i_sb_right_len = (char) smart_len( i_sb_right );
  i_combo_closed_len = (char) smart_len( i_combo_closed );
  i_combo_open_len = (char) smart_len( i_combo_open );
  i_cluster_len = (char) smart_len( i_check_off );
  if( pal_desktop.solid ) i_desktop = ' ';
}

#if !defined( NOICONS ) && !defined( HGR )
static void mode_proc( char mode, char char_size )
{
  restore_graph_chars();
  old_mode_proc( mode, char_size );
  set_graph_chars();
  update_icons();
}

#ifndef NOCONFIG
static void read_params( void )
{
  seek_section( 0, SECTION_SCREEN );
  ini( VAR_GRAPH_CHARS, scr_forced_g0, !scr_forced_g0 );
  scr_forced_g0 = !scr_forced_g0;
}
#endif

void tini_icons( void )
{
  restore_graph_chars();
}

#endif

void __init_icons( void )
{
#ifdef NOICONS
  strcpy( frame_normal, frame_standard );
#else
  i_box_ur[0] = frame_standard[2]; i_box_ur[1] = 0;
#ifndef HGR
#ifndef NOCONFIG
  read_params();
#endif
#ifndef NOPARAM
  if( param_opt("/G+") ) scr_forced_g0 = !scr_soft_fonts;
  if( param_opt("/G-") ) scr_forced_g0 = 1;
#endif
  if( scr_forced_g0 )
    strcpy( frame_normal, frame_standard );
  else
#endif //!HGR
  {
#ifndef HGR
    old_mode_proc = hook_mode_proc( mode_proc );
#endif
    strcpy( frame_cyr, frame_normal );
    frame_standard[8] = '';
#ifdef CYR
    frame_standard[2] = '';
    frame_standard[3] = '';
    frame_standard[5] = '';
#endif
#ifndef HGR
    set_mouse_chars( "" );
#endif
  }
#ifndef HGR
  atexit( tini_icons );
#endif
#endif //NOICONS
  update_icons();
}
