
#include <stdio.h>

#include "luthor.h"

#include "basicdef.h"
#include "inidef.h"

int main(int argc,char **argv)
{
	int mainlextable,inilextable;
	int mainlexstream,inilexstream;
	int t;
	int old;

	if(argv[1]==NULL){
    	fprintf(stderr,"No input file name supplied\n");
        exit(1);
	}
    
	if(argv[2]==NULL){
    	fprintf(stderr,"No INI file name supplied\n");
        exit(1);
	}
    
    LexInit(0);		/* initialize the lex processor */

    mainlextable=LexLoadObject("basic.llt");
    inilextable=LexLoadObject("ini.llt");
	
    mainlexstream=LexInputFile(mainlextable,argv[1]);
    if(mainlexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    inilexstream=LexInputFile(inilextable,argv[2]);
    if(inilexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    printf("ini program\n");
    while((t=ThisToken(inilexstream)) != EOF){
    	t=ThisToken(inilexstream);
    	if(!t){
        	printf("token error!\n");
            exit(1);
		}
        if(t==EOF){
       		break;
		}
        printf("%d:\t",t);
    	if(t==TK_EOL){
        	printf("\\n\n");
		} else {
        	printf("->%s\n",ThisTokenText(inilexstream));
		}
        if(!AdvanceToken(inilexstream)){
        	printf("token error!\n");
            exit(1);
		}
	}
    printf("EOF\n");

    printf("main program\n");
    while((t=ThisToken(mainlexstream)) != EOF){
    	if(!t){
        	printf("token error!\n");
            exit(1);
		}
        printf("%d:\t",t);
    	if(t==TK_EOL){
        	printf("\\n\n");
		} else {
        	printf("->%s\n",ThisTokenText(mainlexstream));
		}
        if(!AdvanceToken(mainlexstream)){
        	printf("token error!\n");
            exit(1);
		}
	}
    printf("EOF\n");

    LexCloseStream(mainlexstream);
    LexCloseStream(inilexstream);
	LexFreeObject(mainlextable);
    LexFreeObject(inilextable);
    exit(0);
}

