#include <stdio.h>
#include <fcntl.h>
#include <sys\stat.h>
#include "driver.h"

char * camlrun = "camlrun.exe";
char * stdlib;
int linkalso = 1;
char * includes = "";
char * compopt = "";
char * linkopt = "";
char * linkfiles = "";
char * linkout = "camlout.exe";

main(argc, argv)
     int argc;
     char ** argv;
{
  int i;
  char * a;
  extern char * getenv();
  char * cmd;
  int status;
  
  stdlib = getenv("CAMLLIB");
  if (stdlib == NULL) {
    fprintf(stderr, "Variable CAMLLIB is undefined.\n");
    exit(2);
  }

  for (i = 1; i < argc; i++) {
    a = argv[i];
    if (suffix(a, ".ml")) {
      format(&cmd, "%s\\camlcomp -stdlib %s %s %s %s",
             stdlib, stdlib, includes, compopt, a);
      status = execute(camlrun, cmd);
      if (status != 0) exit(status);
      free(cmd);
      reformat(&linkfiles, "%s %s", linkfiles, a);
    } else
    if (suffix(a, ".mli")) {
      format(&cmd, "%s\\camlcomp -stdlib %s %s %s %s",
             stdlib, stdlib, includes, compopt, a);
      status = execute(camlrun, cmd);
      if (status != 0) exit(status);
      free(cmd);
    } else
    if (suffix(a, ".zo")) {
      reformat(&linkfiles, "%s %s", linkfiles, a);
    } else
    if (eq(a, "-c")) {
      linkalso = 0;
    } else
    if (eq(a, "-I") || eq(a, "-include")) {
      reformat(&includes, "%s -I %s", includes, argv[++i]);
    } else
    if (eq(a, "-O") || eq(a, "-open")) {
      reformat(&compopt, "%s -O %s", compopt, argv[++i]);
    } else
    if (eq(a, "-i")) {
      reformat(&compopt, "%s -i", compopt);
    } else
    if (eq(a, "-g") || eq(a, "-debug")) {
      reformat(&linkopt, "%s -g", linkopt);
    } else
    if (eq(a, "-o") || eq(a, "-exec")) {
      linkout = argv[++i];
    } else
    if (eq(a, "-stdlib")) {
      stdlib = argv[++i];
    } else
    if (eq(a, "-v") || eq(a, "-version")) {
      printf("The Caml Light system for the 80386 PC, version 0.5\n");
      printf("  (standard library from %s)\n", stdlib);
      execute(camlrun, "-V");
      format(&cmd, "%s\\camlcomp -version", stdlib);
      execute(camlrun, cmd);
      free(cmd);
      format(&cmd, "%s\\camllink -version", stdlib);
      execute(camlrun, cmd);
      free(cmd);
    } else
    if (eq(a, "-files")) {
      reformat(&linkfiles, "%s -files %s", linkfiles, argv[++i]);
    } else
    if (prefix(a, "-")) {
      fprintf(stderr, "Unknown option \"%s\", ignored\n", a);
    } else {
      fprintf(stderr, "I don't know what to do with file \"%s\", ignored\n",
              a);
    }
  }
  
  if (linkalso && linkfiles[0] != 0) {
    format(&cmd,
           "%s\\camllink -stdlib %s %s %s -exec %s %s\\stdlib.zo %s",
           stdlib, stdlib, includes,
           linkopt, linkout, stdlib, linkfiles);
    terminate(camlrun, cmd);
  }
  return 0;
}
