(* $Id$ *)

let char_stream_of_string s = cs 0
  where rec cs i =
    if i >= string_length s then [< >]
    else [< 'nth_char s i; cs (i+1) >]
;;

let char_stream_of_channel ic =
  stream_from (fun () -> input_char ic)
;;

let char_stream_of_stdin =
  stream_from (fun () -> input_char stdin)
;;
