page ,132

;--------------------------------------------------------------------------
; Filename: 	VGAZOOM1.ASM
; Program name:	VGAZOOM.COM
;
; Link with:	VGAZOOM2.OBJ (Hidden mode driver module)
;
; Description:	This program demonstrates hidden VGA modes. The program
;		is a Terminate-And-Stay-Resident module that provides
;		elementary Video BIOS support for the hidden modes.
;		Applications that only use MS-DOS function 09h (print 
;		string) for video output, should work with this program. 
;
;		The program traps the Int 10h vector to provide extended
;		BIOS support. The program also traps int 9h (keyboard), 
;		to handle detection of Hotkeys for panning and mode 
;		switching etc.
;
; Version:	1.0
; Date:		June 8, 1988
;
; (c) Arun Johary, Bo Ericsson 1988
;--------------------------------------------------------------------------


;------	equates -------------------------------------------------------
TRUE		equ	1
FALSE		equ	0
CR		equ	0dh
LF		equ	0ah
BS		equ	08h
EOS		equ	'$'
ACTIVE		equ	TRUE
INACTIVE	equ	FALSE
LORES		equ	0
HIRES		equ	1
HIDDENMODE	equ	21h

CTRLMAKE		equ	01dh
CTRLBREAK		equ	09dh
SETLORES		equ	1
SETLORESMAKE		equ	050h
SETLORESBREAK		equ	0d0h
SETHIRES		equ	2
SETHIRESMAKE		equ	048h
SETHIRESBREAK		equ	0c8h
PANRIGHTONE		equ	3
PANRIGHTONEMAKE		equ	04dh
PANRIGHTONEBREAK	equ	0cdh
PANLEFTONE		equ	4
PANLEFTONEMAKE		equ	04bh
PANLEFTONEBREAK		equ	0cbh


;------ externals -----------------------------------------------------
extrn	SetMode:near
extrn	DrawChr:near
extrn	Horiz_Scroll_4:near
extrn	EndOfProgram:byte


;------	macros --------------------------------------------------------
pushall	macro
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	push	es
	push	bp
	endm

popall	macro
	pop	bp
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	endm


;------	structures ----------------------------------------------------


;------ code segment --------------------------------------------------
code segment para public 'code'
	assume cs:code, ds:code, es:code, ss:code
	org	100h
begin:
	jmp	Main


;------ data area -----------------------------------------------------
Msg0	db	'VGAZOOM.COM - VGA hidden mode driver - Ver. 1.0', CR, LF
	db	'  Program by Arun Johary and Bo Ericsson', CR, LF, LF, EOS  
Msg1	db	'Program installed', CR, LF, EOS
Msg2	db	'New program did not install', CR, LF, EOS
Msg3	db	'Program already installed', CR, LF, EOS
Msg4	db	'VGA not present. Program did not install', CR, LF, EOS

Msg5	db	'To set High resolution (1280x400), press Ctrl Up-Arrow', CR, LF
	db	'To set Low resolution, (640x400) press Ctrl Down-Arrow', CR, LF
	db	'To Pan right in Low resolution, press Ctrl Right-Arrow', CR, LF
	db	'To Pan left in Low resolution, press Ctrl Left-Arrow', CR, LF, LF, EOS

Command		db	0
Status		db	HIRES
VideoMode	db	0

CtrlStatus		db	FALSE
LoResStatus		db	FALSE
HiResStatus		db	FALSE
PanRightOneStatus	db	FALSE
PanLeftOneStatus	db	FALSE
PanPosition		dw	0

ScanCode	db	0

MemOffset	dw	00000h
MemSegment	dw	0a000h
FontOffset	dw	0
FontSegment	dw	0


;-----------------------------------------------------------------------
Main proc near

;------ are we already installed?
	call	CheckAlreadyInstalled
	jc	MainError

;------ is this a VGA environment?
	mov	ax, 1a00h
	int	10h
	cmp	al, 1ah
	jne	NotVGA

	call	SetNewVideoVector
 	call	SetNewKeyboardVector

;------ display initial greeting
	mov	ax, HIDDENMODE
	int	10h
	mov	dx, offset Msg0
	mov	ah, 9
	int	21h
	mov	dx, offset Msg1
	mov	ah, 9
	int	21h
	mov	dx, offset Msg5
	mov	ah, 9
	int	21h

	call	TerminateButStayResident

;------ TSR failed
MainError:
	mov	ax, HIDDENMODE
	int	10h
	mov	dx, offset Msg0
	mov	ah, 9
	int	21h
	mov	dx, offset Msg3
	mov	ah, 9
	int	21h
	mov	dx, offset Msg2
	mov	ah, 9
	int	21h
	mov	dx, offset Msg5
	mov	ah, 9
	int	21h
	ret

;------ VGA environment not found
NotVGA:
	mov	dx, offset Msg0
	mov	ah, 9
	int	21h
	mov	dx, offset Msg4
	mov	ah, 9
	int	21h
	ret
	

Main endp


;-----------------------------------------------------------------------
CheckAlreadyInstalled proc near

;------ get video interrupt vector
	mov	ah, 35h			;get interrupt vector function
	mov	al, 10h			;vector number
	int	21h			;execute! (returns es:bx)
	
;------ look for already-present marker
	cld				;forward direction
	mov	di, bx
	add	di, Marker-VideoHandler	;offset to marker string
	mov	si, offset Marker	;offset to our string
	mov	cx, MarkerEnd-Marker	;length of string
	repe	cmpsb			;compare the strings
	jcxz	AlreadyLoaded		;compare ok, handler already loaded
	jmp	NotAlreadyLoaded	;compare not ok, handler not there

;------ Program already loaded
AlreadyLoaded:
	stc				;error= set carry flag
	ret

;------ New installation
NotAlreadyLoaded:
	clc				;success= cleared carry flag  
	ret
	
CheckAlreadyInstalled endp


;-----------------------------------------------------------------------
SetNewVideoVector proc near

;------ get old video interrupt vector
	mov	ah, 35h			;get interrupt vector function
	mov	al, 10h			;video vector 
	int	21h			;execute! (returns es:bx)

;------ and store it
	mov	cs:OldVideoOffs0, bx	;store offset of old handler
	mov	cs:OldVideoOffs1, bx	;store offset of old handler
	mov	ax, es
	mov	cs:OldVideoSeg0, ax	;store segment of old handler
	mov	cs:OldVideoSeg1, ax	;store segment of old handler

;------ link our handler into the chain 
	mov	ah, 25h			;set interrupt vector function
	mov	al, 10h			;interrupt number
	mov	dx, offset VideoHandler ;ds:dx= address to handler
	int	21h			;execute!

;------ locate 8*8 font in ROM
	mov	ah, 11h
	mov	al, 30h
	mov	bh, 03h
	int	10h
	mov	cs:FontSegment, es
	mov	cs:FontOffset, bp
	ret

SetNewVideoVector endp


;-----------------------------------------------------------------------
SetNewKeyboardVector proc near

;------ get keyboard interupt vector
	mov	ah, 35h			; get vector function call
	mov 	al, 9h			; int 9h vector
	int 	21h			; dos call
	mov	ax, es			; es contains cs
	mov	cs:OldKeyboardSegment, ax ; save cs
	mov	cs:OldKeyboardOffset, bx ; save ip

;------ set new keyboard interupt vector
	push	cs
	pop	ds
	mov	dx,offset KeyboardHandler ; specify offset to keyboard int trap
	mov 	ah, 25h			; set vector function call
	mov	al, 9h			; int 9h vector
 	int 	21h			; dos call

	ret

SetNewKeyboardVector endp


;-----------------------------------------------------------------------
TerminateButStayResident proc near

	mov	dx, offset EndOfProgram	;divide offset of end of program
	mov	cl, 4
	shr	dx, cl			;by four
	inc	dx			;and increment result by 1

	mov	ah, 31h			;terminate but stay resident func
	mov	al, 0			;return code
	int	21h			;execute

	stc				;could not TSR the program
	ret

TerminateButStayResident endp


;-----------------------------------------------------------------------
VideoHandler proc far

;------ trap entry to old video handler
	call	PreBios

;------ call old video handler
		pushf
LongCall0	db	09ah		
OldVideoOffs0	dw	0
OldVideoSeg0	dw	0

;------ trap exit from old video handler
	call	PostBios

;------ return to application
	iret

Marker		db	'Hidden VGA mode program'
MarkerEnd	label 	byte

VideoHandler endp


;-----------------------------------------------------------------------
PreBios proc near

	cmp	ah, 0
	je	PreBiosModeSet
	cmp	ah, 0eh
	je	PreBiosTTYOutput
	cmp	ah, 6
	je	PreBiosScroll
	ret

PreBiosModeSet:
	call	HandlePreModeSet
	ret

PreBiosTTYOutput:
	call	HandlePreTTYOutput
	ret

PreBiosScroll:
	call	HandlePreScroll
	ret

PreBios endp


;-----------------------------------------------------------------------
HandlePreModeSet proc near

	mov	cs:VideoMode, al
	cmp	al, HIDDENMODE
	je	SetHiddenMode
	ret

SetHiddenMode:
	pushall

	mov	ax, 0eh
		pushf
LongCall1	db	09ah		
OldVideoOffs1	dw	0
OldVideoSeg1	dw	0

;set the hidden mode here

	mov	ax, HIRES
	call	SetMode
	mov	cs:Status, HIRES
	mov	ax, 40h
	mov	ds, ax
	mov	bx, 4ah
	mov	[bx], byte ptr 160
	mov	bx, 84h
	mov	[bx], byte ptr 49
	mov	bx, 49h
	mov	[bx], byte ptr HIDDENMODE
	mov	cs:MemOffset, 0
	mov	cs:PanPosition, 0
	popall
	add	sp, 4
	iret

HandlePreModeSet endp


HandlePreScroll proc near
	
	cmp	cs:VideoMode, HIDDENMODE
	je	HiddenScroll
	ret

HiddenScroll:
	pushall
	call	ScrollOneLine
	popall
	add	sp, 4
	iret

HandlePreScroll endp


;-----------------------------------------------------------------------
HandlePreTTYOutput proc near

	cmp	cs:VideoMode, HIDDENMODE ;is this a request for a hidden mode
	je	HiddenTTY		;yes, handle the tty output
	ret

HiddenTTY:
	pushall
	call	HandleHiddenTTY
	popall
	add	sp, 4
	iret

HandlePreTTYOutput endp


;----------------------------------------------------------------------
HandleHiddenTTY proc near

	cmp	al, 32
	jl	TTYControlChar
	mov	bx, 160
	mov	dx, 8
	mov	cx, 50
	mov	si, offset MemOffset
	lds	si, cs:[si]
	push	si
	mov	di, offset FontOffset
	les	di, cs:[di]
	call	DrawChr
	pop	si

	inc	si
	mov	cs:MemOffset, si
	ret

TTYControlChar:
	cmp	al, CR
	jne	TestLF
	call	HandleCR
	ret
TestLF:
	cmp	al, LF
	jne	TestTAB
	call	HandleLF
	ret
TestTAB:
	cmp	al, BS
	jne	HandleTTYEnd
	call	HandleBS
	ret

HandleTTYEnd:
	ret

HandleHiddenTTY endp

HandleCR proc near

	int	3
	xor	dx, dx
	mov	ax, cs:MemOffset
	mov	bx, 160
	div	bx
	xor	dx, dx
	mul	bx
	mov	cs:MemOffset, ax
	ret

HandleCR endp

HandleLF proc near

	mov	ax, cs:MemOffset
	add	ax, 160*8
	cmp	ax, 50*8*160
	jb	HandleLF1
	sub	ax, 160*8
	push	ax
	call	ScrollOneLine
	pop	ax

HandleLF1:
	mov	cs:MemOffset, ax
	ret

HandleLF endp

HandleBS proc near

	mov	ax, cs:MemOffset
	dec	ax
	mov	cs:MemOffset, ax
	ret

HandleBS endp

ScrollOneLine proc near

	mov	ax, 0a000h
	mov	es, ax
	mov	ds, ax
	xor	di, di
	mov	si, 160*8
	mov	cx, (49*8*160)/2
	cld
	rep	movsw
	mov	cx, (1*8*160)/2
	xor	ax, ax
	rep	stosw
	ret

ScrollOneLine endp


;----------------------------------------------------------------------
PostBios proc near

	ret

PostBios endp


;------------------------------------------------------------------------
KeyboardHandler proc near

;------ save processor state
	pushall

;------ check if our key combination is pressed
	call	CheckOurKeys
	jnc	Keyboard00

	cmp	cs:Command, SETHIRES
	je	HandleSetHires
	cmp	cs:Command, SETLORES
	je	HandleSetLores
	cmp	cs:Command, PANRIGHTONE
	je	HandlePanRightOne
	cmp	cs:Command, PANLEFTONE
	je	HandlePanLeftOne
	jmp	Keyboard00

HandleSetLores:
	mov	ax, LORES
	call	SetMode
	mov	cs:Status, LORES
	jmp	Keyboard00

HandleSetHires:
	mov	ax, HIRES
	call	SetMode
	mov	cs:Status, HIRES
	jmp	Keyboard00

HandlePanRightOne:
	cmp	cs:Status, HIRES
	je	Keyboard00
	cmp	cs:PanPosition, 640
	je	Keyboard00
	mov	ax, 1
	call	Horiz_Scroll_4
	inc	cs:PanPosition
	jmp	Keyboard00

HandlePanLeftOne:
	cmp	cs:Status, HIRES
	je	Keyboard00
	cmp	cs:PanPosition, 0
	je	Keyboard00
	mov	ax, -1
	call	Horiz_Scroll_4
	dec	cs:PanPosition
	jmp	Keyboard00

;------ restore processor state
Keyboard00:
	popall

;------ jump to the original keyboard routine
LongJump		db	0eah	
OldKeyboardOffset	dw	0
OldKeyboardSegment	dw	0

KeyboardHandler	endp


;----------------------------------------------------------------------
CheckOurKeys proc near

	int	3
	cmp	cs:VideoMode, HIDDENMODE
	je	ReadInKey
	jmp	KeyNoTest

;------ read in the key from port 60h
ReadInKey:
	mov	dx,60h
	in 	al,dx
	mov	cs:ScanCode,al

;------ check the control key
	cmp	al, CTRLMAKE
	jne	Key00
	mov	cs:CtrlStatus, TRUE
	jmp	KeyTest

Key00:
	cmp	al, CTRLBREAK
	jne	Key01
	mov	cs:CtrlStatus, FALSE
	jmp	KeyNoTest

;------ check SETLORES KEY
Key01:
	cmp	al, SETLORESMAKE
	jne	Key02
	mov	cs:LoResStatus, TRUE
	jmp	KeyTest
Key02:
	cmp	al, SETLORESBREAK
	jne	Key03
	mov	cs:LoResStatus, FALSE
	jmp	KeyNoTest

;------ check SETHIRES KEY
Key03:
	cmp	al, SETHIRESMAKE
	jne	Key04
	mov	cs:HiResStatus, TRUE
	jmp	KeyTest
Key04:
	cmp	al, SETHIRESBREAK
	jne	Key05
	mov	cs:HiResStatus, FALSE
	jmp	KeyNoTest

;------ check PANRIGHTONE KEY
Key05:
	cmp	al, PANRIGHTONEMAKE
	jne	Key06
	mov	cs:PanRightOneStatus, TRUE
	jmp	KeyTest
Key06:
	cmp	al, PANRIGHTONEBREAK
	jne	Key07
	mov	cs:PanRightOneStatus, FALSE
	jmp	KeyNoTest

;------ check PANLEFTONE KEY
Key07:
	cmp	al, PANLEFTONEMAKE
	jne	Key08
	mov	cs:PanLeftOneStatus, TRUE
	jmp	KeyTest
Key08:
	cmp	al, PANLEFTONEBREAK
	jne	Key09
	mov	cs:PanLeftOneStatus, FALSE
	jmp	KeyNoTest

Key09:
	jmp	KeyNoTest

;------ test if any of our combinations are present
KeyTest:
	cmp	cs:CtrlStatus, TRUE
	jne	KeyNoTest

	cmp	cs:LoResStatus, TRUE
	jne	KeyTest0
	mov	cs:Command, SETLORES
	jmp	KeyFound
KeyTest0:
	cmp	cs:HiResStatus, TRUE
	jne	KeyTest1
	mov	cs:Command, SETHIRES
	jmp	KeyFound
KeyTest1:
	cmp	cs:PanRightOneStatus, TRUE
	jne	KeyTest2
	mov	cs:Command, PANRIGHTONE
	jmp	KeyFound
KeyTest2:
	cmp	cs:PanLeftOneStatus, TRUE
	jne	KeyTest3
	mov	cs:Command, PANLEFTONE
	jmp	KeyFound
KeyTest3:


	jmp	KeyNoTest

;------ our key combination is present
KeyFound:
	stc
	ret

KeyNoTest:
	clc
	ret
CheckOurKeys endp


;----------------------------------------------------------------------
Beep	proc near

BEEPFREQ	equ	2000
BEEPLEN		equ	5000
; ax= frequency of tone

	mov	ax, 1000
	call	tone_init
	call	tone_on
	mov	cx, BEEPLEN
shb01:
	loop	shb01
	call	tone_off
	mov	cx, BEEPLEN
shb02:
	loop	shb02
	ret

Beep	endp


;-----------------------------------------------------------------------
tone_init proc near

;------ frequency in ax
	push	ax
	mov	al,0b6h
	out	43h,al
	pop	ax

	mov	bx,ax
	out	42h,al
	jmp	short $+2
	mov	al,bh
	out	42h,al

	ret

tone_init endp


;-----------------------------------------------------------------------
tone_on proc near

	in	al,61h
	jmp	short $+2
	jmp	short $+2
	or	al,3
	out	61h,al

	ret
tone_on endp


;-----------------------------------------------------------------------
tone_off proc near

	in	al,61h
	jmp	short $+2
	jmp	short $+2
	and	al,0fch
	out	61h,al

	ret
tone_off endp


;------	end of module -------------------------------------------------
code ends
end begin
