DATABASES

YESNO.PRG

***********************************************************************
* FUNCTION YesNo(msg1, msg2, title, colscheme)
*
* Display a Yes/No/Cancel dialog and return a response.
*
* Usage:
*     msg1 = "Are you sure you want to"
*     msg2 = "exit this application?"
*     title = " ALERT "
*     colscheme = 8
*     answer = YesNo(msg1, msg2, title, colscheme)
*
***********************************************************************
FUNCTION YesNo
PARAMETERS text1, text2, title, colscheme

DEFINE WINDOW yesno FROM 7, 15 TO 15, 65 TITLE "&title" COLOR SCHEME colscheme
ACTIVATE WINDOW yesno
@ 1, (50-len(text1))/2 SAY text1       && Display first message
@ 2, (50-len(text2))/2 SAY text2       && Display second message

DEFINE MENU yesno COLOR SCHEME colscheme
DEFINE PAD yes          OF yesno PROMPT '<   \<Yes   >'  AT 04,03
DEFINE PAD no           OF yesno PROMPT '<   \<No    >'  AT 04,17
DEFINE PAD cancel       OF yesno PROMPT '<  \<Cancel  >' AT 04,31
ON SELECTION PAD yes    OF yesno DEACTIVATE MENU yesno
ON SELECTION PAD no     OF yesno DEACTIVATE MENU yesno
ON SELECTION PAD cancel OF yesno DEACTIVATE MENU yesno

ACTIVATE MENU yesno PAD no             && Get Yes, No or Cancel
DO CASE
CASE PAD()=="YES"                      && Set retcode
     STORE .T. TO retcode
OTHERWISE
     STORE .F. TO retcode
ENDCASE

RELEASE MENU yesno
RELEASE WINDOW yesno
RETURN retcode
* eof
