/*----------------------------------------------------------------
   SHOWTIME.C -- Displays current time from second thread in OS/2
                 (C) 1988, Ziff-Davis Communications Company
                 PC Magazine * Programmed by Charles Petzold, 11/87
  ----------------------------------------------------------------*/

#include <doscalls.h>
#include <subcalls.h>

void far ShowTimeThread (void) ;

main ()
     {
     unsigned char  ThreadStack [1024] ;
     unsigned int   ThreadID ;
     struct KeyData kd ;

     if (DOSCREATETHREAD (ShowTimeThread, &ThreadID, ThreadStack + 1024))
          {
          puts ("SHOWTIME: Could not create thread") ;
          return 1 ;
          }

     KBDCHARIN (&kd, 0, 0) ;

     return 0 ;
     }

void far ShowTimeThread ()
     {
     char            buffer [10] ;
     struct ModeData md ;
     struct DateTime dt ;

     md.length = sizeof (md) ;

     VIOGETMODE (&md, 0) ;
     while (1)
          {
          DOSSLEEP (1000L) ;

          DOSGETDATETIME (&dt) ;

          sprintf (buffer, "%2d:%02d:%02d", dt.hour, dt.minutes, dt.seconds) ;

          VIOWRTCHARSTR (buffer, 8, 0, md.col - 8, 0) ;
          }
     }
