
{$R+,C-}
TYPE
  str255 = STRING[255];
  bigarray = ARRAY[1..32767] OF Char;
VAR
  buffer : BigArray;
  search : str255;
  result : Integer;

  FUNCTION pos_array(buffer : BigArray; start : Integer;
                     finish : Integer; what : str255) : Integer;

  (* To make the function ignore upper/lower CASE distinctions,
     find each occurrence of the marker "{uc}" and replace it
     with the TURBO function "UpCase"  *)
  VAR
    found   : Boolean;
    L       : Byte;
    rest, P : Integer;
  BEGIN
    found := False;
    L := Length(what);
    WHILE (found = False) AND ((start < finish-L) AND (start > -1)) DO
      BEGIN
        start := start+L;
        rest  := 1;
        WHILE Pos({uc}(buffer[start]), Copy(what, rest+1, L-rest)) > 0 DO
          BEGIN
            rest  := rest+Pos({uc}(buffer[start]), Copy(what, rest+1, L-rest));
            start := start-rest+1;
            P := 0;
            REPEAT
              P := P+1;
            UNTIL {uc}(what[P]) <> {uc}(buffer[start+P-1]);
            IF P > L THEN
              found := True
            ELSE start := start+rest-1;
          END;                {if rest>0 then}
      END;                    {while (found=false) and (start<finish) do}
    IF found THEN pos_array := start ELSE pos_array := 0;
  END;                        {procedure pos_array}

  PROCEDURE test(S : str255);
    PROCEDURE explain(R : Integer);
    BEGIN
      IF R > 0 THEN
        WriteLn('Found string at position ', R)
      ELSE
        WriteLn('String is not present');
    END;

  BEGIN
    WriteLn;
    WriteLn('Searching for "', S, '"');
    Write('POS_ARRAY:  ');
    result := pos_array(buffer, 0, 32767, S);
    explain(result);
  END;

BEGIN
  FillChar(buffer, SizeOf(buffer), #0);
  search := 'Now is the time'; { Search string }
  Move(search[1], buffer[10000], Length(search));
  test(search);
  test('The quick brown fox');
  test('DOG');
END.
                                                          