//***********************************************************************
//
//  DrawDoc.cpp
//
//***********************************************************************

#include <afxwin.h>
#include <afxcoll.h>
#include "Circle.h"
#include "DrawDoc.h"

IMPLEMENT_DYNCREATE (CDrawDoc, CDocument)

void CDrawDoc::DeleteContents ()
{
    POSITION pos = m_list.GetHeadPosition ();

    while (pos != NULL)
        delete m_list.GetNext (pos);

    m_list.RemoveAll ();
}

void CDrawDoc::Serialize (CArchive& ar)
{
    m_list.Serialize (ar);
}

CCircle* CDrawDoc::AddCircle (CPoint point1, CPoint point2)
{
    CCircle* pCircle;
    try {
        CRect rect (point1.x, point1.y, point2.x, point2.y);
        pCircle = new CCircle (rect);
        m_list.AddTail (pCircle);
        SetModifiedFlag ();
    }
    catch (CMemoryException* e) {
        if (pCircle != NULL) {
            delete pCircle;
            pCircle = NULL;
        }
        AfxMessageBox ("Out of memory", MB_ICONSTOP | MB_OK);
        e->Delete ();
    }
    return pCircle;
}

POSITION CDrawDoc::GetFirstCirclePosition ()
{
    return m_list.GetHeadPosition ();
}

CCircle* CDrawDoc::GetNextCircle (POSITION& pos)
{
    return (CCircle*) m_list.GetNext (pos);
}
