/*
 *  Program to search text files for sound-alike words using the Soundex
 *  algorithm. Published in the Volume 14, Number 10 issue of PC Magazine.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

int cmpline (char *, char *);
int getword (char *, char *);
int scodeequal (char *, char *);
void soundex (char *, char *);

main (int argc, char *argv[])
{
    FILE *file;
    char line[256], scode[4];
            
    if (argc < 3) {
        printf ("Syntax: PS filename string\n");
        return 1;
    }
    
    if ((file = fopen (argv[1], "rt")) == NULL) {
        printf ("Error: File not found\n");
        return 2;
    }
    
    soundex (scode, argv[2]);

    while (fgets (line, sizeof (line), file) != NULL) {
        if (cmpline (line, scode))
            printf (line);
    }

    fclose (file);  
    return 0;
}

int cmpline (char *line, char *scode1)
{
    char scode2[4];
    char word[256];
    int count, i;

    i = 0;
    while ((count = getword (word, &line[i])) != -1) {
        soundex (scode2, word);
        if (scodeequal (scode1, scode2))
            return 1;
        i += count;
    }
    return 0;
}

int getword (char *dest, char *src)
{
    int i, j;
    
    i = j = 0;

    while (!(isalpha (src[i]))) {
        if ((src[i] == 0x00) || (src[i] == 0x10))
            return -1;
        i++;
    }
            
    while (isalpha (src[i]))
        dest[j++] = src[i++];

    dest[j] = 0x00;
    return i;
}

int scodeequal (char *scode1, char *scode2)
{
    return ((scode1[0] == scode2[0]) && (scode1[1] == scode2[1]) &&
        (scode1[2] == scode2[2]) && (scode1[3] == scode2[3])) ? 1 : 0;
}

void soundex (char *scode, char *string)
{
    static char lettervals[26] = {
        0x00, 0x01, 0x02, 0x03, 0x00, 0x01, 0x02, 0x00, 0x00,
        0x02, 0x02, 0x04, 0x05, 0x05, 0x00, 0x01, 0x02, 0x06,
        0x02, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02
    };

    int i, j;
    char ch, code;
    
    _strupr (string);
    scode[0] = string[0];
    scode[1] = 0x00;
    scode[2] = 0x00;
    scode[3] = 0x00;

    i = j = 1;

    while (j < 4) {
        ch = string[i++];

        if (ch == 0)
            break;

        if (ch != string[i]) {
            code = lettervals[ch-0x41];
            if (code)
                scode[j++] = code;
        }
    }
}
 