
*********************************************************************
* RECDX.PRG  v1.1                                         FoxPro 2.5
* Generate index commands to recreate all of the tags in a CDX file.
*
* Sample call: DO RECDX WITH cRetable, cRecdx, cReprg
* where cRetable is the DBF associated with the CDX
*       cRecdx is the CDX file whose tags will be recreated
*       cReprg is the file for the generated source code
*********************************************************************
PARAMETER cRetable, cRecdx, cReprg
IF EMPTY(cRetable) OR EMPTY(cRecdx) OR EMPTY(cReprg)
   ? "RECDX - Generate code to recreate existing tags"
   ? "Example: DO GENCDX WITH cGentable, cGencdx, cGenprg"
   RETURN
ENDIF
SET TEXTMERGE ON                 && Turn on textmerge
SET TEXTMERGE TO (cReprg)        && Send merged output to
SET TEXTMERGE NOSHOW             && Disable screen display of output

nWorkarea = SELECT(0)            && Save the current work area number
SELECT 0                         && Select a work area
USE (cRetable) AGAIN             && Open table
SET INDEX TO (cRecdx)            && Open cdx

\\*******************************************************************
\* <<cReprg>>
\* Program to recreate index tags for the table named <<cRetable>>,
\* stored in the CDX file named <<cRecdx>>
\********************************************************************
\USE <<cRetable>> EXCLUSIVE      && Open table
\SET INDEX TO <<cRecdx>>         && Open cdx
\DELETE TAG ALL                  && Delete all existing tags
*
* Generate INDEX command for each existing tag
*
FOR x = 1 TO 9999999             && Loop for each tag
  IF "" = TAG(x)                 && Empty tag means we're done
     EXIT
  ENDIF
  \WAIT WINDOW NOWAIT "Indexing on << ALLTRIM(SYS(14,x)) >>
   Tag << ALLTRIM(TAG(x)) >> of << cRecdx >>"
<<< editor note: shade these last two lines, starting with \WAIT >>>
  IF "2.5" $ VERSION()           && Use ISDESCEND for 2.5
     \INDEX ON << SYS(14,x) >> TAG <<TAG(x) >> OF <<cRecdx>>
       << IIF(EMPTY(SYS(2021,x)),"","FOR "+SYS(2021,x)) >>
       << IIF(ISDESCEND(x),"DESCENDING","") >>
<<< editor note: shade these last three lines, starting with \INDEX >>>
  ELSE
     \INDEX ON << SYS(14,x) >> TAG << TAG(x) >> OF <<cRecdx>>
       << IIF(EMPTY(SYS(2021,x)),"","FOR "+SYS(2021,x)) >>
       << IIF(DESCENDING(x),"DESCENDING","") >>
       << IIF(UNIQUE(x),"UNIQUE","") >>
<<< editor note: shade these last four lines, starting with \INDEX >>>
  ENDIF
ENDFOR
\WAIT CLEAR
\FLUSH
\USE
\RETURN

USE                              && Close database and cdx file
SET TEXTMERGE OFF                && Turn off textmerge
SET TEXTMERGE TO
FLUSH
SELECT (nWorkarea)               && Return to the proper work area
RETURN

*********************************************************************
* ISDESCEND(x) - Return .T. if Tag x is descending,       FoxPro 2.5
*                .F. otherwise
*********************************************************************
FUNCTION ISDESCEND
PARAMETER nTag
cOrd = SET("ORDER")
SET ORDER TO TAG nTag
lAns = "DESCENDING" $ SET("ORDER")
SET ORDER TO &cOrd
RETURN lAns
