/*----------------------------------------
   ENDJOIN.C -- Geometric Ends and Joins
                (c) Charles Petzold, 1993
  ----------------------------------------*/

#include <windows.h>

char szClass [] = "EndJoin" ;
char szTitle [] = "EndJoin: Geometric Ends and Joins" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static DWORD aiEnd  [] = { PS_ENDCAP_ROUND, PS_ENDCAP_SQUARE,
                                PS_ENDCAP_FLAT } ;
     static DWORD aiJoin [] = { PS_JOIN_ROUND,   PS_JOIN_BEVEL,
                                PS_JOIN_MITER } ;
     int          i ;
     LOGBRUSH     lb ;
     POINT        pt [3] ;

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea, cyArea, NULL) ;

     lb.lbStyle = BS_SOLID ;
     lb.lbColor = RGB (128, 128, 128) ;
     lb.lbHatch = 0 ;

     for (i = 0 ; i < 3 ; i++)
          {
          SelectObject (hdc,
               ExtCreatePen (PS_SOLID | PS_GEOMETRIC | aiEnd [i] | aiJoin [i], 10,
                             &lb, 0, NULL)) ;

          pt[0].x = 10 + 30 * i ;  pt[0].y = 25 ;
          pt[1].x = 20 + 30 * i ;  pt[1].y = 75 ;
          pt[2].x = 30 + 30 * i ;  pt[2].y = 25 ;

          Polyline (hdc, pt, 3) ;

          DeleteObject (
               SelectObject (hdc,
                    GetStockObject (BLACK_PEN))) ;

          Polyline (hdc, pt, 3) ;
          }

     }
