#include "animator.h"

short NEAR PASCAL WritePrivateProfileInt (LPSTR, LPSTR, short, LPSTR);

//////////////////////////////////////////////////////////////////////////
// ShowCommonDialog - sets up the OPENFILE data structure, and 
// lets the COMMDLG dll fire away. returns true if user hits ok.
//////////////////////////////////////////////////////////////////////////

BOOL WINAPI ShowCommonDialog (HWND hwnd, LPSTR * lpszFilter, 
    LPSTR lpszFile, LPSTR lpszTitle, LPSTR lpszDefExt, BOOL fSave)
{
    OPENFILENAME     ofn;
    BOOL             fResult;

    memset ((VOID *)&ofn, 0x00, sizeof(OPENFILENAME));

    ofn.lStructSize = sizeof (OPENFILENAME);
    ofn.hwndOwner = hwnd;
    ofn.lpstrFilter = (LPSTR)lpszFilter[0];
    ofn.nFilterIndex = 0L;
    ofn.lpstrFile = lpszFile;
    ofn.nMaxFile = MAX_FILE_SIZE;
    ofn.lpstrTitle = (LPSTR)lpszTitle;
    ofn.lpstrDefExt = lpszDefExt;

    if (fSave)
    {
        ofn.Flags = OFN_OVERWRITEPROMPT;
        fResult = GetSaveFileName((LPOPENFILENAME)&ofn);
    }
    else
    {
        fResult = GetOpenFileName((LPOPENFILENAME)&ofn);
    }

    return fResult;
}


//////////////////////////////////////////////////////////////////////////
// SaveIconsToFile - basically handles all of the file i/o to the
// script file specified.  Records the time interval, number of 
// icons, and icon file pathnames in .INI file format.
//////////////////////////////////////////////////////////////////////////

VOID WINAPI SaveIconsToFile (HWND hwnd, WORD wAction)
{
    char szInt[16], _szIconPath[MAX_FILE_SIZE];
    short i, sChild;

    if (!IsWindow) return;

    sChild = WINDOWNUM(hwnd);

    if ( (wAction == IDM_SAVEAS) || (!SZFILENAME(sChild)[0]))
    {
        lstrcpy ((LPSTR)_szIconPath, (LPSTR)SZFILENAME(sChild));

        if (!ShowCommonDialog(_hwndFrame, _lpszScriptFilter, (LPSTR)_szIconPath, 
            (LPSTR)"File Save As...\0", (LPSTR)_szExtension, TRUE))
        {
            goto Err;
        }

        lstrcpy ((LPSTR)SZFILENAME(sChild), (LPSTR)_szIconPath);

        SetWindowText (hwnd, (LPSTR)_szIconPath);
    }

    // Write the "Info" application section...
    
    if (!WritePrivateProfileInt ((LPSTR)_szInfo, (LPSTR)_szTimeInt, 
        TIMEINT(sChild), (LPSTR)SZFILENAME(sChild)))
    { 
        MESSAGE (IDS_TimeIntervalErr);
        goto Err; 
    }

    if (!WritePrivateProfileInt ((LPSTR)_szInfo, (LPSTR)_szNumIcons,
        NUMICONS(sChild), (LPSTR)SZFILENAME(sChild)))
    { 
        MESSAGE (IDS_NumInterval);
        goto Err; 
    }

    if (!WritePrivateProfileInt ((LPSTR)_szInfo, (LPSTR)_szAutoAnimateKey,
        (short)AUTOANIMATE(sChild), (LPSTR)SZFILENAME(sChild)))
    { 
        MESSAGE (IDS_AutoAnimateErr);
        goto Err; 
    }

    if (!WritePrivateProfileString ((LPSTR)_szInfo, (LPSTR)_szLinkFile,
        (LPSTR)SZEXELINK(sChild), (LPSTR)SZFILENAME(sChild)))
    { 
        MESSAGE (IDS_LinkFileErr);
        goto Err; 
    }

    // First, lets delete the entire [Icons] section using the
    // function WritePrivateProfileString.  This gets rid of 
    // extra Icon#= keynames if less icons are being saved.

    if (!WritePrivateProfileString ((LPSTR) _szIconSection, (LPSTR)NULL,
            (LPSTR)NULL,(LPSTR) SZFILENAME(sChild)))
    { 
        MESSAGE (IDS_IconsDelete);
        goto Err; 
    }

    // Write the "Icons" application section...

    for (i=1 ; i<=(short)NUMICONS(sChild) ; i++)
    {
        wsprintf ((LPSTR)szInt,"%s%d", (LPSTR)_szIcon, i);

        ListBox_GetText (HWNDLIST(hwnd), i-1, (LPSTR)_szIconPath);
        
        if (!WritePrivateProfileString ((LPSTR)_szIconSection,(LPSTR)szInt,
            (LPSTR)_szIconPath,(LPSTR)SZFILENAME(sChild)))
        { 
            MESSAGE (IDS_IconsSetting);
            goto Err; 
        }
    }

    SetWindowText (hwnd, (LPSTR)SZFILENAME(sChild));

Err:
    return ;
}



//////////////////////////////////////////////////////////////////////////
// OpenIconsInFile - displays the open dialog box, then does the 
// necessary file i/o to fill the listbox with the icon file 
// pathnames and timer interval, and animStruct data structure stuff.
//////////////////////////////////////////////////////////////////////////

BOOL  WINAPI OpenIconsInFile (char * szFileName)
{
    short  i, sChild;
    BOOL   result=TRUE;    
    HWND   hwnd;


    if (szFileName[0] == '\0')   // if no file is specified to open:
    {
        getcwd (szFileName, sizeof (szFileName));

        if (!ShowCommonDialog(_hwndFrame,_lpszScriptFilter,
            (LPSTR)szFileName, (LPSTR)"File Open...\0", 
            (LPSTR)_szExtension, FALSE))
        {
            result = FALSE;
            goto Err;
        }
    }

    // Get the window up and find out mdi window number...
    SendMessage (_hwndFrame, WM_COMMAND, IDM_NEW, 0L);

    hwnd = MDI_GetActive (_hwndClient);

    if (!IsWindow(hwnd)) return FALSE;

    ShowWindow (hwnd, SW_SHOWMAXIMIZED);

    sChild = WINDOWNUM (hwnd);
    
    lstrcpy ((LPSTR)SZFILENAME(sChild), (LPSTR)szFileName);

    SetWindowText (hwnd, (LPSTR)szFileName);    


    // Get the "TimerInterval=" setting and make sure it is valid:

    SET_TIMEINT (sChild, (short)GetPrivateProfileInt ((LPSTR)_szInfo,
        (LPSTR)_szTimeInt, 0, (LPSTR)szFileName)) ;

    if (TIMEINT(sChild) < 20 || TIMEINT(sChild) > 20000)
    {
        MESSAGE (IDS_TimeIntRange);
    }

    // Get the "NumIcons=" setting and make sure it is valid:

    SET_NUMICONS (sChild, (short)GetPrivateProfileInt ((LPSTR)_szInfo,
        (LPSTR)_szNumIcons, 0, (LPSTR)szFileName));

    if (NUMICONS(sChild) == 0)
    {
        MESSAGE (IDS_NumIconsErr);
    }
    
    GetPrivateProfileString ((LPSTR)_szInfo, (LPSTR)_szLinkFile, (LPSTR)"\0", 
        (LPSTR)SZEXELINK(sChild), MAX_FILE_SIZE, (LPSTR)szFileName);

    if (!GetPathIfNoPath ((LPSTR)SZEXELINK(sChild)))
    {
        MESSAGE (IDS_InvalidPath);
    }

    // Read the "Icons" application section...

    for (i=1 ; i<=(short)NUMICONS(sChild) ; i++)
    {
        char _szIconPath [MAX_FILE_SIZE];
        char   szInt[28];

        wsprintf ((LPSTR)szInt, "%s%d", (LPSTR)_szIcon, i);
        
        GetPrivateProfileString ((LPSTR)_szIconSection, (LPSTR)szInt, (LPSTR)"\0",
            (LPSTR)_szIconPath, MAX_FILE_SIZE, (LPSTR)SZFILENAME(sChild));

        if (_szIconPath[0] == '\0')
        { 
            MESSAGE (IDS_ListBoxUpdate);
            MDI_Destroy (_hwndClient, MDI_GetActive(_hwndClient));
            result = FALSE;
            goto Err;
        }

        if (!GetPathIfNoPath ((LPSTR)_szIconPath))
        {
            MESSAGE (IDS_InvalidFile);
        }
        else
        {
            ListBox_AddString (HWNDLIST(hwnd),(LPSTR)_szIconPath);
        }            
    }
    
    SetupIconHandles (hwnd);

    // Do this last, because setting ISANIMATE to TRUE starts
    // animation immediately if everything is right.

    SET_AUTOANIMATE (sChild, (short)GetPrivateProfileInt ((LPSTR)_szInfo,
        (LPSTR)_szAutoAnimateKey, 0, (LPSTR)szFileName));

    if (AUTOANIMATE(sChild))
    {
        SET_ISANIMATING(sChild, TRUE);
    }

Err:
    return result;
}


//////////////////////////////////////////////////////////////////////////
// LinkToExecutable - displays the open dialog box, allowing the 
// user to choose the executable in which to permanently link the
// executable or com file to.
//////////////////////////////////////////////////////////////////////////

BOOL WINAPI LinkToExecutable (LPSTR lpszFile)
{
    char szExePath [MAX_FILE_SIZE];
    char szDlgTitle [32];
    BOOL fResult;

    if (lpszFile[0] == '\0')
    {
        GetWindowsDirectory ((LPSTR)szExePath, MAX_FILE_SIZE);
    }
    else
    {
        lstrcpy ((LPSTR)szExePath, lpszFile);
    }

    LoadStr (IDS_LinkDlgTitle, szDlgTitle);

    if (fResult =  ShowCommonDialog (_hwndFrame, _lpszEXEFilter, 
        (LPSTR)szExePath, (LPSTR)szDlgTitle, 
        (LPSTR)"*.EXE", FALSE))
    {
        lstrcpy (lpszFile, (LPSTR)szExePath);
    }

    return fResult;
}


///////////////////////////////////////////////////////////////////
// WriteProfileInt - Writes a short integer to the INI file
// specified.  I don't know why the Windows group didn't do this!
///////////////////////////////////////////////////////////////////

short NEAR PASCAL WritePrivateProfileInt (LPSTR lpAppName, LPSTR lpKeyName, 
    short sData, LPSTR lpFileName)
{
    char szInt[8];

    wsprintf ((LPSTR)szInt,"%d", sData);

    return (short) WritePrivateProfileString (lpAppName,lpKeyName,
        (LPSTR)szInt, lpFileName);
}


///////////////////////////////////////////////////////////////////
// GetPathIfNoPath() - This is the checknbalance function to
// make sure that the path specified either on the command line
// or in the animation script is valid.  If no path, it guesses.
///////////////////////////////////////////////////////////////////

BOOL WINAPI GetPathIfNoPath (LPSTR lpszName)
{
    OFSTRUCT of;

    short ret = OpenFile (lpszName, (LPOFSTRUCT)&of, OF_EXIST);

    if (ret < 0)
    {
        lpszName[0] = '\0';
        return FALSE;
    }
    
    if (lstrcmp (lpszName, (LPSTR)of.szPathName) != 0)
    {
        lstrcpy (lpszName, (LPSTR)of.szPathName);
    }
    
    return TRUE;
}
