****************************************************************
* N2W.PRG                                           FoxPro 2.0
****************************************************************
PARAMETER nVar, cCurrency, lChecktype
IF PARAMETER() = 0 OR !TYPE("nVar")='N'
   RETURN 'Not a valid request!'
ENDIF
IF PARAMETER() = 1  OR TYPE('cCurrency')<>'C'
   cCurrency='$'
ENDIF
IF PARAMETERS() > 2             && Presence of third parm means
  lCheckType = .T.              && use the 00/100 form for cents
ENDIF
nstr = ALLTRIM(STR(nVar,20,2))
nlen = LEN(nstr)
noclass = CEILING(nlen/3)
nlen=noclass * 3
nstr=PADL(nstr,nlen)
num2word = ''
DIMENSION nword[nlen], nvalue[nlen]
FOR i = 1 TO nlen STEP 1        && Fill up the arrays with values
   nvalue(i) = SUBSTR(nstr,nlen - i + 1, 1)
   nword(i) = ''
ENDFOR
*        STEP 1, parse each number according to its position
*        <positional grouping analysis>
*
FOR nbit = 1 TO nlen STEP 1
   checkbit = RIGHT('00'+LTRIM(STR(nbit)),2)
   DO CASE
   CASE INLIST(checkbit, '01', '04', '07', '10', '13','16')
      DO unitshunds
   CASE INLIST(checkbit, '02', '05', '08', '11', '14','17')
      DO tens
   CASE INLIST(checkbit, '03', '06', '09', '12', '15','18')
      DO unitshunds
   ENDCASE
ENDFOR
*        STEP 2, parse each number according to its sequence
*        and group accordingly <sequential grouping analysis>
*
DIMENSION class[noclass]
FOR i =1 TO noclass
   STORE '' TO class(i)
ENDFOR
FOR i = 2 TO noclass
   IF !EMPTY(nword(3*i))
      class(i) = nword(3*i) + ' Hundred'
   ENDIF
   class(i) = ALLTRIM(class(i)) + ;
   IIF(!ALLTRIM(nword(3*i-1))=='',' ','') + ;
   ALLTRIM(nword(3*i-1))
   IF !nvalue(3*i-1)='1'
      DO CASE
      CASE !ALLTRIM(nword(3*i-1))=='' AND !ALLTRIM(nvalue(3*i-2))='0'
         class(i)= ALLTRIM(class(i)) + '-' + ALLTRIM(nword(3*i-2))
      CASE ALLTRIM(nword(3*i-1))=='' AND !ALLTRIM(nvalue(3*i-2))='0'
         class(i)= ALLTRIM(class(i)) + ' ' + ALLTRIM(nword(3*i-2))
      ENDCASE
   ENDIF
   class(i)=ALLTRIM(class(i))
   DO CASE
   CASE i = 6
      class(i) = IIF(!EMPTY(class(i)), class(i)+' Trillion, ','')
   CASE i = 5
      class(i) = IIF(!EMPTY(class(i)), class(i)+' Billion, ','')
   CASE i = 4
      class(i) = IIF(!EMPTY(class(i)), class(i)+' Million, ','')
   CASE i = 3
      class(i) = IIF(!EMPTY(class(i)), class(i)+' Thousand, ','')
   ENDCASE
   num2word =   class(i) + num2word
ENDFOR
IF RIGHT(ALLTRIM(num2word),1)=','
   num2word = LEFT(ALLTRIM(num2word), LEN(ALLTRIM(num2word))-1)
ENDIF
dec2word = nword(2)
IF !nvalue(2)='1'
   dec2word = dec2word + ;
   IIF(!ALLTRIM(nword(2))==''AND !ALLTRIM(nvalue(1))='0','-','')+;
   nword(1)
ENDIF
dec2word = ALLTRIM(dec2word)
nat_bcurr = ''
nat_scurr = ''
num2word = IIF(ALLTRIM(num2word)=='',"Zero",num2word)
dec2word = IIF(ALLTRIM(dec2word)=='',"Zero",dec2word)
num2word = IIF(nVar < 0, "Minus "+num2word, num2word)
IF UPPER(cCurrency)=='NUM'
   RETURN IIF(dec2word=='Zero',num2word,num2word+" Point "+dec2word)
ENDIF
*        STEP 3, add currency if requested
*
DO curr2word
num2word = num2word + ' ' + nat_bcurr
dec2word = dec2word + ' ' + nat_scurr
IF lCheckType                   && SR -- Use 99/100 check format
 dec2word = ALLTRIM(NVALUE[2])+ALLTRIM(NVALUE[1])+"/100"
ENDIF
RETURN num2word + IIF(!ALLTRIM(dec2word)=='',' and ','') + dec2word

PROCEDURE unitshunds
DO CASE
CASE nvalue(nbit) = '1'
   nword(nbit) = 'One'
CASE nvalue(nbit) = '2'
   nword(nbit) = 'Two'
CASE nvalue(nbit) = '3'
   nword(nbit) = 'Three'
CASE nvalue(nbit) = '4'
   nword(nbit) = 'Four'
CASE nvalue(nbit) = '5'
   nword(nbit) = 'Five'
CASE nvalue(nbit) = '6'
   nword(nbit) = 'Six'
CASE nvalue(nbit) = '7'
   nword(nbit) = 'Seven'
CASE nvalue(nbit) = '8'
   nword(nbit) = 'Eight'
CASE nvalue(nbit) = '9'
   nword(nbit) = 'Nine'
ENDCASE
RETURN
PROCEDURE tens
DO CASE
CASE nvalue(nbit) = '1'
   DO CASE
   CASE nvalue(nbit-1) = '0'
      nword(nbit)   = 'Ten'
   CASE nvalue(nbit-1) = '1'
      nword(nbit)   = 'Eleven'
   CASE nvalue(nbit-1) = '2'
      nword(nbit)   = 'Twelve'
   CASE nvalue(nbit-1) = '3'
      nword(nbit)   = 'Thirteen'
   CASE nvalue(nbit-1) = '4'
      nword(nbit)   = 'Fourteen'
   CASE nvalue(nbit-1) = '5'
      nword(nbit)   = 'Fifteen'
   CASE nvalue(nbit-1) = '6'
      nword(nbit)   = 'Sixteen'
   CASE nvalue(nbit-1) = '7'
      nword(nbit)   = 'Seventeen'
   CASE nvalue(nbit-1) = '8'
      nword(nbit)   = 'Eighteen'
   CASE nvalue(nbit-1) = '9'
      nword(nbit)   = 'Nineteen'
   ENDCASE
CASE nvalue(nbit) = '2'
   nword(nbit) = 'Twenty'
CASE nvalue(nbit) = '3'
   nword(nbit) = 'Thirty'
CASE nvalue(nbit) = '4'
   nword(nbit) = 'Forty'
CASE nvalue(nbit) = '5'
   nword(nbit) = 'Fifty'
CASE nvalue(nbit) = '6'
   nword(nbit) = 'Sixty'
CASE nvalue(nbit) = '7'
   nword(nbit) = 'Seventy'
CASE nvalue(nbit) = '8'
   nword(nbit) = 'Eighty'
CASE nvalue(nbit) = '9'
   nword(nbit) = 'Ninety'
ENDCASE
RETURN
PROCEDURE curr2word
STORE .T. TO s_breq, s_sreq
DO CASE
CASE (cCurrency) = '$' OR 'USA' $ UPPER(cCurrency)
   nat_bcurr = 'Dollar'
   nat_scurr = 'Cent'
CASE (cCurrency) = '' OR 'GRB' $ UPPER(cCurrency)
   nat_bcurr = 'Pound'
   nat_scurr = 'Pence'
   s_sreq = .F.
CASE (cCurrency) == 'N' OR 'NGR' $ UPPER(cCurrency)
   nat_bcurr = 'Naira'
   nat_scurr = 'Kobo'
   STORE .F. TO s_breq, s_sreq
OTHERWISE
   nat_bcurr = 'Dollar'
   nat_scurr = 'Cent'
ENDCASE
nat_bcurr = IIF(!ALLTRIM(num2word) =='', ;
   IIF(nvalue(4)='1' AND num2word=='One',nat_bcurr,nat_bcurr+;
   IIF(s_breq,'s','')),'')
nat_scurr = IIF(!ALLTRIM(dec2word) =='', ;
   IIF(nvalue(1)='1' AND dec2word=='One',nat_scurr,nat_scurr+;
   IIF(s_sreq,'s','')),'')
RETURN .T.

