// chkdupe.h RHS 8/4/91

#if !defined(CHKDUPE_H)
#define CHKDUPE_H

#include<stdlib.h>
#include"stdapp.h"
#include"myscroll.h"
#include"inifile.h"

char *ShowDupe =         
        "ShowDupe v1.0 (C) 1992, Richard Hale Shaw    "
        "1st published, PC Magazine 02/25/92";


char *ShowDupeHelp = 
"Finds and displays all the duplicate files on one or more hard disks.\n\n"

"Usage: SHOWDUPE <drive\\dir> [drive\\dir]\n"
"   ex: showdupe c:\\ d:\\\n"
"   ex: showdupe c:\\dos d:\\newdos e:\\olddos\n\n"

"You can limit the duplicate file search to specific directories by\n"
"specifying them.\n\n"

"Other settings can be controlled via SHOWDUPE.INI\n";


#define NUMSETTINGS 21              // always adjust this to size of array
#define SCREENMODE  NUMSETTINGS-3   // don't change these
#define VIEWER      NUMSETTINGS-2
#define SEARCHDIRS  NUMSETTINGS-1
#define MAXCOLORS   NUMSETTINGS-3
#define SCROLL_NBG  6
#define SCROLL_NFG  SCROLL_NBG+1
#define SCROLL_CBG  SCROLL_NBG+2
#define SCROLL_CFG  SCROLL_NBG+3
#define SCROLL_SNBG  SCROLL_NBG+4
#define SCROLL_SNFG  SCROLL_NBG+5
#define SCROLL_SCBG  SCROLL_NBG+6
#define SCROLL_SCFG  SCROLL_NBG+7
#define SCROLL_DNBG  SCROLL_NBG+8
#define SCROLL_DNFG  SCROLL_NBG+9
#define SCROLL_DCBG  SCROLL_NBG+10
#define SCROLL_DCFG  SCROLL_NBG+11


struct _settings
    {
    char    *name;
    char    *value;
    } MySettings[NUMSETTINGS] = 
    {
    {   "DeskTopBackGround",    "LIGHTGRAY"     },
    {   "DeskTopForeGround",    "BLUE"          },
    {   "ScreenBackGround",     "BLUE"          },
    {   "ScreenForeGround",     "WHITE"         },
    {   "WindowBackGround",     "BLUE"          },
    {   "WindowForeGround",     "YELLOW"        },
    {   "ScrollNrmBackGround",  "BLUE"          },
    {   "ScrollNrmForeGround",  "WHITE"         },
    {   "ScrollCurBackGround",  "LIGHTGRAY"     },
    {   "ScrollCurForeGround",  "WHITE"         },
    {   "ScrollSelNrmBackGround","BLUE"         },
    {   "ScrollSelNrmForeGround","YELLOW"       },
    {   "ScrollSelCurBackGround","LIGHTGRAY"    },
    {   "ScrollSelCurForeGround","YELLOW"       },
    {   "ScrollDelNrmBackGround","BLUE"         },
    {   "ScrollDelNrmForeGround","LIGHTGRAY"    },
    {   "ScrollDelCurBackGround","LIGHTGRAY"    },
    {   "ScrollDelCurForeGround","DARKGRAY"     },
    {   "ScreenMode",           "Default"       },  // always 3rd from end
    {   "Viewer",               "SMOOTH.COM"    },  // always next to last
    {   "SearchDirectories",    ""              }   // always last
    };

class ChkDupe : public StandardApplication
    {
    int show_stats;
    MyScroller *myScroller;
    BYTE desktop_colors;
    BYTE default_colors;
    IniFile Settings;
    Window *Status;
    Window *pathW;
    BYTE colors[MAXCOLORS];

    void terminate(void);
    void terminate(char *msg);
    BOOL FilesExist(void);
    BOOL ScreenMgr(int key);
    void ShowStats(void);
    void ShowDupes(void);
    BOOL FindDuplicates(void);
    void InitApp(void);
public:
    ChkDupe(void);
    ~ChkDupe(void);
    };


#endif

