***********************************************************************
* DISPSTRU.PRG                                            Clipper 5.01
*
* Command line utility to display the structure of a Clipper DBF File.
* Usage: DISPSTRU <dbf> [TO <filename>] [TO PRIN[TER]]
*
***********************************************************************
#include "set.ch"
*
* --- Define the UDC "DISPLAY STRUCTURE"
*
#command DISPLAY STRUCTURE [<print: TO PRINTER>] [TO <(file)>] ;
   => disp_stru( <(file)>, <.print.>)

PARAMETERS dbffile, tto, dest
IF tto <> NIL
   tto = UPPER(tto)
ENDIF
IF (dbffile == NIL) .OR. ((tto = "TO") .AND. (dest = NIL))
   dispusage()
   RETURN
ENDIF
IF AT('.',dbffile)=0                      && Add extension if needed
   dbffile = dbffile+".dbf"
ENDIF

USE (dbffile) NEW                         && USE the requested file

DO CASE
CASE "" = dest .OR. dest = NIL
   DISPLAY STRUCTURE                      && Execute UDC
CASE LEFT(UPPER(dest),4) = "PRIN"
   DISPLAY STRUCTURE TO PRINTER           && Execute UDC with option
OTHERWISE
   DISPLAY STRUCTURE TO (dest)            && Execute UDC with option
ENDCASE

RETURN NIL

***********************************************************************
* disp_stru()                                         Clipper 5.01
*
* Function called by User Defined Command "DISPLAY STRUCTURE"
***********************************************************************
FUNCTION disp_stru()
#include "dbstruct.ch"
PARAMETERS file, print

oldprintf = SET(_SET_PRINTFILE)           && Save these for restoring
oldprint  = SET(_SET_PRINTER)             && later
oldcons   = SET(_SET_CONSOLE)

DO CASE
CASE "" <> file .AND. file <> NIL
   SET PRINTER TO (file) ADDITIVE         && Send to file additive
   SET CONSOLE OFF                        && Shut off console
   SET PRINTER ON
CASE print
   SET CONSOLE OFF                        && Shut off console
   SET PRINTER ON
ENDCASE

?? "Structure for "+UPPER(dbffile)        && Display structure
? "Name       ", "Type", "Len", "Dec"
? "-----------", "----", "---", "---"

AEVAL( (ALIAS())->(DBSTRUCT()),{ | adbfstruct |    ;
   QOUT(PAD(adbfstruct[DBS_NAME], 10), ;
   "   " + adbfstruct[DBS_TYPE],      ;
   STR(adbfstruct[DBS_LEN], 3),   ;
   STR(adbfstruct[DBS_DEC], 3))  })
?
SET(_SET_PRINTER,  oldprint)              && Restore saved values
SET(_SET_PRINTFILE,oldprintf)
SET(_SET_CONSOLE,  oldcons)
RETURN NIL

***********************************************************************
* dispusage()  - Display usage information
***********************************************************************
FUNCTION dispusage
?? "Usage: DISPSTRU <dbfname> [[TO <filename>] | [TO PRINTER]]"
RETURN NIL
