// POINT.H -- Class definition for points and pixels.
// Member functions are defined in POINT.CPP
// Copyright (C) 1991 Ziff Davis Communications
// PC Magazine * Ray Duncan

// definition of base class POINT
class POINT {
  private:
    double X;                           // X coordinate for point
    double Y;                           // Y coordinate for point
    double deg2rad(double);             // convert degrees to radians
    double rad2deg(double);             // convert radians to degrees
  public:
    POINT(double, double);              // constructor for point
    void setX(double);                  // set point value of X
    void setY(double);                  // set point value of Y
    double getX(void);                  // return point value of X
    double getY(void);                  // return point value of Y
    void translate(double, double);     // translate point by X,Y
    void rotate(double);                // rotate point by X,Y
};

// definition of derived class PIXEL
class PIXEL : public POINT {
    int Color;                          // pixel color value
  public:
    PIXEL(double, double, int);         // constructor for pixel
    void setColor(int);                 // set color of pixel
    int getColor(void);                 // return color of pixel
    void display(void);                 // display data for pixel
};

const double pi = 3.141592654;          // constant Pi


