/*----------------------------------------------------------------------
   GAMMARED.C -- Red Shades Using Palette Manager with Gamma Correction
                 (c) Charles Petzold, 1990
  ----------------------------------------------------------------------*/

#include <windows.h>
#include <math.h>
#include <string.h>

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     char     szAppName [] = "GammaRed" ;
     HWND     hwnd ;
     MSG      msg ;
     WNDCLASS wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "Red Shades with Gamma Correction",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static char     *pszText[3] = { "Dithered Colors",
                                     "Palette colors",
                                     "Palette colors with gamma correction" } ;
     static HPALETTE hPal ;
     static short    cxClient, cyClient ;
     BOOL            bPalSupport ;
     double          dIntensity, dVoltage ;
     HBRUSH          hBrush ;
     HDC             hdc ;
     HMENU           hMenu ;
     LOCALHANDLE     hLocalMem ;
     LOGPALETTE      *plp ;
     long            i ;
     PAINTSTRUCT     ps ;
     RECT            rc ;
     short           x, y ;
     WORD            nRedLevel ;

     switch (message)
          {
          case WM_CREATE:

                    // Check for palette support

               hdc = GetDC (hwnd) ;

               bPalSupport = (RC_PALETTE & GetDeviceCaps (hdc, RASTERCAPS)) &&
                             (GetDeviceCaps (hdc, SIZEPALETTE) -
                              GetDeviceCaps (hdc, NUMRESERVED) > 128) ;

               ReleaseDC (hwnd, hdc) ;

               if (!bPalSupport)
                    {
                    MessageBox (hwnd, "Program requires palette support",
                                "GammaRed", MB_ICONEXCLAMATION | MB_OK) ;

                    DestroyWindow (hwnd) ;
                    return 0 ;
                    }

                    // Allocate memory for LOGPALETTE structure and lock it

               hLocalMem = LocalAlloc (LMEM_MOVEABLE, sizeof (LOGPALETTE) +
                                                 127 * sizeof (PALETTEENTRY)) ;

               plp = (LOGPALETTE *) LocalLock (hLocalMem) ;

                    // Initialize the fields of the LOGPALETTE structure

               plp->palVersion    = 0x300 ;
               plp->palNumEntries = 128 ;

               for (i = 0 ; i < 64 ; i++)
                    {
                              // Uncorrected palette values

                    nRedLevel = 4 * i ;

                    plp->palPalEntry[i].peRed   = nRedLevel ;
                    plp->palPalEntry[i].peGreen = 0 ;
                    plp->palPalEntry[i].peBlue  = 0 ;
                    plp->palPalEntry[i].peFlags = 0 ;

                              // Gamma-corrected palette values

                    if (i == 0)
                         dIntensity = 0.0 ;
                    else
                         dIntensity = pow (0.015, (64 - i) / 64.0) ;

                    dVoltage = pow (dIntensity, 1 / 2.35) ;

                    nRedLevel = (short) (255 * dVoltage + .5) ;

                    plp->palPalEntry[i + 64].peRed   = nRedLevel ;
                    plp->palPalEntry[i + 64].peGreen = 0 ;
                    plp->palPalEntry[i + 64].peBlue  = 0 ;
                    plp->palPalEntry[i + 64].peFlags = 0 ;
                    }

                    // Create the logical palette

               hPal = CreatePalette (plp) ;

                    // Unlock and free the allocated memory

               LocalUnlock (hLocalMem) ;
               LocalFree (hLocalMem) ;
               return 0 ;

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

                         // Select and realize the palette

               SelectPalette (hdc, hPal, FALSE) ;
               RealizePalette (hdc) ;

               for (i = 0 ; i < 64 ; i++)
                    {
                    nRedLevel = 4 * i ;

                    rc.left   = (short) ( i      * cxClient / 64) ;
                    rc.right  = (short) ((i + 1) * cxClient / 64) ;

                         // Dithered colors

                    rc.top    = 0 ;
                    rc.bottom = cyClient / 3 ;

                    hBrush = CreateSolidBrush (RGB (nRedLevel, 0, 0)) ;
                    FillRect (hdc, &rc, hBrush) ;
                    DeleteObject (hBrush) ;

                         // Palette colors

                    rc.top    = rc.bottom ;
                    rc.bottom = 2 * cyClient / 3 ;

                    hBrush = CreateSolidBrush (PALETTEINDEX (i)) ;
                    FillRect (hdc, &rc, hBrush) ;
                    DeleteObject (hBrush) ;

                         // Palette colors with gamma correction

                    rc.top    = rc.bottom ;
                    rc.bottom = cyClient ;

                    hBrush = CreateSolidBrush (PALETTEINDEX (i + 64)) ;
                    FillRect (hdc, &rc, hBrush) ;
                    DeleteObject (hBrush) ;
                    }

                         // Display the text

               for (i = 0 ; i < 3 ; i++)
                    {
                    x = 0 ;
                    y = i * cyClient / 3 ;

                    TextOut (hdc, x, y, pszText[i], strlen (pszText[i])) ;
                    }

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_QUERYNEWPALETTE:
               hdc = GetDC (hwnd) ;

               SelectPalette (hdc, hPal, FALSE) ;

               if (RealizePalette (hdc) > 0)
                    {
                    ReleaseDC (hwnd, hdc) ;
                    InvalidateRect (hwnd, NULL, FALSE) ;
                    return TRUE ;
                    }
               else
                    {
                    ReleaseDC (hwnd, hdc) ;
                    return FALSE ;
                    }
               break ;

          case WM_PALETTECHANGED:
               if (wParam != hwnd)
                    {
                    hdc = GetDC (hwnd) ;

                    SelectPalette (hdc, hPal, FALSE) ;

                    if (RealizePalette (hdc) > 0)
                         {
                         InvalidateRect (hwnd, NULL, FALSE) ;
                         }

                    ReleaseDC (hwnd, hdc) ;
                    }
               return 0 ;

          case WM_DESTROY :

                    // Delete the logical palette

               DeleteObject (hPal) ;
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
