{ to help check that ibid record numbers do not have different contents }
{ pseudo code
     works in combo with an xpl program from Nota Bene 4
        change to dir given in param(1);
	Read nbbib*.Dat files
	Make note of each R# that appears more than once
	Read those records that have more than one appearance
	and put them to file for NB to deal with

}

const    MaxRecNr = 12000;
Var inf, outf: text;
         nrnr: array[1..MaxRecNr] of byte;
         nr,code,fnro,i, count : integer;
         l, infn, fnron, oldir, ibidir : string;


Function OpenFile(FileName:string):boolean;
Begin {of FileExists}
      {$I-}
      Assign(Inf,FileName);
      Reset(Inf);
      {$I+}
      OpenFile:=(IOResult=0) and (FileName<>'');
End; {of OpenFile}

Function Build_FN( i : integer):string;
  var s : string;
begin
     str(i,s);
     if i < 10 then s := '0'+s;
     if i < 100 then s := '0'+s;
     Build_FN := 'NBBIB'+s+'.DAT';
end;

procedure ScanFile(var Inf:text);
begin
     writeln('scanning ',infn);
     repeat
       readln(inf,l);
       if copy(l,1,2)='R#' then
        begin
          delete(l,1,3);
          delete(l,pos('',l),1);
          val(l, nr, code);
          nrnr[nr] := nrnr[nr] + 1;
        end;
     until eof(inf);
     close(inf);
end;

Procedure HarvestFile(var Inf:text);
  var lc : integer;
      lcc : string[12];
begin
   writeln('harvesting doubles from ',infn);
   lc := 0;
    repeat
     readln(inf,l);
     lc := lc+1;
     if copy(l,1,2)='R#' then
      begin
       delete(l,1,3);
       delete(l,pos('',l),1);
       val(l, nr, code);
       if nrnr[nr] > 1 then
         begin
          str(lc,lcc);
          l := 'R#:'+l+''+#13+#10+'('+INFN+', line '+lcc+')';
             while pos(':',l)>0 do
             begin
               writeln(outf,l);
               readln(inf,l);
               lc := lc + 1;
             end;
             writeln(outf,'PG');
         end
      end;
    until eof(inf);
    close(inf);

end;


begin
   writeln;writeln;writeln;
   getdir(0,oldir);
   Ibidir := paramstr(1);
   if '\'=Ibidir[length(Ibidir)] then delete(Ibidir,Length(Ibidir),1);
   {$I-}
   ChDir(Ibidir);
      if IOResult <> 0 then begin
         WriteLn('Cannot find directory'); halt;end;
   {$I+}
   fillchar(nrnr,sizeof(nrnr),0);

   fnro := 0;
   infn := build_fn( fnro );

   while OpenFile( InFN ) do
   begin
     ScanFile( Inf );
     Fnro := Fnro + 1;
     InFN := Build_FN(Fnro);
   end;
   infn := 'NBBIB.DAT';
   if OpenFile( infn ) then ScanFile( Inf );

   count := 0;
   for i := 1 to MaxRecNr do
     if nrnr[i] > 1 then count := count+1;
   Writeln(count,' record numbers appear more than once');


  assign(outf, 'ib_2chk.tmp');
  rewrite(outf);
  if count=0 then begin
      writeln(outf,'no doubles found'); close(outf); halt; end;
  write(outf,'ILAA');
  write(outf,
  'This file contains records whose record number appears more than once in');
  write(outf,
  ' the NBBIB*.DAT files.  There were ', count,' such numbers. ');
  write(outf,
  'Sorting will put similar numbers next to each other.  Comparing means ');
  write(outf,
  'that first lines of similar rec#s are compared.  If lines are different, ');
  write(outf,
  'a totally different item may have been added into an existing number. ');
  writeln(outf,
  'Such suspect records are marked with MDBO!!!MDNM');
  writeln(outf,'LD-');
  writeln(outf,'PG');

  Fnro := 0;
  InFN := Build_FN(Fnro);

  while OpenFile(InFN) do
   begin
    HarvestFile( Inf );
    fnro := fnro + 1;
    InFN := Build_FN(Fnro);
  end;
  infn := 'nbbib.dat';
  if OpenFile( infn ) then HarvestFile( Inf );

  close(outf);
  chdir(oldir);
end.

