
/****************************************************************************
*   Function:    int sockp(long d)                                          *
*   Operation:   to pause for the specified number of milliseconds          *
*   Returns:     (none)                                                     *
*   Parameters:  d, duration in milliseconds, long data type                *
****************************************************************************/

#include <sys/types.h>
#include <sys/timeb.h>

void sockp(d)
  long d;
{
  struct timeb tstruct;
  long t1, t2;

  ftime(&tstruct);
  t1 = tstruct.time * 1000 + tstruct.millitm;
  t2 = t1;

  while (t1 + d > t2) {
    ftime(&tstruct);
    t2 = tstruct.time * 1000 + tstruct.millitm;
  }
}
