              /*-----------------------*/
              /*      BACK_PROP        */
              /*   by Luca Marchese    */
              /*-----------------------*/

#include <math.h>
#include <stdio.h>
#define maxline 100

/* pubblic data*/
float  esempi[5000]; /*examples vector*/
float  w1[40][40];  /*input - hidden weights*/
float  w2[40][40];  /*hidden1 - hidden2 weights*/
float  w3[40][40];  /*output - hidden2 weights*/
int nx=0;                /*input neurons number*/
int nh1=0;               /*hidden1 neurons number*/
int nh2=0;               /*hidden2 neurons number*/
int ny=0;                /*output neurons number*/
int ne=0;                /*examples number*/
int nes=0;               /*epochs number for any step*/
float err_rete;          /*error for one example*/
float err_epoca;         /*max error of epoch*/
float err_ammesso;       /*max error ammitted*/
float epsilon=0;         /*learning constant*/
float func_res;          /*result of transfer function*/
float esp_ris;           /*result of exp*/
int n_save=0;            /*epochs betwen two automatic weight save*/
int autosave=0;          /*automatic weight save flag*/
char auto_name[maxline]; /*automatic weight save filename*/
char filearn[maxline];   /*examples filename*/

char teststring1[maxline];/*used for testing numeric string*/
char *teststring2="qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM!@#$%^&*()_-|\+={[}]:;'~`<,>.?/";
char *teststring3="qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM!@#$%^&*()_-|\+={[}]:;'~`<,>?/";
/*char *teststring4="qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM!@#$%^&*()_|\+={[}]:;'~`<,>?/";*/

float x[100];
float y[100];
float d[100];
float h1[100];
float h2[100];

main()
 {
    char scelta[maxline];
    while(1)
    {
    printf("   |---------------------------------|-------------------------------------|\n");
    printf("   |          FUNCTIONS              |               STATUS                |\n");
    printf("   |---------------------------------|-------------------------------------|\n");
    printf("   | A) DEFINE INPUT/OUTPUT/HIDDEN   | IN=%03d    |-------------------|     |\n",nx);
    printf("   | B) LEARNING                     | OUT=%03d   |  TARGET=%01f  |     |\n",ny,err_ammesso);
    printf("   | C) EXECUTION                    | H1=%03d    |  ERROR= %01f  |     |\n",nh1,err_epoca);
    printf("   | D) SAVE WEIGHT ON FILE          | H2=%03d    |-------------------|     |\n",nh2);
    printf("   | E) AUTOMATIC WEIGHT SAVE ON FILE| EPSILON=%f                    |\n",epsilon);
    printf("   | F) LOAD WEIGHT FROM FILE        | STEP=%08d                       |\n",nes);
    printf("   | G) EDITOR                       | EXAMPLES=%04d                       |\n",ne);
    printf("   | H) QUIT FROM PROGRAM            | EXAMPLES FILE: %12s         |\n",filearn);
    printf("   |                                 | AUTOMATIC SAVE=%d EVERY %06d EPOCH |\n",autosave,n_save);
    printf("   |                                 | SAVE FILE: %12s             |\n",auto_name);
    printf("   |---------------------------------|-------------------------------------|\n");
    printf("   chose:");
    scanf("%s",scelta);
    if(!strncmp(scelta,"a",1)) def_i_o_h();
    if(!strncmp(scelta,"b",1)) ebp_learn();
    if(!strncmp(scelta,"c",1))
                {
                 if(input())
                 {
                  printf("   EXECUTING\n");
                  exec();
                  output();
                 }
                }
    if(!strncmp(scelta,"d",1)) save_weight(0,"");
    if(!strncmp(scelta,"e",1)) set_autosave();
    if(!strncmp(scelta,"f",1)) load_weight();
    if(!strncmp(scelta,"g",1)) editor();
    if(!strncmp(scelta,"h",1)) break;
    }

     return;
   }







exec()
   {
    int k=0;
    int j=0;
    float a;
    while(k!=nh1) h1[k++]=0; /*hidden1 inizialization 0*/
    h1[k]=1;                /*bias*/
    k=0;
    while(k!=nh2) h2[k++]=0; /*hidden2 inizialization 0*/
    h2[k]=1;                /*bias*/
    k=0;
    while(k!=ny) y[k++]=0; /*output inizialization 0*/
    k=0;
    while(j!=nh1)                                /*h1 calculation*/
         {
          k=0;
          a=0;                                  /*any neuron h1 =0*/
          while(k!=nx+1)
              {
               a=a+(w1[j][k]*x[k++]); /*h1 neuron activation calculation with  bias*/
              }
          f(a);
          h1[j++]=func_res;                      /*output calculation*/
         }

    j=0;
    while(j!=nh2)
         {
          k=0;
          a=0;                                  /*h1 neuron activation =0*/
          while(k!=nh1+1)
              {
               a=a+(w2[j][k]*h1[k++]); /*h2 neuron activation calculation with  bias*/
              }
          f(a);
          h2[j++]=func_res;                      /*output calculation*/
         }

    j=0;
    while(j!=ny)                                /*y calculation*/
         {
          a=0;                                  /*any y neuron activation =0*/
          k=0;
          while(k!=nh2+1)
             {
              a=a+(w3[j][k]*h2[k++]); /*y neuron activation calculation with  bias*/
             }
          f(a);
          y[j++]=func_res;                      /*output calculation*/
         }
    return;
   }


f(a)        /*sigmoid transfer function*/
float a;
  {
   float b;
   b=1/(1+exp(-a));
   func_res=b;
   return;
  }






input()
  {
   char *file="net.in";
   FILE *fpin;
   int k=0;
   if(!(fpin=fopen(file,"r")))
        {
         printf("ERROR OPENING FILE NET.IN\n");
         return 0;
        }
   while(k!=nx) fscanf(fpin,"%f",&x[k++]);
   fclose(fpin);
   return  1;
  }



output()
  {
   char *file="net.out";
   FILE *fpout;
   int k=0;
   if(!(fpout=fopen(file,"w")))
        {
         printf("   ERROR OPENING FILE NET.OUT\n");
         return ;
        }
   while(k!=ny) fprintf(fpout,"%f\n",y[k++]);
   fclose(fpout);
   return ;
  }






back_propagation()
   {
    float delta;
    float err_h1[100];
    float err_h2[100];
    int k=0;
    int j=0;
    while(k!=nh1+1) err_h1[k++]=0;   /* h1 error initialization=0*/
    k=0;
    while(k!=nh2+1) err_h2[k++]=0;   /*h2 error initialization=0*/
    k=0;
    err_rete=0;                      /* err_rete=0 initialization*/
    while(j!=ny)                     /*for any neuron  y*/
         {
          /* err_rete calculation*/
          if(test_err_rete(d[j]-y[j])) set_err_rete(d[j]-y[j]);
          delta=(d[j]-y[j])*y[j]*(1-y[j]);

          k=0;
          while(k!=nh2+1)             /*for any neuron h2 + bias*/
           {
            /*error calculation using delta*/
            err_h2[k]=err_h2[k]+(delta*w3[j][k]); /*for backpropagation*/
            /*change weight w3(y/h2)*/
             w3[j][k]=w3[j][k]+(epsilon*delta*h2[k++]);
           }
          j++;
         }


     j=0;
     while(j!=nh2)                    /*for any neuron h2*/
          {
           delta=err_h2[j]*h2[j]*(1-h2[j]);
           k=0;
           while(k!=nh1+1)            /*for any neuron h1 + bias*/
               {
                /*error calculation using delta*/
                err_h1[k]=err_h1[k]+(delta*w2[j][k]);/*for backpropagation*/
                /*change weight w2(h2/h1)*/
                 w2[j][k]=w2[j][k]+(epsilon*delta*h1[k++]);
               }
           j++;
          }



    j=0;
    while(j!=nh1)                  /*for any neuron h1*/
      {
       /*delta calculation*/
       delta=err_h1[j]*h1[j]*(1-h1[j]);
       k=0;
       /* change weight w1*/
       while(k!=nx+1) w1[j][k]=w1[j][k]+(epsilon*delta*x[k++]);
       j++;
      }
      return;
   }




set_err_rete(number)
float number;
  {
   if(number>=0) err_rete=number;
   if(number<0) err_rete=-number;
   return;
  }


test_err_rete(number)
float number;
  {
   if((number>=0)&&(number>err_rete)) return 1;
   if((number<0)&&((-number)>err_rete)) return 1;
   else return 0;
  }



learn()
   {
    int epoca;                                              /*epoch index*/
    int epoca_step;                                         /*step epoch index*/
    int p=0;                                                /*example index*/
    int i,j,k;
    char confirm[maxline];
    int indice_save=0;
    epoca=0;                                                /*start from epoch 0*/
    epoca_step=0;
    while(1)                                                /*epoch cicle*/
      {
       err_epoca=0;                                         /*err_epoch=0 initialization*/
       p=0;
       i=0;
       while(i!=ne)                                         /*example cicle inside epoch cicle*/
         {
          k=j=0;
          while(k!=nx) x[k++]=esempi[p++];             /*read nx  input values example*/
          while(j!=ny) d[j++]=esempi[p++];             /*read ny  output values example*/
          exec();                                      /*execution*/
          back_propagation();
          if(err_rete>err_epoca) err_epoca=err_rete;        /*epoch error= max(example error)*/
          i++;
         }
       i=0;
       if(autosave)
                {
                indice_save++;
                if(n_save==indice_save)
                  {
                   printf("   SAVE LEARNED\n");
                   save_weight(1,auto_name);
                   indice_save=0;
                  }
                }
       epoca++;
       epoca_step++;
       printf("   EPOCH: %d   ERROR: %.8f\n",epoca,err_epoca);
       if(epoca_step==nes)                                  /*confirm request for continue(step end)*/
              {
               epoca_step=0;
               printf("   CONTINUE[Y/N]:");
               scanf("%s",confirm);
               if((!strncmp(confirm,"n",1))||(!strncmp(confirm,"N",1))) return;
              }
       if(err_epoca<err_ammesso) break;                     /*target reached*/
       if(err_epoca>1)
                 {
                  printf("   ERROR DETECTED IN INPUT DATA\n");
                  break;
                 }

      }
      return;
   }




def_i_o_h()
  {
   int k=0;
   float *px;
   float *ph1;
   float *ph2;
   nx=define_input(teststring1,teststring2,x);
   ny=define_output(teststring1,teststring2,y);
   nh1=define_hidden1(teststring1,teststring2,h1);
   nh2=define_hidden2(teststring1,teststring2,h2);
   px=&x[0];
   ph1=&h1[0];
   ph2=&h2[0];
   while(k++!=nx) *(px++)=0; /*set  0  x values*/
   *px=1;                    /*set  1  bias value*/
   k=0;
   while(k++!=nh1) *(ph1++)=0; /*set  0 h1 values*/
   *ph1=1;                     /*set  1 bias value*/
   k=0;
   while(k++!=nh2) *(ph2++)=0;/*set  0 h2 values*/
   *ph2=1;                    /*set  1 bias value*/
   return;
  }





define_input()
  /*define inputs number */
  {
   int ndat;
   inu:
   printf("   INPUTS NUMBER:");
 /*scanf("%d",&ndat);*/
   scanf("%s",teststring1);
   if(!strpbrk(teststring1,teststring2)) sscanf(teststring1,"%d",&ndat);
   else goto inu;
   if((ndat==0)||(ndat>40)) goto inu;
   return ndat;
  }



define_output()
 /*define outputs number */
  {
   int ndat;
   ounu:
   printf("   OUTPUT NUMBER:");
   /*scanf("%d",&ndat);*/
   scanf("%s",teststring1);
   if(!strpbrk(teststring1,teststring2)) sscanf(teststring1,"%d",&ndat);
   else goto ounu;
   if((ndat==0)||(ndat>40)) goto ounu;
   return ndat;
  }



define_hidden1()
 /*define hidden1 neurons number*/
  {
   int ndat;
   hnn1:
   printf("   HIDDEN1 NEURONS NUMBER:");
   /*scanf("%d",&ndat); */
   scanf("%s",teststring1);
   if(!strpbrk(teststring1,teststring2)) sscanf(teststring1,"%d",&ndat);
   else goto hnn1;
   if((ndat==0)||(ndat>40)) goto hnn1;
   return ndat;
  }


define_hidden2()
 /*define hidden2 neurons number*/
  {
   int ndat;
   hnn2:
   printf("   HIDDEN2 NEURONS NUMBER:");
   /*scanf("%d",&ndat);*/
   scanf("%s",teststring1);
   if(!strpbrk(teststring1,teststring2)) sscanf(teststring1,"%d",&ndat);
   else goto hnn2;
   if((ndat==0)||(ndat>40)) goto hnn2;
   return ndat;
  }



ebp_learn()
{
FILE *fp;
char rand_resp[maxline];
int k;
float exemp;
if((nx==0)||(ny==0)||(nh1==0)||(nh2==0))
     {
      printf("   YOU MUST DEFINE IN/OUT/HIDDEN\n");
      return;
     }
exn:
printf("   EXAMPLES NUMBER:");
/*scanf("%d",&ne);*/
scanf("%s",teststring1);
if(!strpbrk(teststring1,teststring2)) sscanf(teststring1,"%d",&ne);
else goto exn;
mae:
printf("   MAX AMMITTED ERROR[0.001>0.99]:");
/*scanf("%f",&err_ammesso);*/
scanf("%s",teststring1);
if(!strpbrk(teststring1,teststring3)) sscanf(teststring1,"%f",&err_ammesso);
else goto mae;
if((err_ammesso>0.99)||(err_ammesso<0.001)) goto mae;
lc:
printf("   LEARNING CONSTANT:[0.001>0.99]:");
/*scanf("%f",&epsilon);*/
scanf("%s",teststring1);
if(!strpbrk(teststring1,teststring3)) sscanf(teststring1,"%f",&epsilon);
else goto lc;
if((epsilon>0.99)||(epsilon<0.001)) goto lc;
noefs:
printf("   NUMBER OF EPOCHS FOR STEP=");
/*scanf("%d",&nes);*/
scanf("%s",teststring1);
if(!strpbrk(teststring1,teststring2)) sscanf(teststring1,"%d",&nes);
else goto noefs;
ren:
printf("   EXAMPLES FILENAME:");
scanf("%s",filearn);
if(!(fp=fopen(filearn,"r")))
    {
     printf("   ERROR OPENING FILE\n");
     goto ren;
    }
printf("   WEIGHT RANDOM INITIALIZATION?[Y/(N)]:");
scanf("%s",rand_resp);
if((!strncmp(rand_resp,"y",1))||(!strncmp(rand_resp,"Y",1))) weight_starter(); /*weights initialization!=0*/
k=0;
while(k!=(nx+ny)*ne) 
    {
    fscanf(fp,"%f",&exemp);             /*reading examples from file*/
    esempi[k++]=exemp;
    }
learn();
fclose(fp);
return;
 }




weight_starter()
   {
    int j=0;
    int k=0;
    float r,q1,q2;
    while(j!=ny)
      {
       k=0;
       while(k!=nh2+1) 
         {
          q1=rand();
          q2=rand();
          if(q1>q2) r=q2/q1;
          else r=-q1/q2;
          w3[j][k++]=r;
         }
       j++;
      }

    j=k=0;
    while(j!=nh2)
      {
       k=0;
       while(k!=nh1+1) 
         {
          q1=rand(); 
          q2=rand(); 
          if(q1>q2) r=q2/q1; 
          else r=-q1/q2;
          w2[j][k++]=r;
         }
       j++;
      }

    j=k=0;
    while(j!=nh1)
      {
       k=0;
       while(k!=nx+1) 
        {
         q1=rand(); 
         q2=rand(); 
         if(q1>q2) r=q2/q1; 
         else r=-q1/q2;
         w1[j][k++]=r;
        }
       j++;
      }
    return;
   }







load_weight()
/*it loads the weights from file */
  {
  char weight_file[maxline];
           FILE *w_fp;
           float weight;
           int n_w;       /*input number defined in the file*/
           int m_w;       /*output number defined in the file*/
           int h1_w;      /*neurons h1 number defined in the file*/
           int h2_w;      /*neurons h2 number defined in the file*/
           int j=0;
           int k=0;
           printf("   INPUT FILENAME:");
           scanf("%s",weight_file);
           if(!(w_fp=fopen(weight_file,"r")))
             {
              printf("   ERROR OPENING FILE\n");
              return;
             }
           fscanf(w_fp,"%d",&n_w);
           fscanf(w_fp,"%d",&m_w);
           fscanf(w_fp,"%d",&h1_w);
           fscanf(w_fp,"%d",&h2_w);
           if((nx!=n_w)||(ny!=m_w)||(nh1!=h1_w)||(nh2!=h2_w))
              {
               printf("    ERROR:\n");
               printf("    NUMBER OF UNITS X : %d\n",n_w);
               printf("    NUMBER OF UNITS Y : %d\n",m_w);
               printf("    NUMBER OF UNITS H1: %d\n",h1_w);
               printf("    NUMBER OF UNITS H2: %d\n",h2_w);
               return;
              }
           j=0;
           while(j!=ny)
             {
              k=0;
              while(k!=nh2+1)
                  {
                   fscanf(w_fp,"%f",&weight);
                   w3[j][k]=weight;
                   k++;
                  }
              j++;
             }



            j=k=0;
            while(j!=nh2)
              {
               k=0;
               while(k!=nh1+1)
                   {
                    fscanf(w_fp,"%f",&weight);
                    w2[j][k]=weight;
                    k++;
                   }
               j++;
              }


            j=k=0;
           while(j!=nh1)
            {
              k=0;
              while(k!=nx+1)
                  {
                   fscanf(w_fp,"%f",&weight);
                   w1[j][k]=weight;
                   k++;
                  }
              j++;
             }
           fclose(w_fp);
           return;
  }



save_weight(aut,aut_name)
 int aut;
 char *aut_name;
/*salva i pesi della rete di test*/
  {
   char weight_file[maxline];
   char weight_line1[maxline];/*pesi y-h*/
   char weight_line2[maxline];/*pesi h-x*/
           FILE *w_fp;
           int j=0;
           int k=0;
           if(!aut)
           {
            printf("   OUTPUT FILENAME:");
            scanf("%s",weight_file);
           }
           if(aut) sprintf(weight_file,"%s",aut_name);
           if(!(w_fp=fopen(weight_file,"w")))
               {
                printf("   ERROR FILE CREATION\n");
                return;
               }
           fprintf(w_fp,"%d\n",nx); /*numero unita` livello x utilizzate*/
           fprintf(w_fp,"%d\n",ny); /*numero unita` livello y utilizzate*/
           fprintf(w_fp,"%d\n",nh1); /*numero unita` livello h1 utilizzate*/
           fprintf(w_fp,"%d\n",nh2); /*numero unita` livello h2 utilizzate*/
           j=0;
           while(j!=ny)
              {
               k=0;
               while(k!=nh2+1)fprintf(w_fp," %f ",w3[j][k++]);
               fprintf(w_fp,"\n");
               j++;
              }

           j=k=0;
           while(j!=nh2)
              {
               k=0;
               while(k!=nh1+1)fprintf(w_fp," %f ",w2[j][k++]);
               fprintf(w_fp,"\n");
               j++;
              }


           j=k=0;
           while(j!=nh1)
              {
               k=0;
               while(k!=nx+1)fprintf(w_fp," %f ",w1[j][k++]);
               fprintf(w_fp,"\n");
               j++;
              }
           fclose(w_fp);
           return;
  }



set_autosave()
   {
    char response[maxline];
    printf("   DO YOU WANT AUTOMATIC WEIGHT SAVE?[Y/N]:");
    scanf("%s",response);
    if((!strncmp(response,"y"))||(!strncmp(response,"Y")))
      {
       autosave=1;
       noefas:
       printf("   NUMBER OF EPOCHS FOR ANY SAVE ?");
       /*scanf("%d",&n_save);*/
       scanf("%s",teststring1);
       if(!strpbrk(teststring1,teststring2)) sscanf(teststring1,"%d",&n_save);
       else goto noefas;
       printf("   AUTOMATIC WEIGHT SAVE OF %d EPOCHS ACTIVED\n",n_save);
       printf("   OUTPUT FILENAME:");
       scanf("%s",auto_name);
      }
      else
      {
       autosave=0;
       printf("   AUTOMATIC SAVE DISACTIVED\n");
      }
    return;
   }



editor()
  {
   char file[maxline];
   char comand[maxline];
   printf("   FILENAME:");
   scanf("%s",file);
   sprintf(comand,"edit %s",file);
   system(comand);
   return;
  }






