/*
 * Decompiled with CFR 0.152.
 */
package com.uptimenotifier.client;

import com.sun.net.ssl.internal.ssl.Provider;
import com.uptimenotifier.client.Base64;
import com.uptimenotifier.client.ClientProperties;
import com.uptimenotifier.client.NameValuePair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Security;
import java.util.Iterator;
import java.util.Vector;

public class UptimeNotifierClient {
    static final String VERSION = "1.0";
    static final String DEF_SERVER_ADDR = "defaultServerAddress";
    static final String MSG_PROXY_PORT = "proxyPort not set in config file";
    static final String MSG_PROXY_USER_ID = "proxyUserID not set in config file";
    static final String MSG_PROXY_PASSWORD = "proxyPassword not set in config file";
    static final String MSG_HTTP_OPEN = "Unrecoverable IO Exception during open of http connection";
    static final String MSG_UNDEFINED_TYPE = "Undefined request type";
    static final String MSG_SEC_PROP_FILE = "Security manager has denied access to the properties file.";
    static final String MSG_SYS_PROP_NULL = "A property key or value is null";
    static final String MSG_NO_DEF_SERVER = "NotificationServer not specified.";
    static final short UNDEF_TYPE_ERR = -1;
    static final short PROP_SEC_ERR = -4;
    static final short PROXY_PORT_ERR_CDE = -8;
    static final short PROXY_USER_ID_ERR_CDE = -9;
    static final short PROXY_PASSWORD_ERR_CDE = -10;
    static final short PROP_NULL_ERR = -12;
    static final short NO_DEF_SERVER_ERR_CDE = -15;
    static ClientProperties properties;
    static boolean verbose;

    public static void main(String[] args) {
        UptimeNotifierClient client = new UptimeNotifierClient();
        UptimeNotifierClient.sendNotification();
    }

    public static void sendNotification() {
        try {
            properties = new ClientProperties(System.getProperties());
        }
        catch (Exception exception) {
            // empty catch block
        }
        UptimeNotifierClient.initializeProperties(properties);
        UptimeNotifierClient.buildMessage();
        UptimeNotifierClient.sendMessage(UptimeNotifierClient.lookUpServers());
    }

    static Vector lookUpServers() {
        Vector<String> notifierServers = new Vector<String>();
        if (properties.getProperty("directoryAddress") != null) {
            try {
                URL aURI = new URL(properties.getProperty("directoryAddress"));
                if (verbose) {
                    System.out.println("Starting connection to directory " + aURI.toString());
                }
                HttpURLConnection directConn = null;
                directConn = (HttpURLConnection)aURI.openConnection();
                directConn.setDoOutput(true);
                directConn.setUseCaches(false);
                if (properties.getProperty("useProxy", "N").equals("Y") && properties.getProperty("useProxyAuth", "N").equals("Y")) {
                    directConn.setRequestProperty("Proxy-Authorization", UptimeNotifierClient.encodeProxyAuth());
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(directConn.getInputStream()));
                if (verbose) {
                    System.out.println("Connected to directory " + aURI.toString());
                }
                String line = null;
                while ((line = in.readLine()) != null) {
                    notifierServers.addElement(line);
                    if (!verbose) continue;
                    System.out.println("Server to try: " + line);
                }
                directConn.disconnect();
            }
            catch (IOException ioe) {
                System.err.println(MSG_HTTP_OPEN);
                System.err.println(ioe.getMessage());
            }
        } else if (properties.getProperty(DEF_SERVER_ADDR) != null) {
            notifierServers.addElement(properties.getProperty(DEF_SERVER_ADDR));
            if (verbose) {
                System.out.println("Using default server: " + properties.getProperty(DEF_SERVER_ADDR));
            }
        } else {
            UptimeNotifierClient.genError(MSG_NO_DEF_SERVER, (short)-15);
        }
        return notifierServers;
    }

    /*
     * WARNING - void declaration
     */
    static void sendMessage(Vector notifierServers) {
        if (verbose) {
            System.out.println("POSTing message: " + properties.getProperty("formattedMessage"));
        }
        Iterator i = notifierServers.iterator();
        while (i.hasNext()) {
            String server = i.next().toString();
            try {
                String inputLine;
                boolean serverComm = false;
                if (server.startsWith("https")) {
                    Security.addProvider((java.security.Provider)new Provider());
                    System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                }
                URL notificationServer = new URL(server);
                HttpURLConnection conn = (HttpURLConnection)notificationServer.openConnection();
                if (verbose) {
                    System.out.println("Trying: " + notificationServer.toString());
                }
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setDefaultUseCaches(false);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-length", Integer.toString(properties.getProperty("formattedMessage").length()));
                conn.setRequestProperty("user-agent", "NotifierJavaClient/1.0");
                if (properties.getProperty("useProxy", "N").equals("Y") && properties.getProperty("useProxyAuth", "N").equals("Y")) {
                    conn.setRequestProperty("Proxy-Authorization", UptimeNotifierClient.encodeProxyAuth());
                }
                PrintStream psout = new PrintStream(conn.getOutputStream());
                psout.print(properties.getProperty("formattedMessage"));
                psout.flush();
                psout.close();
                BufferedReader is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((inputLine = is.readLine()) != null) {
                    void var8_9;
                    if (var8_9.startsWith(Integer.toString(202)) || var8_9.startsWith(Integer.toString(201)) || var8_9.startsWith(Integer.toString(401)) || var8_9.startsWith(Integer.toString(403)) || var8_9.startsWith(Integer.toString(400)) || var8_9.startsWith(Integer.toString(402)) || var8_9.startsWith(Integer.toString(200))) {
                        System.out.println((String)var8_9);
                        serverComm = true;
                        continue;
                    }
                    if (!verbose) continue;
                    System.out.println((String)var8_9);
                }
                is.close();
                conn.disconnect();
                if (!serverComm) continue;
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void printUsage() {
        System.out.println("UptimeNotifier Client version 1.0,");
        System.out.println(" Copyright (C) 2002 UptimeNotifier");
        System.out.println("This client comes with ABSOLUTELY NO WARRANTY;");
        System.out.println("This is free software, and you are welcome to redistribute it");
        System.out.println("under certain conditions; see the Gnu GPL for details.");
        System.out.println("Usage:");
        System.out.println(" java -jar [-options] UptimeNotifier.jar\n");
        System.out.println("where options include:  ( -D<name>=<value> )");
        System.out.println("\trequest              : the request type (P/G/C/T)");
        System.out.println("\taccountID            : the account ID");
        System.out.println("\tpassword             : the account password\n");
        System.out.println("\teventID              : the event ID");
        System.out.println("\tuserID               : the Uptiemnotifier user id");
        System.out.println("\tmessage              : the message to be sent");
        System.out.println("\tpropertiesFile       : the location of the properties file");
        System.out.println("\tuseProxy             : tells the client to use a proxy");
        System.out.println("\tproxyAddress         : the URI of the proxy server");
        System.out.println("\tproxyPort            : the port to use on the proxy server");
        System.out.println("\tproxyUserID          : the proxy server user id");
        System.out.println("\tproxyPassword        : the password for the proxy user");
        System.out.println("\tdirectoryAddress     : the directory to use");
        System.out.println("\tdefaultServerAddress : the URI of the server to use");
        System.out.println("\thelp                 : provide usage message");
        System.out.println("\tverbose              : display more output (useful for problem-solving)");
    }

    static void genError(String message, short code) {
        System.err.println(message);
        System.exit(code);
    }

    static void buildMessage() {
        String paramStr = NameValuePair.makeNameValuePair("request", properties.getProperty("request"), true) + NameValuePair.makeNameValuePair("accountID", properties.getProperty("accountID"), false) + NameValuePair.makeNameValuePair("password", properties.getProperty("password"), false);
        switch (properties.getProperty("request").charAt(0)) {
            case 'P': {
                paramStr = paramStr + NameValuePair.makeNameValuePair("eventID", properties.getProperty("eventID"), false);
                break;
            }
            case 'G': {
                paramStr = paramStr + NameValuePair.makeNameValuePair("userID", properties.getProperty("userID"), false) + NameValuePair.makeNameValuePair("message", properties.getProperty("message"), false);
                break;
            }
            default: {
                UptimeNotifierClient.genError("Undefined request type: " + properties.getProperty("request").charAt(0), (short)-1);
            }
        }
        properties.setProperty("formattedMessage", paramStr);
    }

    static String encodeProxyAuth() {
        String authString = null;
        if (properties.getProperty("proxyUserID") != null) {
            if (properties.getProperty("proxyPassword") != null) {
                authString = properties.getProperty("proxyUserID") + ":" + properties.getProperty("proxyPassword");
            } else {
                UptimeNotifierClient.genError(MSG_PROXY_PASSWORD, (short)-10);
            }
        } else {
            UptimeNotifierClient.genError(MSG_PROXY_USER_ID, (short)-9);
        }
        return "Basic " + Base64.encode(authString.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeProperties(ClientProperties properties) {
        block18: {
            try {
                block17: {
                    try {
                        if (properties.getProperty("verbose") != null) {
                            verbose = true;
                        }
                        if (properties.getProperty("help") != null) {
                            UptimeNotifierClient.printUsage();
                            System.exit(0);
                        }
                        if (properties.getProperty("useProxy", "N").equals("Y")) {
                            System.getProperties().put("proxySet", properties.getProperty("useProxy", "Y"));
                            if (properties.getProperty("proxyAddress") != null) {
                                System.getProperties().put("proxyHost", properties.getProperty("proxyAddress"));
                            } else {
                                System.err.println("proxyHost property not set");
                            }
                            if (properties.getProperty("proxyPort") != null) {
                                System.getProperties().put("proxyPort", properties.getProperty("proxyPort"));
                            } else {
                                UptimeNotifierClient.genError(MSG_PROXY_PORT, (short)-8);
                            }
                            if (verbose) {
                                System.out.println("Using a proxy server at " + properties.getProperty("proxyAddress"));
                            }
                            break block17;
                        }
                        properties.setProperty("useProxy", "N");
                    }
                    catch (NullPointerException npe) {
                        System.err.println(npe.getMessage());
                        UptimeNotifierClient.genError(MSG_SYS_PROP_NULL, (short)-12);
                        Object var4_2 = null;
                        if (verbose) {
                            System.out.println("************ START PROPERTIES LIST   **********");
                            System.out.println(properties);
                            System.out.println("************  END  PROPERTIES LIST   **********");
                        }
                        break block18;
                    }
                    catch (SecurityException sex) {
                        UptimeNotifierClient.genError(MSG_SEC_PROP_FILE, (short)-4);
                        Object var4_3 = null;
                        if (verbose) {
                            System.out.println("************ START PROPERTIES LIST   **********");
                            System.out.println(properties);
                            System.out.println("************  END  PROPERTIES LIST   **********");
                        }
                    }
                }
                Object var4_1 = null;
                if (verbose) {
                    System.out.println("************ START PROPERTIES LIST   **********");
                    System.out.println(properties);
                    System.out.println("************  END  PROPERTIES LIST   **********");
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (verbose) {
                    System.out.println("************ START PROPERTIES LIST   **********");
                    System.out.println(properties);
                    System.out.println("************  END  PROPERTIES LIST   **********");
                }
                throw throwable;
            }
        }
    }

    static {
        VERSION = VERSION;
        DEF_SERVER_ADDR = DEF_SERVER_ADDR;
        MSG_PROXY_PORT = MSG_PROXY_PORT;
        MSG_PROXY_USER_ID = MSG_PROXY_USER_ID;
        MSG_PROXY_PASSWORD = MSG_PROXY_PASSWORD;
        MSG_HTTP_OPEN = MSG_HTTP_OPEN;
        MSG_UNDEFINED_TYPE = MSG_UNDEFINED_TYPE;
        MSG_SEC_PROP_FILE = MSG_SEC_PROP_FILE;
        MSG_SYS_PROP_NULL = MSG_SYS_PROP_NULL;
        MSG_NO_DEF_SERVER = MSG_NO_DEF_SERVER;
        UNDEF_TYPE_ERR = (short)-1;
        PROP_SEC_ERR = (short)-4;
        PROXY_PORT_ERR_CDE = (short)-8;
        PROXY_USER_ID_ERR_CDE = (short)-9;
        PROXY_PASSWORD_ERR_CDE = (short)-10;
        PROP_NULL_ERR = (short)-12;
        NO_DEF_SERVER_ERR_CDE = (short)-15;
        verbose = false;
    }
}

