/*************************************************************************/
/*                APLCOPY  - copy function for APL                       */
/*
 *  CopyRight 1995. Nicholas Poljakov all rights reserved.
 */
/*************************************************************************/


#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <state1.h>
#define MAX_PATH 40
#define ESC '\033'

extern char lu_id[8];
struct find_t find;
extern *pa[2];
extern char tp_id[8];
extern unsigned  long conv_id;
extern char tp_exist;
extern struct  part {            /* partner structure */
		  char	 plu[8] ;	     /* str plu_name	    */
                  int psl;                    /* str plu_s_limit     */
		  char	 mode_name[8] ;	     /* str mode_name	    */
                  int max_ru_size;            /* str ru_h_size       */
                  int pacing;                 /* str =               */
                  unsigned char lu_type;
               }  pstr[4];


/**************************************************************************/
/*      RcvFile - receive file from remote LU.                            */
/**************************************************************************/

    RcvFile ( char *p , int from)
 {
    unsigned char rts;
    unsigned char wr;
    unsigned int max_length ;
    unsigned  char tpn[64];
    struct rc {
                unsigned int prim;
                unsigned long sec;
              } v_rc;
    unsigned long rc;
    char p_lu[9];
    char p_mode[9];
    int length;

              if (!tp_exist) {
                                tp_started
                                            (lu_id,
                                             tp_id,
                                             &rc);
                                if (rc != 0) {
                                                return (-1);
                                              }
                                tp_exist = 1; /* TP_started O.K! */
                             }

              strcpy (tpn,"RCV "); /* name of work */
              strcat (tpn, p );      /* name of file */
              /*conv_id - return param -id work link */
              strcpy(p_lu, pstr[from-1].plu);
              strcpy(p_mode, pstr[from-1].mode_name);
                   allocate  (p_lu,
                              p_mode,
                              tpn,
                              WHEN_SESSION_ALLOCATED,
                              NONE,
                              NONE,
                              NULL,
                              NULL,
                              tp_id,
                              &conv_id,
                              NULL,
                              &v_rc) ;


                  if (v_rc.prim != 0) {
                                          return (-1);
                                       }

            rcv(p-5);
     return 0;
 }

 /**************************************************************************/
 /*          RmtCopy - copy file between remote LUs                        */
 /**************************************************************************/
   RmtCopy (char *p, int from, int to)
 {
      int ch;


           window(14);
           window_xy(14, 1, 4);
           window_puts(14, "Function not supported");
           while ((ch = getch()) != ESC) ;
           deactivate(14);
           return 0;
 }
 /**************************************************************************/
 /*          CpyFile - copy file into directories of one LU                */
 /**************************************************************************/
   CpyFile(p)
        char *p; {
    long FS; /* File Size */
    int fod;
    int fid;
    char *buff; /* input buffer */
    char fsiz[10];
    unsigned s;
    long count;
    unsigned len;
    int ch, i;
    char pt[80];


    if(( fid = open(p, O_RDONLY | O_BINARY)) < 0){
        window(20);
        window_xy(20, 6, 1);
        strcpy(pt, "Error file open. Press ESC to continue.");
        window_puts(20, pt);
	goto CopyExit;
    }
    FS = filelength( fid );
    sprintf(fsiz, "%lu", FS);
    len = _memmax();

    if ((buff = malloc(len)) == NULL) {
        return 1;
    }
    window(20);
    window_xy(20, 1, 20);
    strcpy(pt, "COPY");
    window_puts(20, pt);
    window_xy(20, 2, 1);
    strcpy(pt, "File name...................");
    strcat(pt, p);
    window_puts(20, pt);
    window_xy(20, 3, 1);
    strcpy(pt, "File size...................");
    strcat(pt, fsiz);
    window_puts(20, pt);
    window_xy(20, 4, 1);
    strcpy(pt, "Send count..................0");
    window_puts(20, pt);


	strcpy(pt, pa[1]);
	pt[i = strlen(pt)] = 92;
	pt[i+1] = 0x00;
        strcat(pt, p);


        if ( _dos_findfirst(pt,0xffff,&find))
                goto NEWF;
        window(14);
        window_xy(14, 1, 6);
        window_puts(14, "File alredy exists.");
        window_xy(14, 2, 3);
        window_puts(14, "Do you wish to overwrite?");
        window_xy(14, 3, 10);
        window_puts(14, "Reply Y/N.");
        window_xy(14, 3, 20);
     ReIn:
        ch = getch();
        ch &= 0x00ff;
        if ((ch == 'y')||(ch == 'Y')) {
	     deactivate( 14 );
	     goto NEWF;
        }
        else
             if ((ch == 'n')||(ch == 'N')) {
                deactivate( 14 );
                window_xy(20, 6, 1);
                strcpy(pt, "Copy aborted!  Press ESC to continue.");
                window_puts(20, pt);
                goto CopyExit;
             }
             else
                goto ReIn;

        NEWF:
	if ((fod = open(pt,O_WRONLY | O_CREAT | O_BINARY)) < 0) {
              window(14);
              window_xy(14, 2, 5);
              window_puts(14, "Error File Open");
              window_xy(14, 3, 4);
              window_puts(14, "Press ESC to continue");
              while ((ch = getch()) != ESC) ;
              goto CopyExit;
        }
    count = 0;
    while ((s = read(fid,buff,len)) != 0) {
    /*  Copy this line */
       count += s;
       window_xy(20, 4, 29);
       sprintf(fsiz, "%lu", count);
       window_puts(20, fsiz);
       write(fod,buff,s);
    }
    window_xy(20, 6, 1);
    strcpy(pt, "Ready!  Press ESC to continue.");
    window_puts(20, pt);

CopyExit:
    while ((ch = getch()) != ESC) ;
    deactivate(20);
    close( fid );
    close( fod );
    free( buff );

    return (0);
}


/**************************************************************************/
/*              ROCopy - copy file into remote LU                         */
/**************************************************************************/
ROCopy(char *p, int from)
  {
    unsigned char rts;
    unsigned char wr;
    char fsiz[10];
    long count;
    unsigned int ch;
    int i;
    unsigned int max_length ;
    unsigned  char tpn[64];
    struct rc {
                unsigned int prim;
                unsigned long sec;
              } v_rc;
    unsigned long rc;
    char p_lu[9];
    char p_mode[9];
    int length;
    char pt[80];
    struct msg {  /*send_data*/
                  int len;
                  union dt{
                      char str[MAX_PATH];
                      struct{
                             char rcw;
                             unsigned long lncp;
                            } inf;
		  } dt ;
                } gds;

              if (!tp_exist) {
                                tp_started
                                            (lu_id,
                                             tp_id,
                                             &rc);
                                if (rc != 0) {
                                                return (-1);
                                              }
                                tp_exist = 1; /* TP_started O.K! */
                             }

              strcpy (tpn,"COPY "); /* name of work */
              strcat (tpn, p );      /* name of file */
              /*conv_id - return param -id work link */
              strcpy(p_lu, pstr[from].plu);
              strcpy(p_mode, pstr[from].mode_name);
                   allocate  (p_lu,
                              p_mode,
                              tpn,
                              WHEN_SESSION_ALLOCATED,
                              NONE,
                              NONE,
                              NULL,
                              NULL,
                              tp_id,
                              &conv_id,
                              NULL,
                              &v_rc) ;


                  if (v_rc.prim != 0) {
                                          return (-1);
                                       }
                  for (i=0;i<2;i++){

		    memcpy(gds.dt.str, pa[i],strlen(pa[i])) ;
                       gds.len =strlen(pa[i]+2);
                       length=gds.len;
                       send_data(tp_id,
                                 conv_id,
                                 &gds,
                                 0,
                                 0,
                                 length,
                                 &v_rc,
                                 &rts);

                       if (v_rc.prim != 0) {
                                          return (-1);
                                            }
                  }/* for */

               window(20);
               window_xy(20, 1, 20);
               strcpy(pt, "COPY");
               window_puts(20, pt);
               window_xy(20, 2, 1);
               strcpy(pt, "File name...................");
               strcat(pt, p);
               window_puts(20, pt);
                   max_length = 255;
                   recwait (tp_id,
                            conv_id,
                            ll,
                            &v_rc,
                            &length,
                            max_length,
                            &rts,
                            &gds,
                            &wr);
                  if (v_rc.prim != 0) {
                                          return (-1);
                                       }
		  if (gds.dt.inf.rcw == 'n') {
                            window_xy(20, 6, 1);
                            strcpy(pt, "Error file open. Press ESC to continue.");
                            window_puts(20, pt);
                            goto ROCExit;
                   }
		  if (gds.dt.inf.rcw == 'e') {
/*     file already exist    */
                  window(14);
                  window_xy(14, 1, 4);
                  window_puts(14, "File alredy exists.");
                  window_xy(14, 2, 1);
                  window_puts(14, "Do you wish to overwrite?");
                  window_xy(14, 3, 8);
                  window_puts(14, "Reply Y/N.");
                  window_xy(14, 3, 20);
     ReIn:
	ch = getch();
        ch &= 0x00ff;
        if ((ch == 'y')||(ch == 'Y')) {

            deactivate(14);
            goto OW;
        }
        else
             if ((ch == 'n')||(ch == 'N')) {
                deactivate( 14 );
                  deallocate (tp_id,
                              conv_id,
                              Flush,
                              &v_rc);
                  if (v_rc.prim != 0) {
                              return -1;
                           }
                  window_xy(20, 6, 1);
                  strcpy(pt, "Copy aborted!  Press ESC to continue.");
                  window_puts(20, pt);
                  goto ROCExit;
             }
             else
                goto ReIn;
      } /* file already exist */

      OW:
         window_xy(20, 3, 1);
         strcpy(pt, "File size...................");
         sprintf(fsiz, "%lu", gds.dt.inf.lncp);
	 strcat(pt, fsiz);
         window_puts(20, pt);
         window_xy(20, 4, 1);
         strcpy(pt, "Send count..................0");
         window_puts(20, pt);
         count = 0;

         RWC:
                   max_length = 255;
                   recwait (tp_id,
                            conv_id,
                            ll,
                            &v_rc,
                            &length,
                            max_length,
                            &rts,
                            &gds,
                            &wr);

                  if (v_rc.prim == deallocate_normal) {
                             window_xy(20, 6, 1);
                             strcpy(pt, "Ready!  Press ESC to continue.");
                             window_puts(20, pt);
                             goto ROCExit;
                  }
                  window_xy(20, 4, 29);
                  count += gds.dt.inf.lncp;
                  sprintf(fsiz, "%lu", count);
		  window_puts(20, fsiz);

                   max_length = 255;
                   recwait (tp_id,
                            conv_id,
                            ll,
                            &v_rc,
                            &length,
                            max_length,
                            &rts,
                            &gds,
                            &wr);
                  if (v_rc.prim != 0) {
                                          return (-1);
                                       }
                  goto RWC;

ROCExit:
    while ((ch = getch()) != ESC) ;
    deactivate(20);
    return 0;
}
/*****************************************************************************/
/*              REM_CP - copy files into one remote LU                       */
/*****************************************************************************/
rem_cp ( p )
  char *p; {
    unsigned long FS; /* File Size */
    int fod;
    int fid;
    char ptf[80];
    char ptt[80];
    char *buff; /* input buffer */
    unsigned s;
    unsigned long count;
    unsigned len;
    char fsize[10];
    unsigned int max_length;
    int length;
    unsigned char rts;
    unsigned char wr;
    int  i;
    struct rc {
                unsigned int prim;
                unsigned long sec;
              } v_rc;
    unsigned long rc;
    struct msg {  /*send_data*/
                  int len;
		  union dt {
                      char str[MAX_PATH];
                      struct{
                             char rcw;
                             unsigned long lncp;
                            } inf;
		  } dt;
                } gds;

           max_length = 255;
           recwait (tp_id,
                    conv_id,
                    ll,
                    &v_rc,
                    &length,
                    max_length,
                    &rts,
                    &gds,
                    &wr);
          if (v_rc.prim != 0) {
                                  return (-1);
          }
    memcpy(ptf,gds.dt.str,gds.len-2);
    strcat(ptf,p+5);

           max_length = 255;
           recwait (tp_id,
                    conv_id,
                    ll,
                    &v_rc,
                    &length,
                    max_length,
                    &rts,
                    &gds,
                    &wr);
          if (v_rc.prim != 0) {
                                  return (-1);
          }
    memcpy(ptt,gds.dt.str,gds.len-2);
    strcat(ptt,p+5);

    if(( fid = open(ptf, O_RDONLY | O_BINARY))<0){
         gds.dt.inf.rcw = 'n';
         goto SD;
       }
    FS = filelength( fid );
    gds.dt.inf.lncp = FS;

    if ( _dos_findfirst(ptt,0xffff,&find)){
         gds.dt.inf.rcw = 'e';
         goto SD;
    } /* file already exist */

    gds.dt.inf.rcw = 'o';
     SD:
		       gds.len =sizeof(struct msg)+2;
                       length=gds.len;
                       send_data(tp_id,
                                 conv_id,
                                 &gds,
                                 0,
                                 0,
                                 length,
                                 &v_rc,
                                 &rts);

                       if (v_rc.prim != 0) {
                                          return (-1);
                                            }
                   max_length = 255;
                   recwait (tp_id,
                            conv_id,
                            ll,
                            &v_rc,
                            &length,
                            max_length,
                            &rts,
                            &gds,
                            &wr);

                  if (v_rc.prim == deallocate_normal) {

                                     tp_ended (tp_id, &rc);
                                     return 0;
                  }


    len = _memmax();

    if ((buff = malloc(len)) == NULL) {
       i = 1;
       goto RMCExit;
    }
    if ((fod = open(ptt,O_WRONLY | O_CREAT | O_BINARY)) < 0) {
              i = 1;
              goto RMCExit;
        }
    count = 0;
    while ((s = read(fid,buff,len)) != 0) {
    /*  Copy this line */
       count += s;
       write(fod,buff,s);

               gds.dt.inf.lncp = count;
	       gds.len =sizeof(struct msg)+2;
               length=gds.len;
               send_data(tp_id,
                         conv_id,
                         &gds,
                         0,
                         0,
                         length,
                         &v_rc,
                         &rts);

                if (v_rc.prim != 0) {
                                          i = 2;
                                          goto RMCExit;
                                     }
    }  /* while */

      deallocate (tp_id,
                  conv_id,
                  Flush,
                  &v_rc);
      if (v_rc.prim != 0) {
                              i = 2;
                              goto RMCExit;
                           }
      tp_ended (tp_id, &rc);
      i = 0;

      RMCExit:
        if (i != 1) {
                      close( fod );
                      free( buff );
                    }
        close( fid );
        if (i == 0)
                return 0;
        return -1;
  }
 /***************************************************************************/
