/*
*
* AutoHarp.c -- plays chords on key presses using Polyphonic Music functions
*
*****************/

#include "poly.h"
#include "polychrd.h"
#include <stdio.h>

main()
{
char c;   

   puts("AUTOHARP Simulator ver 1.10 - copr. 1989 GrigaSoft Productions");   
   puts("");
   puts(" Chords:  A   A#   B   C   C#   D   D#   E   F   F#   G   G#  ");
   puts("         --- ---- --- --- ---- --- ---- --- --- ---- --- ---- ");
   puts("");
   puts(" MAJOR:  <1>  <2> <3> <4>  <5> <6>  <7> <8> <9>  <0> <->  <=> ");
   puts("");
   puts(" MINOR:  <q>  <w> <e> <r>  <t> <y>  <u> <i> <o>  <p> <[>  <]> ");
   puts("");
   puts(" DIM:    <a>  <s> <d> <f>  <g> <h>  <j> <k> <l>  <;> <'>  <`> ");
   puts("");
   puts(" SEVNTH: <Shift>");
   puts("");
   puts(" Press keys to play chords (CAPS LOCK off). Press <ESC> to quit...");

   do {
      c = getch();
      switch (c)
         {
         case '1' : poly( a_maj );   break;
         case '2' : poly( ash_maj ); break;
         case '3' : poly( b_maj );   break;
         case '4' : poly( c_maj );   break;
         case '5' : poly( csh_maj ); break;
         case '6' : poly( d_maj );   break;
         case '7' : poly( dsh_maj ); break;
         case '8' : poly( e_maj );   break;
         case '9' : poly( f_maj );   break;
         case '0' : poly( fsh_maj ); break;
         case '-' : poly( g_maj );   break;
         case '=' : poly( gsh_maj ); break;
         case 'q' : poly( a_min );   break;
         case 'w' : poly( ash_min ); break;
         case 'e' : poly( b_min );   break;
         case 'r' : poly( c_min );   break;
         case 't' : poly( csh_min ); break;
         case 'y' : poly( d_min );   break;
         case 'u' : poly( dsh_min ); break;
         case 'i' : poly( e_min );   break;
         case 'o' : poly( f_min );   break;
         case 'p' : poly( fsh_min ); break;
         case '[' : poly( g_min );   break;
         case ']' : poly( gsh_min ); break;
         case '!' : poly( a_7 );     break;
         case '@' : poly( ash_7 );   break;
         case '#' : poly( b_7 );     break;
         case '$' : poly( c_7 );     break;
         case '%' : poly( csh_7 );   break;
         case '^' : poly( d_7 );     break;
         case '&' : poly( dsh_7 );   break;
         case '*' : poly( e_7 );     break;
         case '(' : poly( f_7 );     break;
         case ')' : poly( fsh_7 );   break;
         case '_' : poly( g_7 );     break;
         case '+' : poly( gsh_7 );   break;
         case 'Q' : poly( a_m7 );    break;
         case 'W' : poly( ash_m7 );  break;
         case 'E' : poly( b_m7 );    break;
         case 'R' : poly( c_m7 );    break;
         case 'T' : poly( csh_m7 );  break;
         case 'Y' : poly( d_m7 );    break;
         case 'U' : poly( dsh_m7 );  break;
         case 'I' : poly( e_m7 );    break;
         case 'O' : poly( f_m7 );    break;
         case 'P' : poly( fsh_m7 );  break;
         case '{' : poly( g_m7 );    break;
         case '}' : poly( gsh_m7 );  break;
         case 'a' : poly( a_dim );   break;
         case 's' : poly( ash_dim ); break;
         case 'd' : poly( b_dim );   break;
         case 'f' : poly( c_dim );   break;
         case 'g' : poly( csh_dim ); break;
         case 'h' : poly( d_dim );   break;
         case 'j' : poly( dsh_dim ); break;
         case 'k' : poly( e_dim );   break;
         case 'l' : poly( f_dim );   break;
         case ';' : poly( fsh_dim ); break;
         case SQ  : poly( g_dim );   break;
         case '`' : poly( gsh_dim ); break;
         case 'A' : poly( a_dim );   break;
         case 'S' : poly( ash_dim ); break;
         case 'D' : poly( b_dim );   break;
         case 'F' : poly( c_dim );   break;
         case 'G' : poly( csh_dim ); break;
         case 'H' : poly( d_dim );   break;
         case 'J' : poly( dsh_dim ); break;
         case 'K' : poly( e_dim );   break;
         case 'L' : poly( f_dim );   break;
         case ':' : poly( fsh_dim ); break;
         case '"' : poly( g_dim );   break;
         case '~' : poly( gsh_dim ); break;
         }
      }
   while (c != 27);   /* until <ESC> is pressed */
}
                     
