#ifndef __CCLIB_H
#define __CCLIB_H

#include <fcntl.h>
#include <graphics.h>
#include <io.h>

#define CCLIB16FNAME "CCLIB16"
#define CCLIB24FNAME "KT24"
// serach the above filename in current dir , then path

//#define SLIB16FNAME "SCCLIB16"
//#define SLIB24FNAME "SCCLIB24"

// serach the above filename only in current dir

#define CC16SIZE 32L
#define CC24SIZE 72L

struct cccodestruct{
	int code;
	long offset;
};

void inithz(char * exefilename);
void closehz();
void read16char(int code, void far *buf);
void read24char(int code, void far *buf);

// Following could be ASCII or Chinese Char
void outtextxy16(int x, int y, char far *string);
void outtextxy24(int x, int y, char far *string);

// Following should all be Chinese Char
void write16(int dx,int dy,int g,char far *string,int ik,int jk,int c);
void write24(int dx,int dy,int g,char far *string,int ik,int jk,int c);

// Following should be inner-code
void wcword24(int dx,int dy,int g,int cd[],int num,int ik,int jk,int c);
void wcword16(int dx,int dy,int d,int code[],int num,int ik,int jk,int col);
// dx,dy = coordinate
// d = char -- char's interleave
// code[], num = how many numbers
// ik, jk = enbigger
// col   = color

#ifdef __YYXMAIN

int handle16=-1,handle24=-1;	// handle for "CCLIB16" & "KT24"
int slibhandle16=-1, slibhandle24=-1;
int code16num=0, code24num=0;
struct cccodestruct far * code16table, * code24table;
int slib16changed =0, slib24changed =0;

char SLIB16FNAME[80];
char SLIB24FNAME[80];

#else

extern int handle16,handle24;
extern int slibhandle16, slibhandle24;
extern int code16num, code24num;
extern struct cccodestruct far *code16table , * code24table;
extern int slib16changed , slib24changed ;

extern char SLIB16FNAME[80];
extern char SLIB24FNAME[80];


#endif

#endif