/*
		About       GRPHMENU

This program is to generate a (ENGLISH / CHINESEg) graph-menu in DOS. 
It is mainly for users to develop their own (Chinese / English ) graph-based 
menu. It reads the .cfg file to get the menu contents and return diffrerent 
value to indicate the select result. It has wonderful sound effect and 
some time counting facility. Besides, it includes all SOURCE CODE !


To start it just type the exe file and the program will work.
The program is compiled with Borland C++ 3.1. It usually work on a VGA
monitor. 

With  SOURCE CODE , you can easily modify it for your own purpose.
You can distribute the source code freely only together with this readme
file. Since this is a shareware, you are required to register in order 
to use it in your own program. It will only cost you $50. 

However, if you do not like to pay so much, you can also pay as much as you 
wish to register. Just think the time and energe you will save by this 
program !

After you register for this program, you will get permission to 
include the source code to your own program. Besides,you will also 
get more detailed comments of the source code and you can get answers 
from author about any programming problems without extra fee.

Money and Check should mail to: 

Mr. Yongyong Xu,
1940 Howard Street. Apt. 333,
Kalamazoo, MI 49008
U.S.A.

Telephone: (616) 387-7569
EMail:  yxu@cs.wmich.edu   (prefered)
			or 
		99xu1@grog.lab.cc.wmich.edu


When you cannot reach me by the above address, try the next:
-----------------------------------------------------------------------
<Permanet Home Address>

Mr. Xu Yongyong,
Building 34 Room 604,
HuayuanXinCun , Chang Zhou
Jiang Su Province 213016
P.R.China

Tel:(86)-(519)-(328-0177)



*/

#define __YYXMAIN

#include <conio.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>
#include <dir.h>

#include "hz.h"
#include "siren.h"

// This program returns a value of menuitems;
// And it should run with a .BAT and .BAT decide to run what program
//

int menunum =0;
int menudefault=0;
int menuselect=0;
int xmax=639;
int ymax=479;
int timechanged =0;

struct  time timer;
struct date dater;
//time_t timer;     // Unix portable

int defaulttime=0;
long count=0;
char * menuitem[20];
char * menucomment[20];

char title0[80];
char title1[80];

char buf[80];
char ch[2];

#define INTR 0X1C    /* The clock tick interrupt */

#ifdef __cplusplus
	#define __CPPARGS ...
#else
	#define __CPPARGS
#endif

void interrupt ( *oldhandler)(__CPPARGS);
void no_quota(char *s);
void interrupt handler(__CPPARGS);
void readcfg();
int getmenu();

void interrupt handler(__CPPARGS)
{
	count++;
	if (count % 18 == 0) {
		timechanged =1;
		defaulttime --;
	}
	oldhandler();
}

void no_quota(char *s)
{
	if (s[0]=='\"') {
		strcpy (s, s+1);
	};
	if (s[strlen(s)-1]=='\"') s[strlen(s)-1]=0;
}


void readcfg(char *fname)
{
//  #define CFGFILENAME "MENU.CFG"

  FILE * filecfg;

  char string[1024];
  char substring[255];
  char * ptr;
  char ch;
  int setup_flag =0;

	filecfg =fopen ( fname ,"r+t");
	if ( filecfg == NULL ) return;
	do {
		fgets ( string, 1024, filecfg );
		if feof ( filecfg ) break;
		sscanf ( string, "%1s", substring );
		if  ( strcmp( substring, "#" ) == 0 ) goto Next;
		sscanf ( string, "%2s", substring );
		if  ( strcmp( substring, "//" ) == 0 ) goto Next;

		substring[0]=0;
		sscanf ( string, "%7s", substring );
		if  ( strcmpi ( substring,"[SOUND]") == 0 ) {
			setup_flag =2;      goto Next;
		}

		if (setup_flag ==2) {
			sscanf ( string, "%5s", substring );
				if ( strcmpi ( substring, "DELAY" ) == 0 ) {
					ptr = strchr ( string, '=' );
					ptr ++;
					sscanf ( ptr, "%d", &DELAY);
					goto Next;
				}
			sscanf ( string, "%4s", substring );
				if ( strcmpi ( substring, "RATE" ) == 0 ) {
					ptr = strchr ( string, '=' );
					ptr ++;
					sscanf ( ptr, "%d", &RATE);
					goto Next;
				}
		}

		substring[0]=0;
		sscanf ( string, "%7s", substring );
		if  ( strcmpi ( substring,"[TITLE]") == 0 ) {
			fgets (title0, 80, filecfg );
			if (title0[strlen(title0)-1]=='\n' )title0[strlen(title0)-1]=0;
			fgets (title1, 80, filecfg );
			if (title1[strlen(title1)-1]=='\n' )title1[strlen(title1)-1]=0;
			goto Next;
		}

		substring[0]=0;
		sscanf ( string, "%7s", substring );
		if  ( strcmpi ( substring,"[MENUS]") == 0 ) {
				setup_flag =1;              goto Next;
		}
		if (setup_flag ==1) {
			sscanf ( string, "%11s", substring );
				if ( strcmpi ( substring, "MENUDEFAULT" ) == 0 ) {
					ptr = strchr ( string, '=' );
					ptr ++;
					sscanf ( ptr, "%d %d", &menudefault, &defaulttime);
					menudefault --; if ( menudefault <0 ) menudefault=0;
					goto Next;
				}
			sscanf ( string, "%8s", substring );
				if ( strcmpi ( substring, "MENUITEM" ) == 0 ) {
					ptr = strchr ( string, '=' );
					ptr ++;
					menuitem[menunum] = (char * )calloc(256, sizeof(char));
					if (menuitem[menunum]==NULL) exit(-1);
					menucomment[menunum] = (char * )calloc(256, sizeof(char));
					if (menucomment[menunum]==NULL) exit(-1);
					sscanf ( ptr, "%s %s",menuitem[menunum],menucomment[menunum]);
					no_quota(menuitem[menunum]);
					no_quota(menucomment[menunum]);
//                  printf ( "%d.%s,%s\n", menunum,menuitem[menunum],menucomment[menunum]);
					menunum ++;
					//break;
				}
		}
Next:
	} while ( ! ( feof (filecfg)));
	if (( defaulttime <=0 ) || ( defaulttime >=60))  defaulttime = 60;
	fclose (filecfg );
}

#define DRAW_MENUTEXT(i,c1,c2)                                      \
	setfillstyle (SOLID_FILL,c1);                                   \
	bar ( x0, y0+linespc * i + 5 , x1, y0+linespc * i  + 4 +20 );   \
	setcolor ( c2 );                                                \
	outtextxy16( (x0+x1-strlen(menuitem[i])* 8)/2,                  \
		y0+ linespc * i  + 5, menuitem[i] );

#define DRAW_MENUCOMMENT(i )                                        \
	setfillstyle (SOLID_FILL, BLACK );                              \
	bar ( 100 , ymax -  90 , xmax - 100  , ymax - 40 );             \
	setcolor ( YELLOW );                                            \
	outtextxy16( ( 0 + xmax -strlen(menucomment[i])* 8)/2,          \
		ymax -  60 , menucomment [i] );


int getmenu()
{
  #define MESSAGE "Press ENTER When Selected"
  int i;
  int x0,y0,x1,y1;
  int width,height;
  int linespc;

	if ( menunum <= 0 ) return -1;

	xmax=getmaxx();
	ymax=getmaxy();

//  Show Menu
	//  Draw title
	//  setbkcolor (LIGHTBLUE);
	width =500;
	x0=( xmax - width ) /2;
	x1=( xmax + width ) /2;
	y0=20;
	y1=y0+30*2;
	setcolor (RED);
	rectangle (x0-10,y0-10,x1+10,y1+10);
	rectangle (x0-5,y0-5,x1+5,y1+5);

	setcolor (WHITE);
	outtextxy24( (x0+x1-strlen(title0 )*12) /2  ,y0, title0);
	outtextxy24( (x0+x1-strlen(title1 )*12) /2 ,y0+30, title1);

	// Draw Bottom Line
	setfillstyle (SOLID_FILL, CYAN);
	bar (0,ymax-20,xmax, ymax);
	setcolor ( BROWN );
	outtextxy16( (0+xmax-strlen(MESSAGE)*8)/2, ymax-20, MESSAGE );
	getdate (&dater);
	sprintf ( buf, "%d/%d/%d",dater.da_day, dater.da_mon, dater.da_year);
	setcolor ( RED );
	outtextxy( xmax-150, ymax-20, buf );

	// Draw Menus Line
	width = 280;
	linespc = ( ymax- y1 - 160 ) / menunum;

	x0=( xmax - width ) /2;
	x1=( xmax + width ) /2;
	y0=120;
	y1=y0+menunum * linespc +10;

	setcolor (GREEN);
	rectangle (x0-1 ,y0-1 ,x1+1 ,y1+1 );
	rectangle (x0-2 ,y0-2 ,x1+2 ,y1+2 );
	rectangle (x0-3 ,y0-3 ,x1+3 ,y1+3 );
	rectangle (x0-5,y0-5,x1+5,y1+5);

	// draw menus
	setcolor (WHITE);
	for (i=0;i<menunum; i++){
		outtextxy16( (x0+x1-strlen(menuitem[i])* 8)/2,
		y0+ linespc * i + 5, menuitem[i] );
	}

	// Select the default
	menuselect=menudefault;
	DRAW_MENUTEXT(menuselect ,YELLOW,  BLUE);
	DRAW_MENUCOMMENT(menuselect );
//  siren(2, DELAY, RATE);

  int   keypressed =0;

	do  {
		if (timechanged != 0 ) {
			setfillstyle (SOLID_FILL, CYAN);
			bar (xmax-80,ymax-20,xmax, ymax);
			setcolor (RED);
			gettime (&timer);
			sprintf (buf, "%2d:%02d:%02d", timer.ti_hour, timer.ti_min, timer.ti_sec );
			outtextxy(xmax-70,ymax-20, buf );
			timechanged =0;

			setfillstyle (SOLID_FILL, CYAN);
			bar (0,ymax-20,60, ymax);
			sprintf (buf, "%2d", defaulttime );
			outtextxy(20,ymax-20, buf );
			if ( defaulttime <= 0) break;
		}
		if (! keypressed ) siren(3, DELAY, RATE);
		if (!kbhit()) continue;
		keypressed =1;

		defaulttime =60;
		ch[0] = getch();
		ch[1] = '\0';
		if( strlen( ch ) == 1) {
			if  ( ch[0] == 0x1b ) {  //0x1b=27=ESC
				menuselect = -1;
				siren(1, DELAY, RATE);
				break;
			} else
			if( ch[0] == 13 ) {     //13=ENTER
				siren(0, DELAY, RATE);
				break;
			}
		} else  {   //ch[0]=0, LEFT, RIGHT, UP, DOWN keys
			ch[1]=getch();
			if ((ch[1]=='K') || (ch[1]=='H')) { //Left='K', Up='H'
				DRAW_MENUTEXT(menuselect , BLACK ,  WHITE );
				menuselect --;
				if ( menuselect < 0 ) menuselect =menunum -1;
				DRAW_MENUTEXT(menuselect , YELLOW , BLUE  );
				DRAW_MENUCOMMENT(menuselect );
				siren(0, DELAY / 15, RATE );
			} else
			if ((ch[1]=='M') || (ch[1]=='P')) { //Right='M', Down='M'
				DRAW_MENUTEXT(menuselect , BLACK ,  WHITE );
				menuselect ++;
				if ( menuselect >= menunum ) menuselect = 0;
				DRAW_MENUTEXT(menuselect , YELLOW , BLUE  );
				DRAW_MENUCOMMENT(menuselect );
				siren(0, DELAY / 15, RATE );
			}
		}
	} while( 1 );

	return ( menuselect + 1 );
}


int main(int argc,char *argv[])
{
  int gd=VGA,gm=VGAHI;
  int retvalue=0;

char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];
char path[80];

	strcpy (path, argv[0] );
	fnsplit(path,drive,dir,file,ext);
	strcpy (path, file );
	strcat (path, "." );
	strcat (path, "CFG" );

	readcfg(path);

	inithz(argv[0]);

	initgraph(&gd,&gm,"");
	oldhandler = getvect(INTR);
	setvect(INTR, handler);

	retvalue=getmenu();

	setvect(INTR, oldhandler);
	closegraph();
	closehz();
	while ( menunum > 0 ) {
		free ( menuitem[menunum-1]);
		free ( menucomment[menunum-1]);
		menunum--;
	}
	return retvalue;

}
