/****************************************************************************
*
*						  Protected Mode Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: alias.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:  Test program to check the ability to create both code
*				and data segment aliases from protected mode. This allows
*				one to modify code and to load and run code dynamically
*				at runtime. Compile and link with the appropriate command
*				line for your DOS extender.
*
*				Functions tested:	PMODE_allocCSAlias()
*									PMODE_allocDSAlias()
*									PMODE_freeAlias()
*
* $Id: alias.c 1.1 1994/03/10 09:05:43 kjb release $
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <mem.h>
#include "pmode.h"

/* Block of dummy code in the data segment that we wish to execute. Since
 * it must be relocateable we just simply make it do a far return (a near
 * return for 386 protected mode).
 */

unsigned char DummyCode[] = {
#ifdef	PMODE386
	0xC3
#else
	0xCB
#endif
	};

void DummyData(void)
{
	/* Dummy routine that we obtain a DS alias to and modify */

	printf("You should not get here!!!!!\n");
}

void main(void)
{
	void (*csalias)(void);
	unsigned short far *dsalias;
	void *memblock;

	printf("Program running in ");
	switch (_PMODE_modeType) {
		case PMODE_realMode:
			printf("real mode.\n\n");
			break;
		case PMODE_286:
			printf("16 bit protected mode.\n\n");
			break;
		case PMODE_386:
			printf("32 bit protected mode.\n\n");
			break;
		}

	/* Now create a DS alias for the literal value stored in the code
	 * segment at DummyData.
	 */

	dsalias = PMODE_createDSAlias(&DummyData);
	if (dsalias == NULL) {
		printf("Unable to create data segment alias!\n");
		exit(1);
		}

	/* Display the value stored in the DS alias, modify it and display
	 * the new value.
	 */

	printf("Old value at &Dummy(): 0x%04X\n", *dsalias);
	*dsalias = 0xCBAD;
	printf("New value at &Dummy(): 0x%04X\n", *dsalias);
	PMODE_freeDSAlias(dsalias);

	/* Now create a code segment alias to the block of dummy code we
	 * have allocated in the default data segment, and attempt to
	 * execute it.
	 */

	csalias = PMODE_createCSAlias(DummyCode);
	if (csalias == NULL) {
		printf("Unable to create code segment alias!\n");
		exit(1);
		}

	printf("Executing data in DGROUP ... ");
	(*csalias)();
	printf("Success!\n");
	PMODE_freeCSAlias(csalias);

	/* Now malloc a block of memory, copy the dummy code into it and
	 * attempt to execute the code from the heap.
	 */

	memblock = malloc(sizeof(DummyCode));
	if (memblock == NULL) {
		printf("Unable to allocate memory block!\n");
		exit(1);
		}
	memcpy(memblock, &DummyCode, sizeof(DummyCode));
	csalias = PMODE_createCSAlias(memblock);
	if (csalias == NULL) {
		printf("Unable to create code segment alias to malloc()'ed memory!\n");
		exit(1);
		}

	printf("Executing data on heap ... ");
	(*csalias)();
	printf("Success!\n");
	PMODE_freeCSAlias(csalias);
}
