//-------------------------------------------------------------------//
//  complement

//  Syntax:	complement ( A , B )

//  Description:

//  The complement function returns a vector-set that contains the
//  complement of A in B. In plain English: the elements of B that are
//  not in A.

//  See Also: intersection, set, union

//-------------------------------------------------------------------//

complement = function ( A, B )
{
  if (A.n == 0) { return [B]; }

  if (min (size (A)) != 1) 
  {
    error ("complement: 1st arg must be a vector");
  }

  if (min (size (B)) != 1) 
  {
    error ("complement: 2st arg must be a vector");
  }

  a = set (A); Comp = set (B);
  for (i in 1:a.n)
  {
    Comp = Comp[ find (a[i] != Comp) ];
  }
  return Comp
};
