(* FITTYPES.INC
   Pascal include file defining types for Nonlinear Fitter
   dynamic-link libraries
*)

const
  MaxParams=5;        { Max number of variable parameters }
  MaxDataPoints=1024; { Max number of residuals (observations) }
  MaxAddParams=8;     { Max number of additionally outputed parameters }
  ParamNameLen=9;     { Parameter name max length }
  MaxOutVectors=10;   { Max number of outputed vectors }
  VectorNameLen=20;   { Outputed vector name max length }

type
  TDataArray=array [1..MaxDataPoints] of double;
  PDataArray=^TDataArray;

  TOutVectorsArr=array [1..MaxOutVectors] of PDataArray;

  TParamArr=array [1..MaxParams] of double;

  TAddParArr=array [1..MaxAddParams] of double;
  TAddNameArr=array [1..MaxAddParams] of array [0..ParamNameLen] of char;
  TVectNameArr=array [1..MaxOutVectors] of array [0..VectorNameLen] of char;
  TErrMsg=array [0..80] of char;

(* A user supplied function for setting up the number of residuals or
   observations. The function also returns the number and names
   of scalar values, outputed by Approx routine, and the number,
   names and pointers to the vector values, which can be outputed to
   a data file.
   This function returns zero on success and nonzero value to
   indicate that something was wrong and that the iteration
   process must not be started

   ParamFile:PChar	- file name from InitData ParamFile field of
			  main window (input)

   DataPoints:integer	- number of residuals or number of data points
                          which are approximated (output)

   OutVectors:integer	- number of vectors which will be outputed to a
			  data file (output)

   AddOutValues:integer	- number of additionally outputed by Approx routine
			  scalar values (output)

   OutVectorsArray:     - array of pointers to the data arrays which will be
   TOutVectorsArr         written to the data file in responce to Data to
                          File command. These arrays must be allocated in
			  the DLL (output)

   OutVectorsNames:     - names of vectors in OutVectorsArray
   TVectNameArr           (output)

   AddNames:TAddNameArr	- array of names of AddOutValues (output)

   ErrMsg:TErrMsg	- error message returned if initialization was not
    		          successful (output)
*)

function InitData(ParamFile:PChar;
                  var DataPoints,OutVectors,AddOutValues:integer;
                  var OutVectorsArray:TOutVectorsArr;
                  var OutVectorsNames:TVectNameArr;
                  var AddNames:TAddNameArr;
                  var ErrMsg:TErrMsg):integer;export;forward;

(* A user supplied function for calculation of the residuals values.
   It returns zero on success and a value from 1 to 900 if something
   went wrong.

   Params:TParamArr	- vector containing the values of variable parameters
			  (input)

   Residuals:TDataArray	- vector containing residuals values, the sum of
                          squares of which is minimized (output)

   AddValues:TAddParArr	- array of additionally outputed scalar values which
			  will be displayed in iteration info panel and
                          may be printed or outputed to a file in responce
                          to Results to File command (output)

   DataPoints:integer	- number of Residuals, set up by InitData (input)

   TypeOfCall:integer	- 1 for call within iteration process, 2 for final 
			  call after iteration process, 3 for call when
			  calculating errors

   ErrMsg:TErrMsg	- error message returned (along with a nonzero
                          return value) if something was wrong (output)
*)

function Approx(var Params:TParamArr;
                var Residuals:TDataArray;
                var AddValues:TAddParArr;
                DataPoints,TypeOfCall:integer;
                var ErrMsg:TErrMsg):integer;export;forward;

