comment ! 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
! 
;
; This set of constants is initialized to what their values would be
; if the command RINIT(1234567,7654321) were used. This way, forgetting
; to call RINIT poses no problems.
;
  N equ 37              ; The number of 32 bit words in the table
  N2 equ 24             ;  x(i) = x(i-N) - x(i-N2)

counterpoint    STRUC
  c  dw 0               ; counter
  p  dw ?               ; offset for pointer
     dw ?               ; segment for pointer
  x  dd N dup (?)       ; data
ENDS

; To save the state of the generator, all the data from here >>>
swbstate equ this byte

swb32   counterpoint <,,seg(swb32)>
swb16   counterpoint <,,seg(swb16)>
swb8    counterpoint <,,seg(swb8) >
swb1    counterpoint <,,seg(swb1) >
org     $-4*N+32

swbseed dd  00D45D69Ah	; Seed values for the SWB generator
  dd  09DB73B1Ah, 0A84604E8h, 07C5F0CA5h, 0BC0196CEh, 0FF4CB42Eh, 07ACA6BE3h
  dd  0A9ED2A5Ah, 06405A8F7h, 0AC00D4F8h, 0BDD1FC77h, 0064F9DC5h, 0F10AB737h
  dd  0781293D3h, 08410C2D2h, 01C6587DBh, 07D8F8F0Fh, 0F3DCC4EAh, 0B965F99Fh
  dd  09A0094D1h, 065976D1Ch, 009173DC1h, 08E38B992h, 084701D44h, 014F0E1B9h
  dd  0E8A1EC5Fh, 01E925A12h, 0E77A0B5Bh, 0CDB5926Eh, 0D16260C8h, 0C917E806h
  dd  0519076AAh, 07BF6C21Ch, 0808C0C90h, 03E93C7B8h, 0707D6EA0h, 0F1DB698Dh

flags   db 0		; The carry flag for the SWB generator.
congx   dd 1C3A128Fh	; seed for x = 69069*x mod 2^32 congruential generator

;<<< to here must be saved

tmpq    dq ?
neg31   dw -31
neg63   dw -63
swbsize dw tmpq-swbstate	; The number of bytes in the seed

conglo  equ word ptr congx
conghi  equ word ptr congx+2
tmpw1   equ word ptr tmpq
tmpw2   equ word ptr tmpq+2
tmpw3   equ word ptr tmpq+4
tmpw4   equ word ptr tmpq+6
tmpdlo  equ dword ptr tmpq
tmpdhi  equ dword ptr tmpq+4
shrglo  equ tmpw1
shrghi  equ tmpw2
shrgx   equ tmpdlo

