DECLARE SUB inputarea (lowdom!, updom!, lowfunc!, upfunc!, colour!(), yfrom!, yto!, ynum!, xintpol!(), yintpol!(), nintpol!)
DECLARE SUB laginterpol (y#(), yprev#(), xintpol!(), yintpol!(), nintpol!, i#, stepper#)
DECLARE SUB statuspage (timetaken!, ynum!, perc!)
DECLARE SUB title ()
DECLARE SUB curvevalues (i#, y#(), colour!(), ynum!)
DECLARE FUNCTION fx# (x#, y#)
CONST pi# = 3.141592653589285#
'*****************************************************************************
CONST nnmax = 20                 'max number of curves
CONST points = 500              'no. of points in each curve
CONST monitor = 0               'define as 0 if output of values not reqd.
                                '1 if required to screen & 2 if reqd to file.
CONST file$ = "OUTPUT.TXT"      'output file name
CONST incr# = 1                  'increment in x if curve values reqd.
CONST setofgraphs = 1           '0 if differentials are required.
CONST linesjoin = 1             '1 if curves to be plotted using line segments.
CONST funcdef = 0               '0 if func is defined as f(x)=...
                                '1 if lagrange's interpolation to be used - SETOFGRAPHS MUST BE ZERO.
'*****************************************************************************
CLS
IF monitor = 2 THEN
        PRINT "Is file "; file$; " okay ?",
        okay$ = INPUT$(1)
        IF okay$ = "y" OR okay$ = "Y" THEN
                OPEN file$ FOR OUTPUT AS #1
        ELSE END
        END IF
END IF
okay:
CLS
IF nnmax < 1 THEN PRINT "Change NNMAX": GOTO fini
IF setofgraphs = 0 AND nnmax > 9 THEN PRINT "Change NNMAX or SETOFGRAPHS": GOTO fini
IF funcdef = 1 AND setofgraphs = 1 THEN PRINT "Change FUNCDEF or SETOFGRAPHS": GOTO fini

DIM colour(0 TO nnmax)
DIM SHARED y#(0 TO nnmax, 0 TO nnmax)
DIM SHARED yprev#(0 TO nnmax, 0 TO nnmax)
DIM SHARED xintpol(1 TO 100)
DIM SHARED yintpol(1 TO 100)

restart:
SCREEN 0, 0, 0
CLS

CALL inputarea(lowdom, updom, lowfunc, upfunc, colour(), yfrom, yto, ynum, xintpol(), yintpol(), nintpol)

SCREEN 12
WINDOW (lowdom, upfunc)-(updom, lowfunc)
LINE (lowdom, 0)-(updom, 0), 7, , &HAAAA
LINE (0, lowfunc)-(0, upfunc), 7, , &HAAAA
stepper# = (updom - lowdom) / points

steppermultiple# = incr / stepper#
ON ERROR GOTO handler
stepperchange = ABS((CINT(steppermultiple#) - steppermultiple#)) * stepper#
'IF monitor <> 0 AND stepperchange <> 0 THEN
'        PRINT "INCR FATAL ERROR !"
'        pointschange = (updom - lowdom) / stepperchange
'        PRINT pointschange
'        STOP
'END IF

timeinit = TIMER
'// overall loop starts
FOR i# = lowdom TO updom STEP stepper#
timetaken = TIMER - timeinit
IF INKEY$ = CHR$(27) THEN
        a$ = INPUT$(1)
        IF a$ = CHR$(27) THEN GOTO fini
        IF a$ = "r" OR a$ = "R" THEN GOTO restart
        IF a$ = "s" OR a$ = "S" THEN
                CALL statuspage(timetaken, ynum, perc)
                b$ = INPUT$(1)
                IF b$ = CHR$(27) THEN GOTO fini
                GOTO restart
        END IF
END IF
undefine = 0
perc = (i# - lowdom) / (updom - lowdom) * 100
'percprinted = 1: LOCATE percprinted, 77: PRINT USING "###%"; perc
timeleft = timetaken * 100 / perc - timetaken
IF timeleft < 60 THEN
        LOCATE percprinted + 1, 77
        PRINT USING "##.#"; timeleft
ELSE
        LOCATE percprinted + 1, 76
        PRINT USING "##"; INT(timeleft / 60);
        PRINT ":";
        LOCATE percprinted + 1, 79
        PRINT USING "##"; timeleft - INT(timeleft / 60) * 60
        IF timeleft - INT(timeleft / 60) * 60 < 10 THEN
                LOCATE percprinted + 1, 79: PRINT "0"
        END IF
END IF

SELECT CASE setofgraphs
CASE 0
        SELECT CASE funcdef
        CASE 0
                FOR b = 0 TO nnmax STEP 1
                yprev#(0, b) = y#(0, b)
                y#(0, b) = fx#(i# + b * stepper#, yfrom#)
                NEXT b
        CASE 1
                radius = 1.5 / 640 * (updom - lowdom)
                FOR kk = 1 TO nintpol
                        CIRCLE (xintpol(kk), yintpol(kk)), radius, 15
                NEXT kk
                CALL laginterpol(y#(), yprev#(), xintpol(), yintpol(), nintpol, i#, stepper#)
        END SELECT
        FOR a = 1 TO nnmax
        FOR b = 0 TO nnmax - a
        yprev#(a, b) = y#(a, b)
        y#(a, b) = (y#(a - 1, b + 1) - y#(a - 1, b)) / stepper#
        NEXT b
        NEXT a

        FOR a = 0 TO nnmax STEP 1
        IF undefine <> 1 THEN
                IF linesjoin = 1 THEN
                        IF y#(a, 0) < 10 * upfunc AND y#(a, 0) > 10 * lowfunc THEN
                                LINE (i# + .5 * (a - 1) * stepper#, yprev#(a, 0))-(i# + .5 * a * stepper#, y#(a, 0)), colour(a)
                        END IF
                ELSE
                        PSET (i# + .5 * a * stepper#, y#(a, 0)), colour(a)
                END IF
        END IF
        NEXT a
CASE 1
        IF ynum = 1 THEN
                yfrom# = yfrom
                yprev#(0, 0) = y#(0, 0)
                y#(0, 0) = fx#(i#, yfrom#)
        ELSE
                FOR a = 0 TO ynum - 1
                yinc# = (yto - yfrom) / (ynum - 1)
                ycurr# = yfrom + yinc# * a
                yprev#(a, 0) = y#(a, 0)
                y#(a, 0) = fx#(i#, ycurr#)
                NEXT a
        END IF
       
        FOR a = 0 TO ynum - 1 STEP 1
        IF a < 7 THEN
                c = a + 9
        ELSEIF a < 14 THEN
                c = a + 2
        ELSEIF a < 21 THEN
                c = a - 5
        END IF
        IF undefine <> 1 THEN
                IF linesjoin = 1 THEN
                        IF y#(a, 0) < 10 * upfunc AND y#(a, 0) > 10 * lowfunc THEN
                                LINE (i#, yprev#(a, 0))-(i# + stepper#, y#(a, 0)), c
                        END IF
                ELSE
                        PSET (i#, y#(a, 0)), c
                END IF
        END IF
        NEXT a
END SELECT

nvalprev = nval
nval = (i# - lowdom) / incr#
IF monitor <> 0 AND (nvalprev - CINT(nval)) * (nval - CINT(nval)) < 0 THEN
        CALL curvevalues(i#, y#(), colour(), ynum)
END IF

NEXT i#
'// overall loop ends
timetaken = TIMER - timeinit

LOCATE 1, 77: PRINT "Done"
LINE (lowdom, 0)-(updom, 0), 7, , &HAAAA
LINE (0, lowfunc)-(0, upfunc), 7, , &HAAAA
IF setofgraphs = 0 THEN
        LOCATE 30, 80 - nnmax
        FOR a = 0 TO nnmax
        COLOR colour(a): PRINT USING "#"; a;
        NEXT a
        COLOR 15
END IF

a$ = INPUT$(1)
IF a$ = "s" OR a$ = "S" THEN
   CALL statuspage(timetaken, ynum, perc)
   b$ = INPUT$(1)
   IF b$ = CHR$(27) THEN GOTO fini ELSE GOTO restart
ELSEIF a$ = CHR$(27) THEN
   GOTO fini
ELSE GOTO restart
END IF

handler:
  SELECT CASE ERR
    CASE 5
      undefine = 1
      RESUME NEXT
    CASE 11
      undefine = 1
      RESUME NEXT
    CASE 6
      undefine = 1
      RESUME NEXT
  END SELECT

fini:
CLOSE #1
END

SUB curvevalues (i#, y#(), colour(), ynum)
'use INCR# variable to define at what interval of x the curve values are required.

LOCATE 1, 1
IF monitor = 1 THEN PRINT USING "####.#####  "; i#;
IF monitor = 2 THEN PRINT #1, USING "####.#####  "; i#;
       
SELECT CASE setofgraphs
CASE 0
        FOR a = 0 TO nnmax
        COLOR colour(a)
        IF monitor = 1 THEN PRINT USING "####.#########  "; y#(a, 0);
        IF monitor = 2 THEN PRINT #1, USING "####.#########  "; y#(a, 0);
        NEXT a
        COLOR 15
        IF monitor <> 2 THEN a$ = INPUT$(1) ELSE PRINT #1,
CASE 1
        FOR a = 0 TO ynum - 1
        IF a < 7 THEN
                c = a + 9
        ELSEIF a < 14 THEN
                c = a + 2
        ELSEIF a < 21 THEN
                c = a - 5
        END IF
        'IF a < 15 THEN c = a + 1 ELSE c = a - 15
        COLOR c
        IF monitor = 1 THEN PRINT USING "####.#########  "; y#(a, 0);
        IF monitor = 2 THEN PRINT #1, USING "####.#########  "; y#(a, 0);
        NEXT a
        COLOR 15
        IF monitor <> 2 THEN a$ = INPUT$(1) ELSE PRINT #1,
END SELECT

END SUB

FUNCTION fx# (x#, y#)
'ON ERROR GOTO handler
'use x# when defining the function
'use y# as the stepped value
'when using differentiation mode, define y# in this module OR
' define fx# such that it does not contain y#
'use ERROR 5 to define function as UNDEFINED in certain regions

'function for viscous damped vibrations
k = 2000                        'spring stiffness in N/m
m = 10                          'mass in kg
x0 = 1                          'initial displacement in m
zeta# = y#                      'damping factor
cc = SQR(4 * k * m)
c = zeta# * cc
wn = SQR(k / m)

IF x# < 0 THEN ERROR 5
IF zeta# > 1 THEN
        c1 = x0 * (zeta# + SQR(zeta# ^ 2 - 1)) / (2 * SQR(zeta# ^ 2 - 1))
        c2 = x0 * (-zeta# + SQR(zeta# ^ 2 - 1)) / (2 * SQR(zeta# ^ 2 - 1))
        s1 = (-c + SQR(c ^ 2 - 4 * m * k)) / (2 * m)
        s2 = (-c - SQR(c ^ 2 - 4 * m * k)) / (2 * m)
        func# = c1 * EXP(s1 * x#) + c2 * EXP(s2 * x#)
        fx# = func#
ELSEIF zeta# = 1 THEN
        func# = x0 * (1 + wn * x#) * EXP(-wn * x#)
        fx# = func#
ELSEIF zeta# = 0 THEN
        func# = x0 / SQR(1 - zeta# ^ 2) * EXP(-zeta# * wn * x#) * SIN(SQR(1 - zeta# ^ 2) * wn * x# + pi / 2)
        fx# = func#
ELSEIF zeta# < 1 THEN
        func# = x0 / SQR(1 - zeta# ^ 2) * EXP(-zeta# * wn * x#) * SIN(SQR(1 - zeta# ^ 2) * wn * x# + ATN(SQR(1 - zeta# ^ 2) / zeta#))
        fx# = func#
END IF


END FUNCTION

SUB inputarea (lowdom, updom, lowfunc, upfunc, colour(), yfrom, yto, ynum, xintpol(), yintpol(), nintpol)
DIM o$(0 TO nnmax)
reenter:
CLS
CALL title
PRINT "NOTE: All curves will be plotted only in the domain in which"
PRINT "      the original function is valid.": PRINT : PRINT
INPUT "Enter left domain limit : ", lowdom
INPUT "Enter right domain limit : ", updom
INPUT "Enter lower function limit : ", lowfunc
INPUT "Enter upper function limit : ", upfunc
PRINT :
IF lowdom = updom OR lowfunc = upfunc THEN GOTO reenter
IF lowdom > updom THEN
        temp = lowdom
        lowdom = updom
        updom = temp
END IF
IF lowfunc > upfunc THEN
        temp = lowfunc
        lowfunc = upfunc
        upfunc = temp
END IF

SELECT CASE setofgraphs
CASE 0
        SELECT CASE funcdef
        CASE 1
                PRINT "Use values from last session ? "
                INPUT "Caution: Negative response will overwrite previous values. ", lastsess$

                IF lastsess$ = "y" OR lastsess$ = "Y" THEN
                        OPEN "LASTSESS.DAT" FOR INPUT AS #2
                        IF EOF(2) <> 0 THEN
                                PRINT "Values from last session not found !"
                                CLOSE #2
                                GOTO newvalues
                        END IF
                        INPUT #2, nintpol
                        FOR ii = 1 TO nintpol
                                INPUT #2, xintpol(ii), yintpol(ii)
                        NEXT ii
                        CLOSE #2
                ELSE
newvalues:
                        OPEN "LASTSESS.DAT" FOR OUTPUT AS #2
                        INPUT "Number of values to be processed : ", nintpol
                        PRINT #2, nintpol
                        IF nintpol < 2 THEN CLOSE #2: GOTO reenter
                        FOR ii = 1 TO nintpol
                        PRINT "Enter x("; ii; "),y("; ii; "): "; : INPUT "", xintpol(ii), yintpol(ii)
                        PRINT #2, xintpol(ii), yintpol(ii)
                        NEXT ii
                        CLOSE #2
                END IF
        CASE 0
        END SELECT
                PRINT USING "#"; nnmax; : PRINT " differential orders are currently available"
                INPUT "Plot all differential orders "; allgraph$
                IF allgraph$ = "n" OR allgraph$ = "N" THEN
                        PRINT "Enter differentiation orders to be plotted : "
                        FOR i = 0 TO nnmax STEP 1
                        PRINT "Plot y"; USING "#"; i; : INPUT o$(i)
                        NEXT i
                END IF

        FOR i = 0 TO nnmax STEP 1
        IF o$(i) = "n" OR o$(i) = "N" THEN
                colour(i) = 0
        ELSE IF i + 9 > 15 THEN c = i - 4 ELSE c = i + 9
                colour(i) = c
        END IF
        NEXT i
CASE 1
        PRINT "Enter variation in the y# value:"
        INPUT "y# to vary from : ", yfrom
        INPUT "             to : ", yto
        PRINT "Number of curves "; "(Max. "; USING "##"; nnmax; : PRINT USING "&"; ") :";
        INPUT " ", ynum: ynum = CINT(ynum)
        IF ynum = 0 THEN
                yincmin = (yto - yfrom) / (nnmax - 1)
                PRINT "Increment in y# "; "(Min. "; USING "##.####"; yincmin; : PRINT USING "&"; ") :";
                INPUT "", yipinc
                IF yipinc = 0 THEN GOTO reenter
                ynum = ((yto - yfrom) / yipinc) + 1
        END IF
        IF ynum = 1 THEN PRINT "Curve for y# = "; yfrom; "will be plotted": a$ = INPUT$(1)
        IF yfrom = yto AND ynum <> 1 THEN GOTO reenter
        IF ynum > nnmax THEN GOTO reenter
END SELECT

END SUB

SUB laginterpol (y#(), yprev#(), xintpol(), yintpol(), nintpol, i#, stepper#)

FOR b = 0 TO nnmax STEP 1
yprev#(0, b) = y#(0, b)
xk# = i# + b * stepper#
sum# = 0
FOR zi = 1 TO nintpol
        term# = 1
        FOR zj = 1 TO nintpol
                IF zj = zi THEN GOTO nextzj
                term# = term# * (xk# - xintpol(zj)) / (xintpol(zi) - xintpol(zj))
nextzj:
        NEXT zj
        sum# = sum# + term# * yintpol(zi)
NEXT zi
y#(0, b) = sum#
NEXT b

END SUB

SUB statuspage (timetaken, ynum, perc)
SCREEN 0, 0, 0
CLS
CALL title

PRINT "Status for last graph plotted": PRINT

PRINT
PRINT "No. of curves calculated : ";
IF setofgraphs = 0 THEN curvecalc = nnmax + 1 ELSE curvecalc = ynum
PRINT USING "##"; curvecalc

PRINT
PRINT "Logged : "
PRINT "Total time : ";
IF timetaken < 60 THEN
        PRINT USING "##.##"; timetaken;
        PRINT " sec."
ELSE
        PRINT USING "###"; INT(timetaken / 60);
        PRINT " min. ";
        PRINT USING "##.#"; timetaken - INT(timetaken / 60) * 60;
        PRINT " sec."
END IF
PRINT "Time per curve : ";
PRINT USING "###.##"; timetaken / curvecalc;
PRINT " sec/curve"
PRINT "Time per point : ";
PRINT USING "###.##"; timetaken / curvecalc / points * 1000 * 100 / perc;
PRINT " millisec/point"

exptime = timetaken * 100 / perc

IF CINT(perc) <> 100 THEN
        PRINT
        PRINT "Expected : "
        PRINT "Total time : ";
        IF exptime < 60 THEN
                PRINT USING "##.##"; exptime;
                PRINT " sec."
        ELSE
                PRINT USING "###"; INT(exptime / 60);
                PRINT " min. ";
                PRINT USING "##.#"; exptime - INT(exptime / 60) * 60;
                PRINT " sec."
        END IF
        PRINT "Time per curve : ";
        PRINT USING "###.##"; exptime / curvecalc;
        PRINT " sec/curve"
END IF

END SUB

SUB title
PRINT "Numerical Function Differentiator and Plotter V4.0"
PRINT "Inception & Programming by Vajrang Parvate": PRINT : PRINT
'                                 ^^^^^^^^^^^^^^^
'                     IF YOU CHANGE THIS, DON'T EVER FORGET ME!!!
'-----------------------------------------------------------------------------
END SUB

