




                 NewsWerthy     (C) 1994 - 1996 William Werth

                 Version 2.10




            I.   INTRODUCTION TO NEWSWERTHY                            2
                1.  WHAT IS NEWSWERTHY?                                2
                2.  SYSTEM REQUIREMENTS                                4
                3.  CONTACTING THE AUTHOR                              4
                4.  REGISTERING NEWSWERTHY                             4
                5.  DISCLAIMER                                         6
                6.  THANKS AND KUDOS                                   6
            II.  QUICK START PROCEDURE                                 6
            III. USING NEWSWERTHY                                      7
                1.  SETTING UP THE HOST (BBS) FOR SOUP PACKETS         8
                2.  DOWNLOADING THE MAIL PACKET FROM THE HOST (BBS)   10
                3.  UPLOADING A REPLY PACKET TO THE HOST (BBS)        10
                4.  READING THE MESSAGES IN THE MAIL PACKET           10
                5.  SEARCHING MESSAGES IN THE MAIL PACKET             12
                6.  REPLYING TO A MESSAGE                             13
                7.  POSTING A NEW MESSAGE TO A NEWSGROUP              15
                8.  SENDING AN EMAIL MESSAGE                          16
                9.  REVIEWING & MODIFYING REPLIES OR STORED MESSAGES  16
                10. SAVING MESSAGES                                   16
                11. PRINTING MESSAGES                                 17
                12. UQWK COMMANDS                                     17
                13. USING THE KEYBOARD                                18
                14. USING THE MOUSE                                   20
                15. SETUP                                             20
                        DIRECTORIES & UTILITIES                       21
                        MESSAGE OPTIONS                               22
                        DATABASING OPTIONS                            24
                        PRINTER OPTIONS                               25
                        COLORS SETUP                                  25
                16. VIEWING A FILE                                    25
                17. ABOUT NEWSWERTHY                                  26
            IV.  EXAMPLE USES OF NEWSWERTHY                           27
                1.  SEVERAL PACKETS, ONE REPLY PACKET                 27
                2.  WITH PGP                                          27
                3.  WITH LAPTOPS                                      28
                4.  WITH TAGLINE MANAGERS                             28
                5.  WITH MULTIPLE USERS                               29
                6.  READING THE DATABASE WITH THE NUMBER KEYPAD       29
            V.   GLOSSARY                                             30
            VI.  INDEX                                                32




                                          1


            I.   INTRODUCTION TO NEWSWERTHY
            ___________________________________________________________

            This section is an introduction to NewsWerthy and
            registration requirements.


            1.  WHAT IS NEWSWERTHY?
            ___________________________________________________________

            NewsWerthy is an off-line message reader for the SOUP
            format. This is the format generated by uqwk, when used with
            the +L parameter (but not the only way to make a SOUP
            packet).

            NewsWerthy can be used as a packet reader, or as a data-
            basing reader. With NewsWerthy you can read one packet, or
            messages from several packets at a time. Your position in
            the packet and which messages have been read are saved, so
            you can return to where you left off, and continue reading
            messages. If you want to keep any messages, they can be
            saved to folders. In databasing mode you have several
            options as to how messages are expired, otherwise in packet
            mode they are deleted when a new packet is opened.

            NewsWerthy has a user interface with familiar pull down
            menus and context sensitive help that can be accessed easily
            with the keyboard or mouse. It has all the features you'll
            need to read, reply and save messages for later reference.
            It has several options for reading mail, depending on your
            preferences. You can easily read all messages, or just a few
            by using its search capabilities.


            Features:

            * A database of all your messages or just the current
              packets messages can be read.

            * Shell to DOS anywhere (yes anywhere with Ctrl-S).

            * An address book for email addresses with an alias for each
              entry.

            * Edit messages using your favorite editor.

            * Print all or part of a message.

            * Replies to a message in a newsgroup can be sent by email
              or to the newsgroup.

                                          2


            * Replies can be re-sent if auto-saved.

            * Messages can be forwarded using email.

            * Automatically appends a signature file to your replies.

            * Save messages to a folder using a pick list of names up to
              80 characters long (no DOS filename limit).

            * Append or overwrite all or part of a message to a text
            file.

            * Delete unwanted messages.

            * Search for a message using any combination of 1) Key words
              in the message text 2) Subject 3) From.

            * Uses "smart searching" (remembers what you last searched
              for in a newsgroup).

            * All setup is integrated into the program, including color
              selection. No need to use a text editor on the setup file.

            * Configurable to your message reading style.

            * Context sensitive help is displayed when F1 is pressed.

            * Pull down menus, with a hint line on the bottom of the
              screen, for the usage of each menu item.

            * Supports monochrome, B/W and color monitors.

            * Quoted text in messages is color highlighted.

            * Marks read, saved or killed messages.

            * Sort messages on date, author, subject or no sort.

            * Remembers what newsgroup and what message you were last
              reading, to easily pick up where you left off reading.

            * RFC-822, RFC-1036 & SOUP compliant.

            * Will optionally word wrap the displayed message.

            * Sorts mailing lists into their own separate "news" group.

            * Files can be attached to replies using UUEncode, XXEncode
              or Base64.


                                          3


            * Attached files in a message, in any of the above three
              formats can be saved to a text file.

            * Different setups can be used for each user (see section IV
              of manual).

            * Messages can be marked for later deleting, saving or
              printing.

            * Messages can be viewed with your own text file viewer, if
              you like.


            2.  SYSTEM REQUIREMENTS
            ___________________________________________________________

            An IBM PC or compatible with DOS 3.0 or higher. The monitor
            can be monochrome, hercules or color. A hard drive with
            several megabytes free. An 80286 or better to use the
            protected mode version, plus at least 570K of XMS memory.


            3.  CONTACTING THE AUTHOR
            ___________________________________________________________

            If you have any questions, comments or need technical
            support, feel free to contact me in one of the following
            ways:

            1) By email at billw@eskimo.com

            2) I monitor the usenet newsgroup alt.usenet.offline-reader.

            3) By mail at the address listed for registration.

            4) In person at (206) 258-1755, evenings 5pm to 10pm Pacific
            time during the weekdays or 8am - 5pm weekends.


            4.  REGISTERING NEWSWERTHY
            ____________________________________________________________

            Why register? Registering removes the opening unregistered
            message. The helpful (for new users) but somewhat annoying
            "Are you sure you want to edit the message selected?"
            message, plus several others are also disabled. Registered
            users who provide an email address will receive notice of
            any significant updates.

            There is also a 30 day evaluation period on the databasing
            feature. After 30 days and 15 uses you will be asked to
                                          4


            register. After 60 days and 30 uses, you will only be able
            to read new packets in the packet mode.

            Registered users will be able to use the protected mode
            version of NewsWerthy. It is the same as the shareware
            version, except that it requires a '286 or better CPU and
            uses virtual memory. This allows very large messages and
            newsgroups to be read, since it is not limited to
            conventional memory.

            Also if you find this program useful, you will surely want
            to see more features added. This can only happen if I
            receive your support. Many hours of work have gone into
            making this program, so send in the registration form and
            you will receive a registration number. Your registration
            will also be good on future updates.

            The registration form can be printed by pressing P at the
            opening screen.

            NewsWerthy is released as shareware. You are encouraged to
            make copies and distribute them for others to use. The only
            restriction is that the copies are in their complete and
            unmodified form. A list of all the files is in the
            README.TXT file.

            To continue using NewsWerthy past the evaluation period,
            send $25 US in one of several ways.

            1) To the address below:

               William Werth
               11119 Woodinville Dr. #116
               Bothell, Wa 98011

            If you don't use the registration form, be sure and include
            your email address and the name to register NewsWerthy
            under, so I can send you a registration code number. If
            you'd like me to send your registration code by snail mail,
            include your mailing address.

            2) You can register NewsWerthy with a credit card by
            contacting RegNet at:

                http://www.xmission.com/~wintrnx/regnet/~103p.htm
                Or by phone at 1-800-999-2734 for U.S. callers, or
                801-355-5110 for international callers.




                                          5


            5.  DISCLAIMER
            ___________________________________________________________

            This program has been thoroughly tested but due to the
            complex nature of today's hardware, the author, William
            Werth, makes no warranty of any kind, express or implied,
            including without limitation, any warranties of
            merchantability and/or fitness for a particular purpose.
            William Werth will not be liable for any damages, whether
            direct, indirect, special or consequential arising from
            failure of this program to operate in the manner desired by
            the user. William Werth shall not be liable for any damage
            to data or property which may be caused directly or
            indirectly by the use of this program.


            6.  THANKS AND KUDOS
            ___________________________________________________________

            I want to thank my beta testers for making NewsWerthy what
            it is.

            Arnie, who named NewsWerthy.

            Also my girlfriend Juanita, who showed great patience while
            I worked many hours on NewsWerthy.

            Rachel Polanskis, who gave me the motivation to add
            attaching files.



            II.  QUICK START PROCEDURE
            ___________________________________________________________

            Be sure to read the README.TXT file for installation
            instructions. If you don't use the install batch file
            (INSTALL.BAT), then you'll want to run NWERTHY.EXE after
            manually installing NewsWerthy.

            NewsWerthy is easy to use and takes a minimum of set-up. You
            can always hit the F1 key to get help, or wing it, since you
            will be warned of any non-recoverable actions. Most commands
            are executed with a single key press indicated by the
            highlighted letter in the menu or on the status line. If no
            previous setup exists, the directory setup dialog will
            appear, otherwise Alt-S will get you to the setup menu. If
            you are unsure of any directories, you can press Ctrl-S to
            shell to DOS. You will probably be able to use most of the
            defaults, but will need to set up the following:

                                          6


            1. Download Directory - Enter the drive and directory where
                 the mail packet is located. A filename like ESKIMO.ZIP
                 or ESKIMO*.ZIP can be included too. Including the
                 filename in the registered version causes the file
                 dialog to be skipped, and instead goes directly to
                 unzipping the mail packet.

            2. Upload Directory - Press Tab to move to this field. Enter
                 the drive and directory where your communication
                 program expects to find files to upload. The reply
                 packet will be placed here and will be named similar to
                 the mail packet, except the extension will be .REP. I
                 named my mail packet ESKIMO.ZIP which then translates
                 to ESKIMO.REP for the reply packet.

                 Or instead, include the full pathname of the reply
                 packet to always create the same name for the reply
                 packet, no matter what the name of the mail packet.

            Press Enter after any changes are made to save them or
            Cancel to ignore them.

            If you already have a SOUP packet (or want to read the
            WELCOME.PKT), press F3, select it, then select open. Select
            Yes when prompted to read it, and use the normal cursor
            control keys, plus the space bar to view the messages.

            The manual can be printed by entering from the DOS prompt:

               COPY NWERTHY.MAN PRN  (press return)

            The manual is formatted for 51 lines per page with a top
            margin of .4 inches. The margins are 1.25 inches for 60
            characters per line. This should make it printable to single
            or continuous sheets with no changes needed.



            III. USING NEWSWERTHY
            ___________________________________________________________

            NewsWerthy contains plenty of on-line, context sensitive
            help (press F1) and is so easy to use you'll probably never
            need to read most of this. But if you are new to off-line
            mail reading, get stuck or just like reading manuals then
            here is what you'll need to know.





                                          7


            1.  SETTING UP THE HOST (BBS) FOR SOUP PACKETS
            ___________________________________________________________

            NewsWerthy is designed to work with the SOUP format, which
            generally means using uqwk. Uqwk generates an AREAS file and
            .MSG files containing the messages from the newsgroups
            you're subscribed to, plus your email.

            First verify uqwk is available on your BBS. Don't enter uqwk
            to test this, instead enter man uqwk, and while you're at it
            you might want to at least read the first paragraph or two.
            If uqwk is not available, contact your system operator on
            how to generate SOUP packets.

            To automate using uqwk you'll want to use something like the
            following script on your host system. This script file is
            included in the distribution, but here is a copy for your
            reference. All lines that start with #, except the first are
            optional.

            #!/bin/sh
            # Usage: soup [ upload ]

            # Process reply packet if requested
            if [ $# -gt 0 ]
            then
              if [ $1 = "upload" ]
              then
                echo start your upload of yourbbs.rep now!
                rz
                unzip -U yourbbs.rep
                uqwk -m -n +L -RREPLIES
                rm yourbbs.rep
              fi
            fi

            # Check for an existing packet
            if [ -f "yourbbs.zip" ]
            then
              echo Warning - found an unsent yourbbs.zip file!
              sz -u yourbbs.zip
            fi

            # Copy your newsgroups file to a backup directory as a
            # precaution
            cp .newsrc backup

            # Collect your unread mail and news in SOUP format
            # change -B8000 to -B0 for no limit on packet size
            uqwk +m +n -z +L -B8000

                                          8


            # Zip it up, and delete files if successful
            zip -m yourbbs AREAS *.MSG

            # Download it to your PC
            sz -u yourbbs.zip

            The above file (soup) must be first transferred to your BBS
            using the UNIX upload command rz at the UNIX prompt.

            Now you'll need to make the script executable and also make
            the backup directory. To do this, enter the following at the
            UNIX command prompt:
                chmod u+x soup
                mkdir backup

            You may also want to change all "yourbbs" entries to the
            name of your BBS.

            If you have any problems getting the above to work, what
            follows is further explanation of the script to help in
            locating the trouble. If a particular command works
            differently on your system, check the manual, for example
            "man zip". All lines starting in #, except the first are
            comments.

            Here are the commands used for replies:

            rz - Starts the upload of the YOURBBS.REP using the zmodem
            protocol. If your communication package doesn't support
            zmodem, change this to something like rx.

            unzip -U yourbbs.rep - The -U switch forces the files in the
            archive to be uncompressed to uppercase, this may the
            default, but is included just to be sure.

            uqwk -m -n +L -RREPLIES - The +L indicates SOUP format, the
            -R contains the name of the file which points to the
            messages files (R0.MSG, etc.). The -m and -n ensure no mail
            or news is lost.

            rm yourbbs.rep - Deletes the reply packet.

            Here are the commands used for collecting news and mail:

            uqwk +m +n -z +L -B8000 - The +m and +n, indicate include
            mail and news. The -z is there just in case someone has set
            the environment variable for Zipnews format on your host (-z
            turns it off).

            zip -m yourbbs AREAS *.MSG - The -m deletes the AREAS and
            *.MSG files once successfully compressed into the packet.
                                          9



            sz -u yourbbs.zip - The -u unlinks (deletes) the packet once
            successfully sent.


            2.  DOWNLOADING THE MAIL PACKET FROM THE HOST (BBS)
            ___________________________________________________________

            Log onto your BBS and go to a UNIX command prompt. Then run
            the above SOUP UNIX script from the command line like so:
                soup
            If your communications program has auto zmodem disabled you
            will need to start zmodem manually. The commands from the
            script can also be entered one at a time to get the same
            effect (skip the if then lines).


            3.  UPLOADING A REPLY PACKET TO THE HOST (BBS)
            ___________________________________________________________

            Log onto your BBS and go to a UNIX command prompt. Then run
            the above UNIX script from the command line like so:
                soup upload

            If for some reason you encounter an error and your news is
            lost before you get a chance to read it, simply enter the
            following at the UNIX command prompt, to restore your news:
                cp backup\.newsrc .
            Then repeat the download process. Although this restores the
            news pointers, any email that was collected, will be lost.

            NewsWerthy will prompt you about deleting the reply packet,
            when you download and open a new packet. If you want to
            create more replies, without adding them to existing
            replies, you need to delete the reply packet.


            4.  READING THE MESSAGES IN THE MAIL PACKET
            ___________________________________________________________

            After hitting a random function key (if unregistered), you
            have two ways to get started. You can use either the menus
            at the top or the function keys at the bottom of the screen.
            Besides the initial setup or odd command, the function keys
            will be almost all you'll ever need.

            To prepare a packet for reading, select New Packet (F3).
            Select the packet using the dialog and press Enter to
            uncompress your mail and generate the necessary indexes. If
            you are a registered user, this step can also be done from

                                         10


            the command line by using the /p switch (pre-process packet)
            like so:
              NWERTHY /P YOURBBS.ZIP

            Next, to read your news and mail, select Read News (F4).
            Pressing the space bar will allow you to read your mail
            sequentially from start to finish. If you read most
            messages, you may want to select the "Esc to Index" option
            from the Message Options dialog under the setup menu.
            Otherwise use the "Standard" option and read the section on
            USING THE KEYBOARD to select and read those you're
            interested in.

            If you press the space bar to read a newsgroup, only unread
            messages are shown. To see read, plus killed messages, press
            the Enter key to read a newsgroup.

            NewsWerthy automatically puts mail from mailing lists into
            separate "news" groups if you have this option enabled. It
            does this by reading the message headers To:, Cc:, Sender:
            and Originator lines. This may not work 100% consistently,
            because mailing lists aren't 100% consistent. To help
            NewsWerthy be much more accurate in separating your personal
            mail, be sure to enter your email address in the Reply-To
            picklist (the Cc: line is checked from this). To make the
            mailing lists more accurate, add it's email address to the
            address book and check the mailing list box. Your email is
            also put into a group called "all", if you prefer to read it
            all together. If you are using NewsWerthy in packet mode,
            email will only be separated if the email group is the last
            file in the packet.

            One way to limit the messages you read is to generate kill
            files by selecting Kill while reading the message. This
            brings up a dialog that lets you choose between killing all
            messages that match that subject or all messages from that
            author. Wildcards can be used and are explained in the on-
            line help. In databasing mode, entries made from the message
            are for each newsgroup. In packet mode, entries are to a
            global kill file for all newsgroups. The global kill file is
            also used for databasing mode, but can only be accessed
            through the List menu item.

            The message list defaults to a sort on the subject. This can
            be changed temporarily to sorting on the date, author or no
            sort as an aid in finding a message. A sort on none will
            display the messages in the order they were saved to the
            file, with the newest first. To change the sort, select Sort
            Messages from the status line of the messages list.


                                         11


            Messages are flagged read after you view them. This is
            indicated by "READ" in the upper right of the message and an
            asterisk at the beginning of each message list entry. Read
            messages will be skipped if you're using the space bar,
            otherwise use the Enter key to read messages marked with an
            asterisk. The - and + keys can be used to go to a read
            message. To mark all messages as read or unread in a
            newsgroup, select the appropriate command from the
            Newsgroups list (the first list displayed after selecting
            Read Mail).

            If you come across a message that looks like gibberish, try
            pressing Alt-R, to ROT-13, the message. Hitting ALT-R twice
            restores a message back to its original state.

            If error messages occur while reading messages, the index or
            book mark files may have become corrupt or deleted. Select
            Restore Indexes from the News Incoming menu to generate new
            indexes (*.IDX) and book marks (*.BKM) from the message
            (*.MSG) files. You'll need to enter the filename of the
            packet if not present in the input line that appears. The
            name and extension is all that is required.

            If in databasing mode, you can remove read, all or expired
            messages. "Select Expire Messages in Database" from the News
            Incoming menu. Then select one of the above. These messages
            will then be deleted from the database.


            5.  SEARCHING MESSAGES IN THE MAIL PACKET
            ___________________________________________________________

            You can select the messages you read by selecting Find from
            the message list. This brings up a dialog that lets you
            search messages three ways. A search can find any matches in
            the text, subject or author of the message. These can be
            used separately or in combination, with the messages that
            match appearing in a message list. More than one phrase can
            be entered on an input line, by separating them with
            semicolons (;). All searches are case insensitive (matches
            either upper or lower case).

            When you use the find dialog, you may notice that some of
            the input fields are already filled in. This is what I call
            "smart searching". If you usually search a newsgroup for the
            same text, NewsWerthy will remember this, and fill in the
            field for you. In order for this to work, you need to do two
            things: 1) Add the search string to the appropriate picklist
            (open the picklist by pressing the down arrow key, then
            press "Alt-A" to add it). 2) Select the search string from
            the picklist and press Enter to start your search. If there
                                         12


            is no previous search string for the newsgroup, NewsWerthy
            will fill in the fields with whatever was used last.

            Messages can be searched on the text portion of the message.
            As an example, if you enter "10 speed;15 speed" (don't enter
            quotes) then any message with either the phrase "10 speed"
            or "15 speed" in it or in the subject will appear in the
            Matches in message list. When you read the messages, the
            line where the match occurred will be highlighted (only the
            first match is highlighted).

            Messages can be searched on the message Subject or From
            line. Messages that match anywhere in these lines will
            appear in the Matches in message list. If a message doesn't
            contain a From line, the To or Newsgroups line will be
            searched instead. Searching the To line, is useful for
            finding a messages you have sent, that has been saved in the
            auto-saved.replies folder.

            Text in a single message can be searched by pressing "X" for
            Text search, from the message viewing screen. This operates
            similar to the Find command. The line that contains a match
            is highlighted in the center of the screen. This is useful
            for finding something in the middle of a long message such
            as a FAQ. Additional occurrences of the search phrase can be
            found by hitting the "+" key.


            6.  REPLYING TO A MESSAGE
            ___________________________________________________________

            While reading a message, select Reply, which will bring up a
            dialog. Select Mail to send a private message, News to reply
            in the newsgroup, Forward to send the message by email to a
            friend or Mailing List (if an email message) to send a
            message to a mailing list (the email address in the To:
            line). Select Re-send Mail only from the auto-saved.replies
            folder to add that message to the reply packet. The default
            is to quote the message for all of the above, but Don't
            Quote can be selected to start from scratch. To send a new
            message use Post New Msg from the message list, or Send News
            or Send Mail from the Mail Outgoing menu, not the Don't
            Quote option.

            When a message is forwarded, a dialog lets you indicate who
            you want to send it to. A few extra header lines are added
            to indicate who the message was originally from. It is then
            quoted and loaded into your editor. This gives you a chance
            to delete a portion or add a note for the recipient.


                                         13


            Read RFC1036 for detailed information on the message
            headers, otherwise read on. Only the Newsgroups and Subject
            are required, and should be entered in the Message Reply
            Options dialog as follows:

            To - This is the email address of the recipient of the email
            message. An alias from the address book can be entered here.
            An entry from the address book can be selected by pressing
            the down arrow key.

            Each alias in the address book must be unique and not
            contain an "@" character, but can contain spaces. The email
            address is substituted for the alias when the message is
            sent. Multiple email addresses and/or aliases can be entered
            on the email address line. The only limits being that not
            more than 255 characters can be entered and it can't expand
            to more than 1023 characters. Separate each address/alias
            with a single comma and a space (, ).

            Cc - This is used to send a Carbon Copy to 1 or more email
            recipients. The easiest way to send email to group of people
            is as follows: Define an alias in the address book that
            expands to all the email addresses in the group. Then enter
            just the alias on this line.

            Bcc - Virtually the same as Cc, except that this line may
            not appear in the header of each of the recipients messages.

            Newsgroups - The Newsgroup is filled in for you
            automatically. To post to a different newsgroup, select one
            from the pick list by pressing the down arrow key or enter
            it in. To cross-post the message to several newsgroups,
            separate each with a comma (,) and no spaces. Replying to a
            cross-posted message will maintain the original distribution
            unless you edit this line.

            Subject - NewsWerthy will add Re: to the current subject for
            you.

            Followup-To - This is used to indicate a different newsgroup
            for replies to be sent to.

            Keywords - A few well selected keywords identifying the
            message can be entered.

            Summary - A brief summary of the message.

            Reply-To - To indicate an email address to send replies to.

            Organization - To indicate the organization you belong to.

                                         14


            Extra Header - To add any headers lines not listed above.
            You'll need to enter the name of the header ending with a
            colon (:), a space, and the contents of the header line.
            When adding a non-standard header line, start it with X-.

            To attach a file to your message select Attach File (Alt-F).
            Then select which encoding method you want to use.
            UUEncoding is probably the most universal format, but
            XXEncoding is more likely to make it to the recipient of the
            message un-altered. Choose Base64 if the recipient of the
            message uses a reader that supports MIME. Large files will
            be split into multiple messages of 850 lines each or about
            38k. There is a limit of 99 messages per attached file
            (about a 4 meg file). I don't recommend adding a signature
            to your message when using this option. NewsWerthy handles
            this fine, but other decoders may not be able to re-create
            the file, unless it is removed.

            The editor you've entered in the Directories Setup is used
            to enter the message. Save the file as a text (ASCII) file
            and exit from your editor once you're done. Signatures can
            automatically be appended to your messages. Simply use your
            editor to enter into a file the text you want appended to
            the end of each reply. Name this file NWERTHY.SIG and store
            it in the work directory.

            When you're finished reading your messages, any replies
            you've entered are compressed and stored in the Upload
            Directory. If you've selected Auto-Save Reply the message is
            also stored in the auto-saved.replies folder.


            7.  POSTING A NEW MESSAGE TO A NEWSGROUP
            ___________________________________________________________

            Posting a new message is nearly the same as replying to a
            message. The main differences are as follows:

            To post a message to a newsgroup, select Post New Msg from
            the messages list. You'll need to enter a subject. Choose a
            descriptive topic, something like Help me, isn't likely to
            generate a lot of interest.

            You can also post a new message to a newsgroup by selecting
            Send News from the Mail Outgoing menu.






                                         15


            8.  SENDING AN EMAIL MESSAGE
            ___________________________________________________________

            To enter an email message, select Send Mail (F7) from the
            menu screen, enter an email address to send the message to
            (or pick one from the picklist) and proceed the same as for
            Post New Msg.


            9.  REVIEWING & MODIFYING REPLIES OR STORED MESSAGES
            ___________________________________________________________

            Select Review Replies (F8) from the menu screen to read your
            replies. Select Read Stored (F6) from the menu screen to
            read messages saved to folders.

            While at the message list or message viewing screen, a
            message can be deleted or edited. A reply can also be edited
            by pressing R (Reply). When editing a reply, be careful what
            changes you make to the message header. A temporary file
            with an odd name ending in something like .AAA is created to
            edit the message. Select save and exit from your editor when
            done.

            Once you delete a message, its gone forever, so make backups
            if you can't afford to make mistakes.

            Replying to a reply, allows you to change any of the headers
            using the same dialog that you originally created it with.
            There are some restrictions though. The To line will be
            truncated to 255 characters, but can be re-entered, if this
            happens. The Extra Header line will only be automatically
            added to the dialog if it is present in the picklist. If you
            have added any header lines by manually editing the message,
            they will be lost.


            10. SAVING MESSAGES
            ___________________________________________________________

            Selecting Save while viewing a message brings up a dialog.
            The default is to save to a SOUP format (binary mail)
            folder. If the current newsgroup name matches one in the
            newsgroup pick list, it is displayed, otherwise whatever was
            entered previously is used. The default can be used or one
            can be selected from the pick list.

            If you'd rather append or overwrite all or part of the
            message to a DOS text file, select Save to Text File. Use
            the dialog to select or enter a DOS filename for saving.
            Select the OK button to append or the Replace button to
                                         16


            overwrite the selected file. To save only a portion of a
            message to a DOS text file, highlight it using Top  (mark
            top) and Bot (mark bottom), then save as described above.
            You can press Alt-T from the message to go directly to Save
            to File dialog.

            If the message contains an attached file, it can be saved to
            a file by selecting Save Attached File (Alt-A). The dialog
            that then appears works the same as the one to save to a
            text file. NewsWerthy supports the 3 most popular formats
            for DOS PC's, which are UUEncode, XXEncode and Base64.
            Base64 is part of MIME, and the only support for MIME found
            in NewsWerthy. If the attached file spans multiple messages,
            simply save them in order, appending them to the same file,
            to recreate the binary file. You can also mark all the
            portions of a file attachment using the Mark dialog, then
            save them as above. This will only work if the subject
            contains 1 of 2 or 1/2 in the first message, for a two part
            attachment, then 2 of 2 or 2/2 for the second part.

            To save an entire folder to a text file, select Delete from
            the newsgroups list. You will be prompted to save it to a
            file before deleting all the messages. You also have the
            option of just deleting the messages, and leaving the
            newsgroup in place.

            You can also save an entire folder (or newsgroup) by marking
            all the messages (use mark dialog), then selecting Save.

            11. PRINTING MESSAGES
            ___________________________________________________________

            Select print, to print the current message to your printer.
            If your printer is off-line, you'll be prompted until you
            either turn it on or select cancel. To print only a portion
            of a message, highlight it using Mark Top and Bottom, then
            select print.

            If you want the last page printed to eject, select this
            option from the Setup menu, in the Printer Options dialog.

            To print a "short" header (only the Date, From and Subject),
            select this options from the print dialog in the setup menu.


            12. UQWK COMMANDS
            ___________________________________________________________

            Uqwk provides commands to unsubscribe, subscribe, catchup or
            list newsgroups. A shell command can also be run, with the

                                         17


            output from standard output mailed back to you. Normally you
            would enter an email message to uqwk.

            To simplify sending commands to uqwk, select Uqwk Cmds from
            the newsgroup list. Use this dialog as many times as you
            like. Some other readers are limited to only one message to
            uqwk. NewsWerthy avoids this limitation by saving your
            commands and then entering them in one message, and placing
            this at the end of the reply files.

            The current newsgroup is saved one key away in the Uqwk
            dialog. To unsubscribe to a newsgroup select Uqwk Cmds,
            Press down arrow and press Enter twice. That's all there is
            to it.


            13. USING THE KEYBOARD
            ___________________________________________________________

            The following keys can be used in dialog boxes.

            Esc        - Exit this screen and go back to the previous
                         screen (exits program when menu is displayed).
                         Cancels any changes made.

            Enter,     - Enters any changes made or chooses the selected
                         button, same as selecting a button with the
                         mouse.

            Tab        - Go to next option

            Shift-Tab  - Go to previous option.

            Down arrow - Opens up a history or pick list if available.

            Hot Key    - Press the letter that is highlighted of the
                         item desired. If the cursor is presently in an
                         input box, press and hold the Alt key, then the
                         highlighted letter.

            Supports some word star control key combinations one of
            which is:

            Ctrl-y     - Delete line.


            The following keys are used when viewing a message or list.

            Esc, Del       - Displays the message list if viewing a
                             message, or the newsgroup list if viewing
                             the messages list.
                                         18



            Enter          - Go to next message unread message or
                             selects the message from a list.

            Tab            - Go to next subject.

            -              - Go back one message.

            +              - Go forward one message (even if read).

            <space>, Ins   - Next page or next unread message if at end
                             of message.

            Page Down      - Next page, stops at the end of the message.

            Page Up        - Previous page, stops at the first line of
                             the message header if reading a message.

            Ctrl-Page Down - Goes to the last line in the message or
                             list.

            Ctrl-Page Up   - Goes to the first line in the message.
                             header or list.

            Home           - Goes to the start of the message or the
                             first line displayed in a list (not
                             necessarily the first line in the list).

            End            - Goes to the end of the message or the last
                             line displayed in a list (not necessarily
                             the end of the list).

            Arrows         - Arrows scroll text up and down, right and
                             left.

            Ctrl-arrows    - Right and left arrows in combination with
                             the control key, goes to the end of the
                             line or the start of the line.

            Note that by turning off the Num Lock on your keyboard,
            messages can be read using only the keys on the keypad. The
            Ins key is used to go to the next message instead of the
            space bar, and the Del key instead of the Esc key using this
            method.

            Pick lists are used to save information on disk, such as
            newsgroup names, email addresses, search phrases and such.
            They can be accessed by selecting an input line, then
            pressing the down arrow. If its a pick list (instead of a
            history list), you'll see several commands on the hint line.
            These are as follows:
                                         19



            Add      - Press Alt-A to add an item to the pick list.
                       Duplicates aren't allowed.

            Edit     - Press Alt-E to Edit an item in the pick list.

            Delete   - Press Alt-D to delete an item from the pick list.


             14. USING THE MOUSE
            ___________________________________________________________

            I won't go into too much detail, but here is how to use the
            mouse with NewsWerthy:

            The message or a list can be scrolled by clicking on the up
            or down arrow on the scroll bar to the right of the window.
            Hold the mouse button down while pointing at the position
            icon and slide it up or down to change position in the
            window. Clicking above or below the position icon, scrolls
            up or down a page at a time.

            Windows can be closed by clicking on the close icon in the
            upper left corner.

            Buttons and other objects are selected by a single click on
            them with the mouse pointer.

            An item in a list may open a new window if double-clicked.
            For example, in the message list, double-click on a subject
            to read that message. Double-clicking has the same effect as
            pressing the Enter key.

            Pressing the right mouse button with the pointer in the
            center portion of the window, has the same effect as
            pressing the Esc key.

            Double-clicking with the left mouse button on the message
            text is the same as pressing the Enter key.

            Clicking on any item in the status line (the bottom line)
            has the same effect as pressing the hot key.


             15. SETUP
            ___________________________________________________________

            Should you need to verify or create directories, you can
            press Ctrl-S for a Dos Shell.

            Alt-S will get you to the setup menu from the menu screen.
                                         20



            The Directories & Utilities dialog contains the following:

            1. Download Directory - Enter the drive and directory where
                 the mail packet is located. A filename like ESKIMO.ZIP
                 or ESKIMO*.ZIP can be included too. Including the
                 filename in the registered version causes the file
                 dialog to be skipped, and instead goes directly to
                 unzipping the mail packet.

            2. Upload Directory - Enter the drive and directory where
                 your communication program expects to find files to
                 upload. The reply packet will be placed here and will
                 be named similar to the mail packet, except the
                 extension will be .REP. I named my mail packet
                 ESKIMO.ZIP which then translates to ESKIMO.REP for the
                 reply packet.

                 Or instead, include the full pathname of the reply
                 packet to always create the same name for the reply
                 packet, no matter what the name of the mail packet.

            3. Work Directory - Make this a subdirectory of where
                 NWERTHY.EXE is stored. Something like C:\NWERTHY\ESKIMO
                 will work fine. While reading messages, files in this
                 directory are read, so be sure to put this one on the
                 hard drive. Don't use a ram drive, if you want
                 NewsWerthy to remember your last session. This
                 directory will be created if it doesn't already exist.

            3. Folders Directory - Make this a subdirectory of where
                 NWERTHY.EXE is stored. Something like
                 C:\NWERTHY\FOLDERS.

            4. Saved Directory - Make this a subdirectory of where
                 NWERTHY.EXE is stored. Something like C:\NWERTHY\SAVED.

            5. Editor - The editor is only needed if you plan to edit or
                 reply to messages. Enter the drive and directory where
                 your editor can be found. Select an editor that can
                 handle lines longer than 80 characters. Also error
                 handling works best if the editor returns an error
                 level other than 0 on failure. No matter what editor
                 you choose, make sure you always save as a text (ASCII)
                 file.

            6. Screen Saver - A screen saver can be made to activate
                 after the number of minutes of idle time you enter in
                 the next entry. You need to enter the full pathname,
                 unless the screen saver is found on your path. Some
                 screen savers are a little brain dead, and won't be
                                         21


                 able to find some of the files they need. A work around
                 so that you can still use it, is to enter the name of a
                 batch file here, that contains something like the
                 following:

                      c:
                      cd \ssdir
                      scrsaver.exe

                 By changing to its directory first, it is able to find
                 its support files. A number of VGA screen savers can be
                 found at any SimTel archive in the msdos/screen
                 directory. One of the best is Dazzle (dazz151c.zip),
                 and one that is simple, but requires the above batch
                 file is savior (savior.zip).

            7. Ext. Viewer - If you want to be able to press Alt-V to
            view a message with a text file viewer, enter the drive and
            directory where it is located.

            The Message Options dialog contains the following:

            1. News Quote or Mail Quote Format - The first line of the
                 quoted text can contain information from the quoted
                 message's header, such as the name of the author or the
                 message Id. The newsgroup name can also be included.
                 The following variables can be used:

                 %A  Address (Email)
                 %D  Date
                 %F  Full address
                 %G  Groupname
                 %M  Message Id
                 %N  Name of author

                 Examples:
                   On %D in %G you wrote:
                   In %M, %F wrote:

                 The above would expand to:

                 On 26 Aug 1994 08:30:00 -0800 in alt.usenet.offline-
                 reader you wrote:

                 In <2megq8$452@agate.berkley.edu>, William Werth
                 (billw@eskimo.com) wrote:

                 Note: %M is not present in an email message

            2. Quoting Characters(s) - When replying to a message, the
                 text of the message can be quoted. Up to two characters
                                         22


                 can be added to the beginning of each quoted line. To
                 add a space use the underscore (_).

                 For example ">_" would add a ">" character and a space
                 at the start of each quoted line.

            3. Word Wrap - Select this option to avoid having to scroll
                 horizontally, to read lines longer then 78 characters.
                 They will wrap around to the next line instead. This
                 also will expand tabs to 8 spaces instead of one space.
                 This option can be toggled by pressing Alt-W while
                 reading a message.

            4. Quote with Initials - When replying to a message, the
                 text of the message can be quoted. In addition to the
                 two characters that can be added to the beginning of
                 each quoted line, the authors initials can be added.

            5. Increment Packet Name - Select this option to cause the
                 packet to be renamed with a 1 at the end. Up to 9
                 packets can be saved this way (1 - 9 at end of
                 filename).

            6. Hide Read Newsgroups - Select this option if you don't
                 want newsgroups with 0 unread messages to show in the
                 newsgroup list.

            7. Separate Mailing Lists - Select this option if you want
                 messages in mailing lists to be put into their own
                 "newsgroup". See "Reading the Messages in the Mail
                 Packet" for more details.

            8. Message Reading Style - There are two ways to read
                 messages. The first "Standard" displays a message, then
                 returns to the message list, where you can select the
                 next message to view. You'll probably prefer this if
                 you are reading only a few of the messages. The second
                 "Esc to Index" displays a message, then goes to the
                 next unread message. Esc must be pressed to see the
                 message list. You'll probably prefer this if you are
                 reading most of the messages.

            9. Message Threading Style - Message subjects (along with
                 number of lines and the author) are displayed in a
                 selection list. There are two ways to sort the subject
                 and three ways to display it.

                 The first sorting method puts all subjects starting
                 with "Re:" with other messages starting with R (this is
                 the "Normal" sort). The second method ignores the
                 "Re:", and sorts on the text that follows, grouping
                                         23


                 replies with the original message (this is the "Don't
                 sort on Re:" sort).

                 The second display method shows subjects without the
                 "Re:" (this is the "Don't display Re:" sort). The third
                 display method displays the subjects without the "Re:",
                 and one ">" appended in front of the subject for each
                 reference, in the References: line (this is the
                 "Indicate thread depth" sort). A maximum of ten ">"
                 will be added. This gives an indication of how long the
                 thread has been active. If it is an email message
                 instead of in a newsgroup, the subject with the "Re:"
                 will be displayed for this last option.

            The Databasing Options dialog contains the following:

            1. Expiration Options - There are four different ways to
                 expire a message. When a new packet is opened, expired
                 messages are deleted. These options can be applied to
                 an individual newsgroup or from the Setup menu to apply
                 to all newsgroups.

                 Expire All Messages - This expires all messages in a
                 newsgroup. If selected from the Setup menu, this puts
                 NewsWerthy in packet mode (non-databasing mode).

                 Expire Old Messages - This expires all messages older
                 than the "Expire Old Messages (Days)" amount.

                 Expire Read Messages - This expires all read messages.

                 Expire Killed Messages - This expires all messages
                 marked killed by matching entries in a kill file.

                 Save Read Messages - This saves read messages to the
                 folder named in "Save Read Messages to Folder" entry.
                 Saved messages are not deleted, and will not be saved,
                 if they have been previously saved.

            2. Expire Old Messages (Days) - Any messages older than this
                 number of days will be expired if "Expire Old Messages"
                 is also selected.

            3. Max. Messages in Newsgroup - When the number of messages
                 in a newsgroup exceeds this amount, the oldest messages
                 will be expired. New messages are then added, so the
                 actual number of messages in a newsgroup can exceed
                 this amount.

            The above options are also displayed at the top of the
            screen for the current newsgroup while reading messages. The
                                         24


            options takes affect if set in the individual newsgroup or
            in the Setup menu for all newsgroups.

            4. Save Read Messages to Folder - Select a folder from the
                 picklist, where you want all read messages to be saved.
                 The messages will only be saved if "Save Read Messages"
                 is also selected. The message is not saved until a new
                 packet is opened.

            The Printer Options dialog contains the following:

            1. Lines to print per page - This is the number of line to
                 print per page for long messages. A printer that prints
                 using continuous feed paper usually prints 66 lines per
                 page. Subtract the number of lines you want for the top
                 and bottom margin and enter that number for this
                 setting. If you prefer no page breaks, set this to 0.

            2. Top Margin - The number of blank lines to print at the
                 top of every page.

            3. Eject Last Page - Select this to have the last page of
                 the message ejected when printed.

            4. Print Short Header - Select this to only print the Date,
                 From and Subject header lines of a message, instead of
                 the entire header.

            The Colors Setup dialog - Colors can be easily changed using
                 the mouse, or through a combination of the tab and
                 arrow keys. Try changing only one color at a time and
                 then see its effect. Some changes effect only one
                 screen, but most change a similar type of object across
                 all screens.  There is also usually more than one place
                 where a color can be changed in the Colors dialog. Of
                 course this is only an option if you have a color
                 monitor.


            16. VIEWING A FILE
            ___________________________________________________________

            To view a text file select View File (F5) from the File
            Menu. Use the dialog to select a file. See USING THE
            KEYBOARD for the keys to use (same as those for a list).






                                         25


            17. ABOUT NEWSWERTHY
            ___________________________________________________________

            The replies to messages you enter are stored in several
            files ending with a .MSG extension. Replies to newsgroups
            are in R0.MSG. Mail replies are in R1.MSG. UQWK commands are
            in R2.MSG. Information for UQWK (or whatever you're using to
            process the SOUP reply packet) about the above files is
            stored in a REPLIES file. These are all zipped up
            automatically and stored in the upload directory under a
            file named the same as the SOUP packet, but ending in a .REP
            extension. If you were to manually create this rep packet
            you would enter: PKZIP YOURBBS.REP R?.MSG REPLIES at the DOS
            prompt. If the reply packet already existed you would add
            the -u switch to the above. Replies are deleted when a new
            packet is uncompressed.

            When an external program is run or the DOS shell is used,
            all but a few kilobytes of the executable is saved
            temporarily to either EMS, XMS or to disk, leaving more
            memory for a DOS shell or an external program like PKZIP. To
            make swapping more efficient (when there is no EMS or XMS
            memory) be sure to have either TEMP or TMP defined in you
            autoexec.bat file. These environmental variables are used
            for the swap file, and also for any temporary files created
            for editing a message.

            You will notice some files in your work directory with the
            extension .PL4, .PL5, .BKM, .DAT, .MSG and .IDX. Those
            ending in .PL4 and .PL5 are used to keep track of the kill
            files. Those ending in .BKM are used to keep track of which
            messages have been read. Those ending in .IDX contain the
            index information. Those ending in .DAT contain information
            about the newsgroups in the AREAS file. Those ending in .MSG
            are created by uqwk. Those ending with .PL and a number
            contain the pick lists.

            Once you've registered NewsWerthy, the file NWERTHY.KEY is
            generated. Don't delete this, else you'll have to enter your
            registration data again.

            You will notice that NewsWerthy doesn't put any .BAK files
            (backup files) in your work directory. This saves space and
            time but the trade-off is that if a disk error should occur
            while deleting or editing a message, the data could become
            corrupt or lost in that file. If you have critical
            information saved, I highly recommend that you make backups
            before editing or deleting any messages.

            The length of messages NewsWerthy can read is limited by the
            amount of free conventional memory in the shareware version.
                                         26


            If a message is too long to fit in memory, you'll be given
            the option to save it to a file.

            In databasing mode, messages aren't actually deleted until
            messages are expired. This normally happens when ever a new
            packet is loaded. This is an optimization, that greatly
            speeds up deleting messages.



            IV.  EXAMPLE USES OF NEWSWERTHY
            ___________________________________________________________

            In this section, I'll give examples of specific applications
            of using NewsWerthy. If you would like to contribute to this
            section, send me email about how you use NewsWerthy.


            1.  SEVERAL PACKETS, ONE REPLY PACKET
            ___________________________________________________________

            You may want to read several packets, generate replies, and
            then upload a single reply packet. There are at least two
            possible ways to do this:

            1) If the news packets all have the same name, just reply no
            when prompted to delete the reply packet, and you can keep
            adding to it.

            2) If the news packets have different names, you will need
            to enter the full pathname of the reply packet for the
            Upload Directory, in the Directories & Utilities setup
            dialog. This will cause all replies to be added to this one
            reply packet.


            2.  WITH PGP
            ___________________________________________________________

            Their are several ways to use PGP (Pretty Good Privacy) with
            NewsWerthy:

            1) I've included a batch file donated by a NewsWerthy user
            (it requires DOS 6.0 or better to run). I've called this
            pgpshell.bat. You'll want to edit it to include the name of
            your editor. In setup enter the pathname of this batch file
            for the Text Editor. When a message is edited the batch file
            will offer you a choice as to what you want done to the
            message. Then it calls your editor and you enter your
            message. And finally, the batch file executes the proper pgp
            commands to perform the desired function. If your not using
                                         27


            PGS shell with PGP, you'll need to modify the batch file
            further.

            Last I checked, PGS was available in the security directory
            of SimTel as pgs099g.zip.

            2) Another option is to use AutoPGP. This is another shell
            for PGP that allows you to add commands (directives) to your
            replies and then modifies them according to those commands.

            AutoPGP is available at SimTel in the off-line directory as
            apgp212.zip. The next version of AutoPGP should be setup to
            automatically configure itself for use with NewsWerthy.


            3.  WITH LAPTOPS
            ___________________________________________________________

            Many laptops have what is called a grey scale display. This
            looks similar to monochrome, but NewsWerthy will detect this
            as a color display. To make NewsWerthy detect this as a
            black & white display, for easier viewing, use DOS's mode
            command.

            There are two ways to do this. Either run the command "mode
            bw80" just before running NewsWerthy, or put this command in
            a batch file along with the command to start NewsWerthy, and
            run the batch file.


            4.  WITH TAGLINE MANAGERS
            ___________________________________________________________

            There are several of these available at Simtel ftp sites.

            One which is easy to use is SigMX 3.30. It lets you pick
            from a list of taglines to use, and you can change the
            signature file by entering its filename. This is found in
            the SimTel/msdos/offline directory as SMX330.ZIP. The error
            checking for finding files it uses is poor, but other than
            that it works good. Make sure you indicate the correct
            location of the signature file. I don't recommend you use
            the same signature file used with NewsWerthy (NWERTHY.SIG).
            You'll want to make one that is formatted with shorter lines
            since SigMX puts the sig on the left side and a tagline on
            the right. You can copy SigMX's files into the same
            directory as NewsWerthy if you like.




                                         28


            5.  WITH MULTIPLE USERS
            ___________________________________________________________

            This feature is currently only available for registered
            users.

            NewsWerthy defaults to saving its setup information in a
            file named NWERTHY.CFG. To use other setups, start
            NewsWerthy like so:

               NWERTHY /S SETUP2.CFG

            If you only want to make a few changes, copy the default
            setup file to the new file, then start NewsWerthy as shown
            above, and make the changes.

            To use NewsWerthy with multiple users, simply create a setup
            file for each, and then each user starts NewsWerthy with the
            appropriate setup file. Make sure that each user has a
            different work directory in their setup information.

            This feature can be used whenever you need to have a
            different setup, such as reading news from several BBS's
            where you'll need a separate work directory for each.


            6.  READING THE DATABASE WITH THE NUMBER KEYPAD
            ___________________________________________________________

            You can read and navigate through a packet with the number
            pad almost exclusively. All the normal navigation keys are
            there, plus I've assigned the function of the space bar to
            the Ins key, the Del key acts like the Esc key, and the *
            key is the same as All Read.

            If you read a lot of messages, you may find this useful to
            avoid strain on your hand.

            The order of the newsgroups can be changed by pressing Shift
            and the up or down arrow key.

            If I only read a newsgroup occasionally, and don't want to
            save any messages, I'll use the "Expire All Messages"
            expiration option. When I'm done reading messages in the
            group I'll press Del to exit from it.

            If I want to save old messages, but don't read all the
            messages in the newsgroup, I'll use the "Expire Old
            Messages" expiration option. When I'm done reading messages
            in the group I'll press * to exit from it, marking all
            messages as read.
                                         29



            If I want to be sure to read all messages in a newsgroup,
            but don't want to save them once read, I'll use the "Expire
            Read Messages" expiration option. When I'm done reading
            messages in the group I'll press Del to exit from it.

            If I'm reading my personal mail, I'll use the "Save Read
            Messages" expiration option. This way I'll save all messages
            sent to me. If there is a junk letter to me, I'll delete it
            so it won't be saved to a folder. If I want to save it in a
            different folder, I'll save it after reading it, so it won't
            be saved to the folder setup in the Databasing Options
            dialog.



            V.   GLOSSARY
            ___________________________________________________________

            ASCII text file - A file made up of only ASCII text
                 characters that represent numbers, letters, spaces,
                 line feeds and the like. The file name will generally
                 end with the .TXT extension (but could be anything).

            Base64 - Part of the MIME format. This is just one of many
                 formats it supports to transfer information without
                 using any 8-Bit characters.

            Bulletin Board - Also known as a BBS. A PC running a program
                 that allows other computers to connect through the
                 phone line. Once connected, a person can access
                 messages, files, games, etc. This may also be referred
                 to as the host system.

            Downloading - Copying a file from a Bulletin Board to your
                 PC.

            Hot key - Normally this is either a highlighted letter or
                 the first letter of a selection that will cause that
                 option to be selected (hitting the return key is not
                 required).

            MIME - This stands for Multipurpose Internet Mail
            Extensions. The only support for MIME in NewsWerthy is
            attached files using Base64.

            Off-line - No connection between your PC and a Bulletin
                 Board, the opposite of on-line.



                                         30


            Off-line mail reader - Allows reading of messages from a
                 Bulletin Board while not connected to the Bulletin
                 Board.

            On-line - Your PC connected to a Bulletin Board via your
                 modem and communications software running on your PC.

            Pathname - The drive, directory and filename of where a file
                 can be found.

            PC - Personal Computer, typically an IBM compatible or other
                 popular type.

            QWK format - An off-line mail format that is incompatible
                 with the SOUP format. This format contains CONTROL.DAT,
                 MESSAGES.DAT, *.IDX files, plus several other files.
                 NewsWerthy can't read messages in this format.

            Shareware - Try before you buy software, generally you have
                 30 days to try it out before sending your money or
                 discontinue using your copy. You are encouraged to
                 share it with friends and associates, provided that
                 copies are distributed in their complete and unmodified
                 form, and no amount is charged for the program, except
                 to cover distribution costs.

            Shell to DOS - A temporary exit to the DOS prompt to run a
                 program or a DOS command. Return to the previous
                 program by entering exit.

            Uploading - Copying a file from your PC to a Bulletin Board.




















                                         31






            VI.  INDEX                         .PL                       26
            + Msg                       12     .REP                      26
            - Msg                       12   Finding text in message     12
            Address book                14   Folders directory           21
            Alias                       14   Grey scale display          28
            ASCII text file             30   Help                         6
            Attach File                 15   Hide Read Newsgroups        23
            Auto-Save Reply             15   Hot Key                 18, 30
            Backup files                26   Increment Packet Name       23
            Base64                  15, 30   Introduction                 2
            Bot                         17   Keyboard usage              18
            Bulletin board              30   Keys                        18
            Colors                      25   Kill                        11
            CONTROL.DAT                 31   Mail packet
            Cross-post                  14     creating                   8
            Database                           download directory     7, 21
              expire messages           12     downloading               10
            Databasing Options      24, 29   Mailing lists               11
            Delete Message              16   Mark as Read                12
            Delete newsgroup            17   Mark as Unread              12
            Directories                      Mark Bottom                 17
              download               7, 21   Mark Top                    17
              folders                   21   Message
              saved                     21     attaching a file          15
              upload                 7, 21     deleting                  16
              work                      21     editing                   16
            Disclaimer                   6     finding text in           13
            DOS shell                   31     posting                   15
            Download directory       7, 21     printing                  17
            Downloading a file          30     quote formats             22
            Downloading mail packet     10     read flag                 12
            Edit Message                16     reading               11, 18
            Editor                      21     replying                  13
            Email                              saving                    16
              reading                   10     searching                 12
              sending                   16     sorting                   11
            Entering an email message   16   Message Header
            Environment variable               Bcc(Blind Carbon Copy)    14
              TEMP                      26     Cc(Carbon Copy)           14
              TMP                       26     Extra Header              15
            Expiration Options          24     Followup-To               14
              Expire All Messages       24     Keywords                  14
              Expire Killed Messages    24     Newsgroup                 14
              Expire Old Messages       24     Organization              14
              Expire Read Messages      24     Reply-To                  14
              Save Read Messages        24     Subject                   14
            Ext. Viewer                 22     Summary                   14
            F1 key                       6     To                        14
            Features                     2   Message reading style       23
            File extensions                  Message threading style     23
              .BKM                      26   MESSAGES.DAT                31
              .DAT                      26   MIME                        30
              .IDX                      26   Mode command                28
              .MSG                      26   Mouse                       20






              right button              20   Search for text in messages
            Multiple users              29       13
            New Packet                  10   Search To line in messages
            Newsgroup                            13
              catchup                   17   Send Mail (F7)              16
              listing                   17   Separate mailing lists     11,
              subscribing               17       23
              unsubscribing             17   Setup                    6, 20
            NWERTHY.KEY                 26     multiple                  29
            Offline                     30   Shareware                   31
            Offline mail reader         31   Shell to DOS                31
            Online                      31   Signature file              15
            Packet mode              2, 24   Smart searching             12
            Pathname                    31   Sort Messages               11
            Pc                          31   SOUP script                  8
            PGP                         27   System Requirements          4
            Pick list               19, 26   Tabs                        23
            Posting to newsgroup        15   Taglines                    28
            Print message               17   Technical support            4
            Printer                          TEMP                        26
              eject page                25   TMP                         26
              lines per page            25   Top                         17
              print short header        25   Upload directory         7, 21
              top margin                25   Uploading a file            31
            Printing registration form   5   Uploading a reply packet    10
            Printing the manual          7   Uqwk                         8
            Quote formats               22   Uqwk commands               17
            Quote with Initials         23   UUEncoding                  15
            QWK format                  31   View File (F5)              25
            Read News (F4)              11   Word star control keys      18
            Read Stored (F6)            16   Word Wrap                   23
            Reading a message           18   Work directory              21
            Reading messages            11   XXEncoding                  15
              errors                    12
            Reading style               23
            Registering NewsWerthy       4
            Replies
              reviewing                 16
            Reply packet
              creating                  26
              upload directory       7, 21
              uploading                 10
            Reply to message            13
            Restore Indexes             12
            Review Replies (F8)         16
            RFC1036                     14
            ROT-13                      12
            Save Attached File          17
            Save folder to text file    17
            Save message                16
            Save to Text File           16
            Saved Directory             21
            Screen Saver                21
