/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IPIF.H
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:
**     CREATION DATE:       1990/5/10
**
** DESCRIPTION: Contains typedefs and prototypes for the
**              interface layer
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   IPIF.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/IPIF.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 11:40:50   etstjan
**              No explicit note
*************************************************************************/

/* defines for interface flags */
#define    IF_UP           1         /* interface is running */
#define    IF_BROADCAST    2         /* interface supports broadcast */
#define    IF_DEBUG        4         /* enable software debugging */
#define    IF_LOOPBACK     8         /* software loopback if */
#define    IF_POINTPOINT   16        /* interface is point to point */
#define    IF_RUNNING      32        /* interface resources allocated */
#define    IF_NOARP        64        /* interface doesn't use ARP */

/* global variables */

extern  IFDESCRIPTOR  *FirstIf;      /* pointer to start of if list */


/* prototypes */

int InitIfLayer(void);
IFADDRESS *AddressSearch(IFADDRESS *AddPoint, ADDRESS_T Search_Add,
                         ADDRESS_T Mask);

int       AddIfAddress(IFADDRESS **ListStart,
                       ADDRESS_T NewAddress,
                       ADDRESS_T B_P_Address);

int       IfConfig(char *InterfName, ADDRESS_T HostAddress,
                   ADDRESS_T HostMask, ADDRESS_T DestAdd);
