/* [DOC] File ***********************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       pwghexd.c
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/6/27
**
** Descr:       Hex dump function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif
#include <ctype.h>
#include "pwinc.h"

#define WINSIZE     69
#define BUFSIZE     16
#define HALFSIZE    8
#define COL_OFFS    0
#define COL_HEX     4
#define COL_ASCII   53

static void pw_hexline(PWWIN *win, int line, unsigned char far *buf, unsigned offset, unsigned bufsize);
static void pw_hexfill(PWWIN *win, int nrow, unsigned char far *buf, unsigned offset, unsigned bufsize);

static void pw_hexline(PWWIN *win, int line, unsigned char far *buf,
                       unsigned offset, unsigned bufsize)
{
    int i;
    unsigned char temp[BUFSIZE];
    int nchar = (bufsize < BUFSIZE) ? bufsize : BUFSIZE;

    pw_printfat(win, line, COL_OFFS, "%04x", offset);
    for (i=0; i<nchar; i++)
    {
        if (i == HALFSIZE)
            pw_putcell(win, '', PWT_NORMAL);
        else
        {
            if (i == 0)
                pw_putc(win, '');
            else
                pw_putc(win, ' ');
        }
        pw_printf(win, "%02x", temp[i] = buf[offset+i]);
    }
    pw_cursor(win, line, COL_ASCII-1);
    pw_putc(win, '');
    for (i=0; i<nchar; i++)
    {
        if (isprint(temp[i]))
            pw_putcell(win, temp[i], PWT_HIGHLIGHT);
        else
            pw_putcell(win, '', PWT_NORMAL);
    }
}

static void pw_hexfill(PWWIN *win, int nrow, unsigned char far *buf,
                       unsigned offset, unsigned bufsize)
{
    int i = 0;
    int nlines = (bufsize-offset-1)/BUFSIZE;

    if (++nlines > nrow)
        nlines = nrow;
    pw_cls(win);
    for (i=0; i<nlines; i++)
    {
        pw_hexline(win, i, buf, offset, bufsize-offset);
        offset += BUFSIZE;
    }
}

/* [DOC] Function *********************************************
** Name:        pw_hexdump                                [API]
** SYNOPSIS:    PWKEY pw_hexdump(srow, scol, nrow, buf, bufsize)
**              int      srow       Top left row of data window
**              int      scol       Top left col of data window
**              int      nrow       Data window height
**              unsigned char far *buf  Pointer to data buffer
**              unsigned bufsize    Size of data buffer
** Descr:       Shows data in a hexdump window.
**              The 'pw_hexdump' function opens a window at
**                'srow', 'scol' of height 'nrow'
**              If 'nrow' is 0, it will make the window as large
**                as needed or possible.
**              It then fills this window with a hexdump of
**                the buffer contents 'buf', displaying
**                hexadecimal codes at the left side, and
**                printable ASCII characters at the right side.
** RETURNS:     Returns the keycode of the last key pressed.
**                Special keycodes are defined in POWER3.H and
**                all start with PWK_...
**************************************************************/
PWKEY pw_hexdump(int srow, int scol, int nrow, unsigned char far *buf,
                 unsigned bufsize)
{
    PWWIN *win = pw_open(srow, scol, nrow, WINSIZE, "Hexdump", PWM_DEFAULT, PWW_DATA);
    unsigned offset = 0;
    PWKEY key = 0;

    pw_keyinfo(win, NULL, "PgUp,PgDn=Scroll  Enter,Space=Exit");
    pw_block(win, 0, COL_HEX+1, 0, COL_ASCII-COL_HEX-2, PWT_HIGHLIGHT);
    pw_hexfill(win, nrow, buf, offset, bufsize);
    while (((key = pw_getkey()) != PWK_ESC) &&
            (key != ' ') && (key != PWK_ENTER))
    {
        switch (key)
        {
        case PWK_PGDN:
            if (offset + (nrow * BUFSIZE) < bufsize)
            {
                offset += (nrow * BUFSIZE);
                pw_hexfill(win, nrow, buf, offset, bufsize);
            }
            break;
        case PWK_PGUP:
            if (offset)
            {
                offset -= (nrow * BUFSIZE);
                pw_hexfill(win, nrow, buf, offset, bufsize);
            }
            break;
        }
    }
    pw_close(win);
    return key;
}

