#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       ERROR.MAK
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION: Global makefile for the Error Handling
#*              library.
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.1  $
#* WORKFILE:    $Workfile:   ERROR.mak  $
#* LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/ERROR/VCS/ERROR.MAV  $
#  
#     Rev 1.1   01 Feb 1991 10:03:44   etstjan
#  
#     Rev 1.0   01 Feb 1991 10:02:52   etstjan
#  Initial revision.
#************************************************************************
HOMEDIR=..\..
NEWTREE=.^\
MODEL=L
MODE=r
CFLAGS=/W4 /Ox /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE
LFLAGS=/STACK:8000
MFLAGS = HOMEDIR=$(HOMEDIR) CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
PUTNOTE="No explicit note"

SYSTEM=clerr
LIBS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
CS= clerr.c
AS=
CTS=
HS= error.h
MAKS=$(SYSTEM).mak
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) 
OBJS=clerr.obj
TOBJS=
EXES=
TEXES= 
EXPORTS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  lib
    @echo --->  Ready  $(MODEL)$(SYSTEM)$(MODE).lib


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXE) $(TEXES)

clean:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul


collect: $(EXPORTS)
    !-copy $(**F) $**


put:    $(SRCS)
    !@-PUT -l -n -t$(PUTNOTE) $**
    @-PUT -l -n -t$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l $**


get:    $(SRCS)
    !-GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(MODEL)$(SYSTEM)$(MODE).lib : $(OBJS)
    !LIB $@ -+$**;
    copy $(MODEL)$(SYSTEM)$(MODE).lib $(LD)

$(SRCS) :

$(EXPORTS) :

