/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IPRAW.C
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/6/26
**
** DESCRIPTION: Contains the implementation of the raw IP socket.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   IPRAW.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/UDP/VCS/IPRAW.C_V  $
**              
**                 Rev 1.1   01 Feb 1991 11:21:38   etstjan
**              No explicit note
**              
**                 Rev 1.0   21 Nov 1990 12:16:34   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/UDP/VCS/IPRAW.C_V   1.1   01 Feb 1991 11:21:38   etstjan  $";
#endif

#include      <stdio.h>
#include      <stdlib.h>
#include      <string.h>
#include      <beholder.h>             /* include buffer management */

#include      "ip.h"                   /* general ip defines */
#include      "ipcodes.h"              /* and ip return codes */
#include      "iplib.h"                /* include ip library */
#include      "iplayer.h"              /* ip send/receive */
#include      "socklib.h"              /* socket library routines */

/**************************************************************
** NAME:        IPRawRec
** SYNOPSIS:    int IPRawRec(PRREQ ThisReq, CIPHEAD *IPHeader,
**                           DATALINK *IPPacket, int BCast,
**                           int ECode);
**
** DESCRIPTION: Receives all packets for protocols not
**              supported by the IP package. Raw IP sockets
**              can be addressed by this module.
**
** RETURNS:     NO_ERR    --> everything fine
**              NO_PROTOC --> destination not found
**************************************************************/
int IPRawRec(PRREQ ThisReq, CIPHEAD *IPHeader,
             DATALINK *IPPacket, int BCast, int ECode)
{
  int      Value;
  SOCKET   *DestSock;

  switch (ThisReq) {
    case RECREQ :
      IPStat.NrRawRec++;

      if (BCast) {
        IPHeader->Destin = IPHeader->ExtraAddress;
        }

      /* search a destination socket in the Raw socket list */
      /* use protocol instead of port specification */
      if ((DestSock = So_Locate(IPHeader->Protocol, IPHeader->Destin,
                                IPHeader->Protocol, IPHeader->Source,
                                RawProt, &Value)) == NULL) {
        IPStat.NrNoRawSock++;
        return NO_PROTOC;
        }
      else {
        /* prepare for receiving packet including header */
        IPPacket->DataStart -= IPHeader->HLength;
        IPPacket->Length += IPHeader->HLength;
        MessToSock(DestSock, IPHeader, IPPacket);
        return NO_ERR;
        }

    case ERRREQ :
      if (((DestSock = So_Locate(IPHeader->Protocol, IPHeader->Source,
                                 IPHeader->Protocol, IPHeader->Destin,
                                 UDPProt, &Value)) != NULL) &&
          (Value == 15)) {
        DestSock->So_Error = ECode;
        }
      return NO_ERR;

    case SRCQNCHREQ :
      return NO_ERR;

    default :
      return ILL_REQUEST;
    }
}


