-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<vch.c>

The main VOUCH program. 

===================================================================
Definition of some LNs:

(Lpp,pp) = p-parameter of public-key
(Lqq,qq) = q-parameter of public-key
(Lgg,gg) = g-parameter of public-key
(LyPub,yPub) = Y-parameter of public-key
(LxSec,xSec) = your private-key
(LkSec,kSec) = A random LN generated during r-signature 
               computation (r=g^k mod p mod q) 
(LrSign,rSign) = r-component of signature
(LsSign,sSign) = s-component of signature
(Lmhash,mhash) = hash number
(Lh1,h1), (Lh2,h2), (Lh3,h3) = scratch variables for intermediate 
                               calculations
-----------------------------------------------------------------
pLen = number of 32-bit-words in the modulus 'p' (p-parameter of
       public-key).
qLen = number of 32-bit-words in the q-parameter of public-key.
bLen = size in bytes to be allocated for LNs.

fPubKey = file conataining public-key.
fSecKey = file containing your private-key.
rFile   = file containing pre-computed r-signatures.
keyWfile = file containing the "individualization string."
inFile = input file.
outFile = output file.

pswd = password string.

FILE *flog ; the log-file variable refers to "vch.log".
-------------------------------------------------------------

1.
void exit_proc( char *fn, int err ) ;

Before exiting, frees allocated memory. Appropraite error message
depending on the value of "err" is displayed. The file with which the
error is associated is <fn>.

I: fn : filename.
I: err : the error number.

2.
void logI( const char *line ) ;

Dipslays "line" and also writes it to the log-file. Starts the timer.

I: line : message string.

3.
void logF( void ) ;

Gets the time elapsed since last call to logI() and displays & logs
it. 

4.
void readPrime() ;

Reads the public-key parameters (Lpp,pp), (Lqq,qq), and (Lgg,gg) from
<fPubKey>. Sets "Nres=Lpp" needed by some routines in <gfmr.c>.

5.
void genKeys( char *fnpub, char *fnsec ) ;

Generates the private-key (LxSec,xSec) and the public-key Y-parameter
(LyPub,yPub). The public-key parameter is written as the fourth LN in
<myPublic.key>=fnpub and the private-key is written in
<myPrivat.key>=fnsec. The file "fnpub," with entries for public-key
parameters p,q,g, must already exist.  The existing key-files are
renamed "*.old".

I: fnpub : public-key filename
I: fnsec : private(secret)-key filename.

6.
void rSignature( void ) ;

Generates the r-component of the signature in (LrSign,rSign). Refer
to the DSS description in [1,2]. (rSign = gg^kSec mod pp mod qq,
where kSec is a random number.) When the routine returns, the
variable kSec contains kSec^{-1}.

7.
int sSignature( void ) ;

Computes the s-component of the signature in (LsSign,sSign). Refer to
the DSS description in [1,2,3]. A rare occurence which can reveal your
private-key is if the s-component turns out to be zero [3]; in this
case, sSignature() returns 1 (zero otherwise).

8.
int verify( void ) ;

Returns 1, if the signature [(LrSign,rSign), (LsSign,sSign)] verifies.
See the DSS description in [1,2]. 

9.
void encrypt( char *plnFile, char *encFile ) ;

Encrypts plaintext-file <plnFile> writing the ciphertext in
<encFile>. Calls fecrypt() for encryption. The encrypting-key needed
by fecrpyt(), key[], is generated according to Diffie-Hellman scheme
[4]. This uses the recipient's public-key.  The LN required by the
decryptor to find the encrypting-key is prepended to <encFile>.

I: plnFile : plaintext input filename.
I: encFile : ciphertext (encrypted) output filename.

10.
int decrypt( char *encFile, char *plnFile ) ;

Decrypts the ciphertext file <encFile> into plaintext <plnFile>.
Returns non-zero if error reading the input-file occurs.
Calls fdcrypt() for decryption. First the encrypting-key is computed
using the LN on the second line of <encFile> and your private key
according to Diffie-Hellman scheme [4]. The encrypting-key is filled
in key[] before calling fdcrypt(). 

I: encFile : ciphertext input filename.
I: plnFile : plaintext (decrypted) output filename.

11.
void init( char *fn ) ;

Initializes. Allocates space for some LNs. The word length of the
public-key p-parameter is read in "pLen" from the public-key file. The
space in bytes needed by LNs is computed in "bLen." The overhead "ovhd"
is required by partial-sum-of-residues method used by some routines
in <gfmr.c>. The global flag "init_ed" is set.

I: fn : filename.

12.
main(int argc, char *argv[] ) ;


===================================================================

[1] NIST, ``A Digital Signature Standard,'' FIPS PUB XX, August 19,
    1991.  Copies available from NTIS, US Department of Commerce,
    Springfield, VA 22161.

[2] Appendix A, <usrGuide.vch> accompanying the VOUCH package.

[3] ACM, Communications of the ACM, July 1992.

[4] Appendix F, <usrGuide.vch> accompanying the VOUCH package.
