/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<conio.h>
#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>

#include"sse.h"
#include"sseutil.h"
#include"ssecapt.h"


#define REVISION        "1"

/************************************     Buffer Sizes    */

#define MAX_TILES      256
#define MAX_PCX_SIZE   1024 * 768
#define MAX_TILE_DATA  MAX_TILES * 4096


int main( int argc, char * argv[] )
{
   char *inbuffer, *outbuffer, *out;
   sseTileGraphicInfo * TGI;
   TileLocInfo * TLI;
   int filecount, tilecount;
   imgInfo inputimg;
   FILE * fp;

   void SetupTileGraphicInfo( sseTileGraphicInfo * tgi );
   int ReadPCXPalette( palRegister * dest, char * filename );
   int ReadWholePCX( char * dest, imgInfo * img, char * filename );
   int CaptureAllTiles( char * outbuffer, char ** CP, imgInfo * pic, sseTileGraphicInfo * tgi, TileLocInfo * tli );

   if( argc < 5 )
   {
      printf( "\nUsage: CAPT-TIL <tile-width> <tile-height>\n       <input-pcx-names>... <output-tile-name>\n\n" );
      exit( 1 );
   }

   printf("\n CAPT-TIL Utility  Version %s  Revision %s\n\n",SSE_VERSION,REVISION);

   TGI = (sseTileGraphicInfo*) malloc( sizeof( sseTileGraphicInfo ) + MAX_TILE_DATA );
   inbuffer = malloc( MAX_PCX_SIZE );
   TLI = (TileLocInfo*) malloc( sizeof( TileLocInfo ) * MAX_TILES );

   if( !inbuffer || !TGI || !TLI )
   {
      printf( "Memory allocation failed!\n" );
      printf( "  Solution: Free more EMS/XMS or reduce CAPT-TIL buffer sizes.\n\n" );
      return EXIT_FAILURE;
   }

   SetupTileGraphicInfo( TGI );
   TGI->Width = atoi(argv[1]);
   TGI->Height = atoi(argv[2]);

   if( TGI->Width % 4 )
   {
      printf( "\nTile Width MUST be Divisible by Four!\n\n" );
      return EXIT_FAILURE;
   }
   if( TGI->Width < 4 || TGI->Height < 1 )
   {
      printf( "\nInvalid Tile Dimentions!\n\n" );
      return EXIT_FAILURE;
   }

   filecount = 3;
   tilecount = 0;
   out = outbuffer = (char*)(TGI+1) ;

   if( ReadPCXPalette( TGI->Palette, argv[filecount] ) ) return EXIT_FAILURE;

   while( filecount < argc - 1 )
   {
      if( ReadWholePCX( inbuffer, &inputimg, argv[filecount] ) ) return EXIT_FAILURE;

       printf( "File \"%s\" resolution %d x %d  -Working-",argv[filecount],
         inputimg.Width, inputimg.Height );

      if( CaptureAllTiles( outbuffer, &out, &inputimg, TGI, TLI ) ) return EXIT_FAILURE;

      printf( "\b\b\b\b\b\b\b\b\bTiles Captured: %d\n", TGI->NumTiles-tilecount );

      tilecount = TGI->NumTiles;
      filecount++;
   }

   printf( "Writing file \"%s\".\n", argv[filecount] );

   if(!( fp = fopen( argv[filecount], "wb" )))
   {
      printf("Error opening file!\n");
      return EXIT_FAILURE;
   }
   fwrite( TGI, sizeof( sseTileGraphicInfo ) + TGI->Width * TGI->Height *
      TGI->NumTiles, 1, fp );
   fwrite( TLI, sizeof( TileLocInfo ) * TGI->NumTiles, 1, fp );
   fclose( fp );
   
   if( filecount > 4 )
      printf("\n Total: %d frames captured.\n\n", TGI->NumTiles );

   return EXIT_SUCCESS;

}

void SetupTileGraphicInfo( sseTileGraphicInfo * tgi )
{
   tgi->IDNumber = TILE_GRAPHIC_ID;
   tgi->Width = 0;
   tgi->Height = 0;
   tgi->NumTiles = 0;
}

int ReadPCXPalette( palRegister * dest, char * filename )
{
   FILE * fp;
   pcxHeader ph;

   if( !( fp = fopen( filename, "rb" )) )
   {
      printf( "Error opening PCX file \"%s\"!\n\n", filename );
      return 1;
   }
   pcxGetHeader( & ph, fp );

   if( ph.BitsPerPixel != 8 )
   {
      printf( "PCX file \"%s\" is not in 256 colors!\n\n", filename );
      fclose( fp );
      return 1;
   }
   
   pcxGetPalette( (char*) dest, fp );
   return 0;
}


int ReadWholePCX( char * dest, imgInfo * img, char * filename )
{ 
   FILE * fp;
   pcxHeader ph;

   if( !( fp = fopen( filename, "rb" )) )
   {
      printf( "Error opening PCX file \"%s\"!\n\n", filename );
      return 1;
   }
   pcxGetHeader( & ph, fp );

   if( ph.BitsPerPixel != 8 )
   {
      printf( "PCX file \"%s\" is not in 256 colors!\n\n", filename );
      fclose( fp );
      return 1;
   }

   if( ph.Width * ph.Height > MAX_PCX_SIZE )
   {
      printf( "Cannot handle PCX file \"%s\"!\n", filename );
      printf( "  Solution: Increase CAPT-SSP \"MAX_PCX_SIZE\" value.\n\n" );
      return 1;
   }
   
   pcxDecodeToBuffer( dest, ph.Width, ph.Height, fp );
   fclose( fp );

   img->Width = ph.Width;
   img->Height = ph.Height;
   img->BytesPerRow = ph.Width;
   img->Data = dest;

   return 0;
}

int CaptureAllTiles( char * outbuffer, char ** CP, imgInfo * pic, sseTileGraphicInfo * tgi, TileLocInfo * tli )
{
   static int FileNum = 0;
   int x, y, HTiles, VTiles;
   char * out, * temp;
   unsigned char * p;
   imgInfo tile;

   out = * CP;
   tile.Width = tgi->Width;
   tile.Height = tgi->Height;
   tile.BytesPerRow = pic->BytesPerRow;
   
   HTiles = pic->Width / tile.Width;
   VTiles = pic->Height / tile.Height;

   tli += tgi->NumTiles;

   y = 0;
   while( y < VTiles )
   {
      x = 0;
      while( x < HTiles )
      {
         if( out-outbuffer+(tile.Width*tile.Height) > MAX_TILE_DATA )
         {
            printf( "\nOut of tile data memory!\n" );
            printf( "  Solution: Increase CAPT-TIL \"MAX_TILE_DATA\" value.\n\n");
            return 1;
         }

         tile.Data = pic->Data + x * tile.Width + y * tile.Height * pic->BytesPerRow;
         temp = captTile( out, &tile );

         // Check if entire tile is color 255

         p = out;   
         while( p < temp )
         {
            if( *(p++) != 255 )
            {
               if( tgi->NumTiles == MAX_TILES )
               {
                  printf( "\nMaximum Tiles Exceeded!\n" );
                  return 1;
               }

               out = temp;  // If not, include the tile
               tgi->NumTiles++;
               tli->FileNum = FileNum;
               tli->XPos = x;
               tli->YPos = y;
               tli++;
               break;
            }
         }
         x++;
      }
      y++;
   }
   * CP = out;
   FileNum++;
   return 0;
}
