//////////////////////////////////////////////////////////////////////////
// AccessBMP(char *Filename)
//             This routine opens the BMP file and checks to see if it's
//             okay to use.  At present, BMP files must be:
//                  16-Color & Uncompressed.
//             Will warn if the image is too big for the default video 
//             mode.  BMP file structures should be defined as global 
//             in the calling routine.
//////////////////////////////////////////////////////////////////////////


#include <stdio.h>
#include <graphics.h>
#include "bmp.h"

extern BITMAPFILEHEADER BMPHeader;
extern BITMAPINFOHEADER BMPInfo;


int AccessBMP(char *BMPFile)
{
        FILE *Fn;
        int gdriver=DETECT, gmode, errorcode=BMP_OK, maxx, maxy;


        Fn = fopen(BMPFile,"rb");               // Open up BMP image file     
                                                   
                                                // Read in BMP header
        fread(&BMPHeader,sizeof(BMPHeader),1,Fn);
        fread(&BMPInfo,sizeof(BMPInfo),1,Fn);
        fclose(Fn);

                                                // register a driver that was added into graphics.lib 
        registerfarbgidriver(EGAVGA_driver_far);


                                                // initialize graphics and check status 
        initgraph(&gdriver, &gmode, "");
        maxx = getmaxx();
        maxy = getmaxy();
                                                // Set Error codes, if need be
        if (graphresult() != grOk) errorcode = BMP_BadDriver;
        closegraph();

                                                // Error: Image is too big for video card
        if ((BMPInfo.biWidth+1 >= maxx) || (BMPInfo.biHeight+1 >= maxy)) errorcode = BMP_TooBig;

                                                // Error: only 16-color BMPs can be processed               
        if (BMPInfo.biBitCount != 4) errorcode = BMP_WrongVideo;

                                                // Error: image was compressed 
        if (BMPInfo.biCompression != 0) errorcode = BMP_Compression;

        return(errorcode);
}

