/*** SOURCE2.C - Creates a .3DV file with the definition of 3 curves
	     by Lenimar N. Andrade, ccendm03@brufpb.bitnet
      Dep. of Mathematics - Universidade Federal da Paraba - Brazil ***/

#include <stdio.h>
#include <math.h>
#include <conio.h>

unsigned nu = 400;
FILE *arq;

/* Parametric equations of the curves */
float f1(float t) { return (5 + 2*sin(5*t))*cos(2*t); }
float f2(float t) { return (5 + 2*sin(5*t))*sin(2*t); }
float f3(float t) { return 2*cos(5*t); }

float g1(float t) { return 0.7*(5 + 2*sin(5*t))*cos(2*t); }
float g2(float t) { return 0.7*(5 + 2*sin(5*t))*sin(2*t); }
float g3(float t) { return 0.7*2*cos(5*t); }

float h1(float t) { return 1.1*(5 + 2*sin(5*t))*cos(2*t); }
float h2(float t) { return 1.1*(5 + 2*sin(5*t))*sin(2*t); }
float h3(float t) { return 1.1*2*cos(5*t); }

/* ------------------------------------------------------------------------- */

void CalcPoints2(float umin, float umax) {

  float u, incrU;
  unsigned i;

  incrU = (umax - umin)/nu;

  fprintf(arq, "%u\n", 3*(nu + 1));
  for (u = umin; u < umax + incrU/2; u+= incrU)
    fprintf(arq, "%6.3f %6.3f %6.3f\n", f1(u), f2(u), f3(u));
  for (u = umin; u < umax + incrU/2; u+= incrU)
    fprintf(arq, "%6.3f %6.3f %6.3f\n", g1(u), g2(u), g3(u));
  for (u = umin; u < umax + incrU/2; u+= incrU)
    fprintf(arq, "%6.3f %6.3f %6.3f\n", h1(u), h2(u), h3(u));

  fprintf(arq, "%u\n", 4*(nu + 1));
  for (i = 1; i <= nu + 1; i++) {
    fprintf(arq, "%u %u\n", i, 0);
    fprintf(arq, "%u %u\n", nu+ 1 + i, i % 2 == 0 ? BLUE : LIGHTBLUE);
  }
  for (i = 1; i <= nu + 1; i++) {
    fprintf(arq, "%u %u\n", i, 0);
    fprintf(arq, "%u %u\n", 2*(nu+ 1) + i, RED);
  }

}

/* ------------------------------------------------------------------------- */

void PrintMsg(void) {

  fprintf(arq, "\n%s", "Segments linking f(t) = ((5+2*sin(5*t))*cos(2*t),"
		       "(5+2*sin(5*t))*sin(2*t),"
		       "\n                          2*cos(5*t)), 0.7*f(t) and"
		       " 1.1*f(t)");
  fprintf(arq, "\n%s", "Lenimar Nunes de Andrade, ccendm03@brufpb.bitnet\n");
}

/* ------------------------------------------------------------------------- */

void main(void) {

  if ((arq = fopen("demo2.3dv", "wt")) == NULL) return;
  CalcPoints2(0, 6.2832);
  PrintMsg();
  fclose(arq);
}

/* ------------------------------------------------------------------------- */

/*** END OF "SOURCE2.C" ***/
