module pk_file_KEY
! -------------
!  Copyright (C) 1995, Garnatz and Grovender, Inc.
!
!  Permission to distribute this software and its documentation within
!  your department or organization, is granted only under the terms
!  of our Software Licensing Agreement.  A fee must be paid for use
!  of this software.
!
!  For a copy of the Software Licensing Agreement write to:
!
!  Garnatz and Grovender, Inc.
!  5301 26th Avenue South
!  Minneapolis Minnesota USA 55417-1923
!
!  This general terms of the Software Licensing Agreement provide for
!  distribution of this software under what is generally called a
!  "shareware" agreement.  If you are using this software, you are
!  requested to acquire a license to use it at one of the following
!  4 levels:
!
!  INDIVIDUAL USE:
!  level 0:  1 developer with source, on only 1 computer           $45.00
!  MULTIPLE USE:
!  level 1:  1 developer, and up to 10 runtime copies             $120.00
!  level 2:  up to 10 developers, and up to 100 runtime copies    $350.00
!  level 3:  unlimited developers, and unlimited runtime copies  $2500.00
!
!  Upon payment and acceptance of the Software Licensing Agreement you
!  will be entitled to many benefits, including 1) updates and bugfixes
!  as needed, 2) complete documentation, 3) additional utility programs to
!  inquire into the status of and repair damaged files, 4)access to fee-based
!  consulting and other services.
!
!  This software is provided as is and Garnatz and Grovender, Inc. disclaims
!  all warranties with regard to this software, including all implied warranties
!  of merchantability and fitness for a particular purpose.  In no event
!  shall Garnatz and Grovender, Inc. be liable for any special, indirect or
!  consequential damages or any damages whatsoever resulting from loss of
!  use, data or profits, whether in an action of contract, negligence or
!  other tortious action, arising out of or in connection with the use or
!  performance of this software.
!  -------------
!
! Customize this file by globally replacing '_KEY' with '_yourstring' identifier
! and entering your key and data fields below.
!
      type data_record_type_KEY
                                         ! your key goes here
         character (len=8) :: key
                                         ! your data goes here
         character (len=120) :: data
      end type
!
      type pk_record_KEY
         integer :: v_d_flag
         type (data_record_type_KEY) :: dat
      end type
!
      type pk_block_defn_KEY
         character (len=128) :: name
         character (len=8) :: v_name
         integer :: v_num
         character (len=48) :: copyrt
         integer :: num_recs
         integer :: del_ptr
         integer :: rec_len
         integer :: num_indx
         integer :: rsv3
         integer :: rsv2
         integer :: rsv1
         logical :: writable
         integer :: unit
         integer :: hdr_len
         integer :: first_loc
      end type
!
      type (pk_record_KEY) :: pk_record_temp_KEY
      type (pk_block_defn_KEY), pointer :: pk_block_KEY
!
      integer, parameter :: PKERR_ILLREC = - 11
      integer, parameter :: PKERR_FILE = - 12
      integer, parameter :: PKERR_MEM = - 13
      integer, parameter :: PKERR_NOFILE = - 14
!
      integer, private :: extended_error
!
contains
!
      subroutine pk_file_create_KEY (name, unit, err)
         implicit none
         character (len=*), intent (in) :: name
         integer, intent (in), optional :: unit
         integer, intent (out), optional :: err
         type (pk_record_KEY), pointer :: ptr_pk
!
         integer :: lenf
         integer :: ierr
         integer :: unitu
         integer :: lenhdr
         type (pk_block_defn_KEY), pointer :: pk_block_KEY
         character (len=128) :: fname
!
         extended_error = 0
         if (present(unit)) then
            unitu = unit
         else
            unitu = find_unit_KEY ()
            if (unitu <= 0) then
               ierr = PKERR_NOFILE
               go to 99
            end if
         end if
         allocate (ptr_pk)
         inquire (iolength=lenf) ptr_pk
         deallocate (ptr_pk)
         !print*,' created length is ',lenf
!
         allocate (pk_block_KEY)
         inquire (iolength=lenhdr) pk_block_KEY
         pk_block_KEY%name = name
         pk_block_KEY%copyrt = 'Copyright(c) Garnatz and Grovender,&
        & Inc. 1995.'
         pk_block_KEY%v_name = 'pk_file'
         pk_block_KEY%v_num = 102
         pk_block_KEY%num_recs = 0
         pk_block_KEY%del_ptr = 0
         pk_block_KEY%rec_len = lenf
         pk_block_KEY%num_indx = 0
         pk_block_KEY%rsv1 = 0
         pk_block_KEY%rsv2 = 0
         pk_block_KEY%rsv3 = 0
         pk_block_KEY%writable = .true.
         pk_block_KEY%unit = - 1
         pk_block_KEY%first_loc = Max (1, (lenhdr-1) /lenf+1)
         pk_block_KEY%hdr_len = lenhdr
         !print*,' created header/ first_loc ',lenhdr,pk_block_KEY % first_loc
         ierr = 0
         fname = trim (name) // '.pk'
         open (unit=unitu, file=fname, status='new', access='direct', &
        & recl=lenhdr, form='unformatted', action='write', iostat=ierr, &
        & err=98)
         write (unitu, iostat=ierr, rec=1, err=98) pk_block_KEY
         close (unitu, iostat=ierr)
         if (ierr /= 0) go to 98
         deallocate (pk_block_KEY, stat=ierr)
         if (ierr /= 0) then
            extended_error = ierr
            ierr = PKERR_MEM
         end if
         go to 99
98       continue
         extended_error = ierr
         ierr = PKERR_FILE
99       continue
         if (present(err)) then
            err = ierr
         end if
      end subroutine pk_file_create_KEY
!
      function pk_file_open_KEY (name, unit, action, err) result &
     & (pk_block_KEY)
         implicit none
         character (len=*), intent (in) :: name
         integer, intent (in), optional :: unit
         character (len=*), optional, intent (in) :: action
         integer, intent (out), optional :: err
!
         type (pk_block_defn_KEY), pointer :: pk_block_KEY
         integer :: ierr
         integer :: unitu
         integer :: lenhdr
         character (len=128) :: fname
         character (len=9) :: my_action
!
         extended_error = 0
         if (present(unit)) then
            unitu = unit
         else
            unitu = find_unit_KEY ()
            if (unitu <= 0) then
               ierr = PKERR_NOFILE
               go to 99
            end if
         end if
!
         if (present(action)) then
            my_action = action
         else
            my_action = 'readwrite'
         end if
!
         ierr = 0
         nullify (pk_block_KEY)
         allocate (pk_block_KEY, stat=ierr)
         if (ierr /= 0) go to 99
         inquire (iolength=lenhdr) pk_block_KEY
! open key file header and read control information
         fname = trim (name) // '.pk'
         !print*, ' open header file ', lenhdr
         open (unit=unitu, file=fname, status='old', access='direct', &
        & recl=lenhdr, form='unformatted', action=my_action, &
        & iostat=ierr, err=98)
         if (ierr /= 0) go to 98
         read (unit=unitu, rec=1, iostat=ierr, err=98) pk_block_KEY
         pk_block_KEY%unit = unitu
         pk_block_KEY%name = fname
         close (unit=unitu, iostat=ierr, err=98)
! open data file
         !print*, ' open data file ', pk_block_KEY%rec_len
         open (unit=unitu, file=fname, access='direct', &
        & recl=pk_block_KEY%rec_len, form='unformatted', &
        & action='readwrite', iostat=ierr, err=98)
         if (present(err)) err = ierr
         return
98       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
         return
99       continue
         if (present(err)) then
            err = PKERR_MEM
         end if
      end function pk_file_open_KEY
!
      subroutine pk_file_close_KEY (pk_block_KEY, err)
         implicit none
         integer, intent (out), optional :: err
         type (pk_block_defn_KEY), pointer :: pk_block_KEY
!
         integer :: ierr
         character (len=128) :: fname
!
         extended_error = 0
         ierr = 0
         if ((pk_block_KEY%unit <= 0) .or. &
        & ( .not. pk_block_KEY%writable)) then
            ierr = PKERR_ILLREC
            go to 97
         end if
! close data file
         close (unit=pk_block_KEY%unit, iostat=ierr, err=99)
! open, update, and close control file
         fname = pk_block_KEY%name
         open (unit=pk_block_KEY%unit, file=fname, status='old', &
        & recl=pk_block_KEY%hdr_len, access='direct', form='unformatted &
        &', action='readwrite', iostat=ierr, err=99)
         if (ierr /= 0) go to 99
         write (unit=pk_block_KEY%unit, rec=1, iostat=ierr, err=99) &
        & pk_block_KEY
         close (unit=pk_block_KEY%unit, iostat=ierr, err=99)
         deallocate (pk_block_KEY, stat=ierr)
97       continue
         if (present(err)) err = ierr
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end subroutine pk_file_close_KEY
!
      subroutine pk_get_record_KEY (pk_block_KEY, pk_rno, data_record, &
     & err)
         implicit none
         type (pk_block_defn_KEY), pointer :: pk_block_KEY
         integer, intent (in) :: pk_rno
         type (data_record_type_KEY), intent (out) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         if ((pk_rno <= 0) .or. (pk_rno > pk_block_KEY%num_recs)) then
            ierr = PKERR_ILLREC
            go to 99
         end if
         read (unit=pk_block_KEY%unit, &
           & rec=pk_rno+pk_block_KEY%first_loc, iostat=ierr, err=98) &
           & pk_record_temp_KEY
         data_record = pk_record_temp_KEY%dat
         if (pk_record_temp_KEY%v_d_flag /= -1) then
            ierr = PKERR_ILLREC
         end if
         go to 99
98       continue
         extended_error = ierr
         ierr = PKERR_FILE
99       continue
         if (present(err)) then
            err = ierr
         end if
      end subroutine pk_get_record_KEY
!
      subroutine pk_put_record_KEY (pk_block_KEY, pk_rno, data_record, &
     & err)
         implicit none
         type (pk_block_defn_KEY), pointer :: pk_block_KEY
         integer, intent (in) :: pk_rno
         type (data_record_type_KEY), intent (in) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         pk_record_temp_KEY%dat = data_record
         pk_record_temp_KEY%v_d_flag = - 1
         write (unit=pk_block_KEY%unit, rec= &
           & pk_rno+pk_block_KEY%first_loc, iostat=ierr, err=99) &
           & pk_record_temp_KEY
99       continue
         if (present(err)) then
            err = ierr
         end if
      end subroutine pk_put_record_KEY
!
      function pk_new_record_KEY (pk_block_KEY, data_record, err) &
     & result (rno)
         implicit none
         type (pk_block_defn_KEY), pointer :: pk_block_KEY
         integer :: rno
         type (data_record_type_KEY), intent (in) :: data_record
         integer, intent (out), optional :: err
!
         integer :: ierr
!
         ierr = 0
         extended_error = 0
         if (pk_block_KEY%del_ptr > 0) then
            rno = pk_block_KEY%del_ptr
            read (unit=pk_block_KEY%unit, rec= &
              & rno+pk_block_KEY%first_loc, iostat=ierr, err=99) &
              & pk_record_temp_KEY
            if (ierr /= 0) then
               rno = - 1
               go to 99
            end if
            pk_block_KEY%del_ptr = pk_record_temp_KEY%v_d_flag
         else
            pk_block_KEY%num_recs = pk_block_KEY%num_recs + 1
            rno = pk_block_KEY%num_recs
         end if
!
         pk_record_temp_KEY%v_d_flag = - 1
         pk_record_temp_KEY%dat = data_record
         write (unit=pk_block_KEY%unit, rec= &
           & rno+pk_block_KEY%first_loc, iostat=ierr, err=99) &
           & pk_record_temp_KEY
!
         if (present(err)) err = ierr
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end function pk_new_record_KEY
!
      subroutine pk_delete_record_KEY (pk_block_KEY, pk_rno, err)
         implicit none
         type (pk_block_defn_KEY), pointer :: pk_block_KEY
         integer, intent (in) :: pk_rno
         integer, intent (out), optional :: err
!
         type (data_record_type_KEY) :: data_record
         integer :: ierr
!
         ierr = 0
         call pk_get_record_KEY (pk_block_KEY, pk_rno, data_record, &
        & ierr)
         if (ierr /= 0) go to 99
         pk_record_temp_KEY%v_d_flag = pk_block_KEY%del_ptr
         pk_block_KEY%del_ptr = pk_rno
!
         write (unit=pk_block_KEY%unit, rec= &
           & pk_rno+pk_block_KEY%first_loc, iostat=ierr, err=99) &
           & pk_record_temp_KEY
         if (present(err)) err = ierr
         return
99       continue
         extended_error = ierr
         if (present(err)) then
            err = PKERR_FILE
         end if
      end subroutine pk_delete_record_KEY
!
      function find_unit_KEY () result (unitu)
         integer :: unitu
!
         logical tf
         do i =  99, 1, - 1
            unitu = i
            inquire (unit=unitu, opened=tf)
            if ( .not. tf) return
         end do
         unitu = - 1
      end function find_unit_KEY
!
      integer function ext_err_KEY() result (ierr)
         ierr = extended_error
      end function ext_err_KEY
!
end module pk_file_KEY
