/*
 * inspath.c
 *
 * Insert directory <pathname2> before <pathname1>
 *
 * Returned status:
 *	0	OK (including case where nothing needs to be done)
 *	1	bad arguments
 *
 */
#include <io.h>
#include <string.h>
#include <stdlib.h>

void exit(int status) { _exit(status); }

#define writes(s,i)  write(i,s,strlen(s));

main(int argc, char *argv[])
{
	int len;
	char *path, *pathname1, *pathname2, *str;

	if( argc != 3)	{
		writes("Usage: inspath  path_to_insert_before  new_path\n",2);
		exit(1);
	} else	{
		len = strlen(argv[1]);
		if(*(argv[1]+len-1) == ';') *(argv[1]+len-1) = '\0';
		len = strlen(argv[2]);
		if(*(argv[2]+len-1) == ';') *(argv[1]+len-1) = '\0';
		pathname1 = strupr(argv[1]);
		pathname2 = strupr(argv[2]);
		path  = getenv("PATH");

    	len = strlen(pathname1);
		str = path;
		while (str)	{
			str = strstr(str, pathname1);
			if(!str)	{
				/* pathname1 not found - just tag pathname2 on the end */
				writes(path,1);
				writes(";",1)
				writes(pathname2,1);
				break;
			} else if(*(str+len) == ';' || *(str+len) == '\0')	{
				/* found it - insert pathname2 at the right place */
				char c = *str;
				*str = '\0';
				writes(path,1);
				writes(pathname2,1);
				writes(";",1);
				*str = c;
				writes(str,1);
				break;
			} else	{
				/* incorrect match found - keep looking */
				str += len;
			}
		}
	}
	return(0);
}


