/*
 * incr.c - increment a numeric environment variable
 *
 * Author:		R. Brittain	4/11/90
 *
 * Syntax:
 *		incr variable
 *
 *					This code placed in the public domain
 *
 */
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>
#include <io.h>

/* size minimization measures */
setenvp() {}
void exit(int status) { _exit(status); }

#define MEMCHECK(x)		if ((x) == NULL) fatal("Out of memory",1)

#ifdef UNIXCOMPAT
 #define strupr(x)			(x)		/* disable upper-casing env-vars */
#endif

/* prototypes */

int 	 get_env_index(char *var, char **env_var);
int  	 getenvseg(unsigned *envseg);
unsigned get_env_var(unsigned env_addr, char ***env_var, int *count);
void 	 put_env_var(unsigned env_addr, unsigned seglen, char **env_var);

void 	 fatal(char *msg, int status);
char 	 *concat(char *s1, char *s2);

main(int argc, char **argv)
{
	char usage[] = "usage: incr variable \n";
	unsigned env_addr, seglen;
	int index, count;
	char value[10], **env_var, *p;

	if (argc == 1)
		fatal(usage,1);

	if ( !getenvseg(&env_addr))
		fatal ("Cannot locate environment\n",2);

	/* convert variable to upper case for compatibility */
	strupr(argv[1]);

	seglen = get_env_var( env_addr, &env_var, &count );
	index  = get_env_index( argv[1], env_var );
	if (index == count)
		fatal (concat(argv[1]," not in environment "),1);

	/* increment the value of the variable */
	p = strchr(env_var[index],'=')+1 ;
	if (strspn(p,"-+0123456789") != strlen(p))
		fatal (concat(argv[1]," is non-numeric - cannot increment"),1);

	/*
	 * change only the next line to decrement, or do whatever else you
	 * want with the numeric value
	 */
	itoa(atoi(p) + 1, value, 10);

	*(strchr(env_var[index],'=')+1) = '\0';
	env_var[index] = concat(env_var[index],value);
	put_env_var(env_addr, seglen, env_var);
	return(0);
}


char *concat(s1, s2)
char *s1, *s2;
{
/*
 * return the concatenation of s1 and s2 in malloced memory
 */
	char *p;
	p = malloc(strlen(s1)+strlen(s2)+2);
	if (p == (char *)NULL) {
		fatal ("\nOut of memory\n",1);
	} else {
		strcpy(p,s1);
		strcat(p,s2);
	}
	return(p);
}

void fatal(char *msg, int status)
{
	write(2,msg,strlen(msg));
	exit(status);
}

#include "envfuncs.c"
