{$M 16384,512,65536}
Program JugglePro;
{(c) 8/28/92 Ed Carstens}

{Version 3.3   3/27/93
Author:  Ed Carstens
Thanks to Jack Boyce for his pattern generator.}

uses crt,dos,graph,header,jpfcts,showbuff,demoinput,
     jppat,jphands,viewer,generator,convert,menus,jpdemo,jpdos,
     jphelp;

procedure changepalette(var p:palettetype);
var
  e:integer;
  s1,s2:string;
  z:shortint;
  hh:byte;

begin
  window(1,2,79,25);
  repeat
  clrscr;
  writeln('Choose all colors by typing *.  Hit ENTER to exit.');
  writeln;
  for hh:=0 to getmaxcolor do
    writeln('color #',hh,': ',p.colors[hh]);
  repeat
    write('Which color #?');
    readlndemo(s1);
    val(s1,hh,e);
    if (s1='*') or (length(s1)=0) then hh:=1;
  until (hh>=0) and (hh<=getmaxcolor);
  if length(s1)>0 then
  begin
    z:=p.colors[hh];             {assigns color # hh to z}
    repeat
      write('Enter new color: ');
      readlndemo(s2);
      val(s2,p.colors[hh],e);
      if length(s2)=0 then p.colors[hh]:=z;
    until (p.colors[hh]>=0);
    if (s1='*') and (length(s2)>0) then
      for hh:=1 to getmaxcolor do p.colors[hh]:=p.colors[1];
  end;
  until length(s1)=0;
  clrscr;
end;

{$F+} procedure customexit; {$F-}
begin
  puthands('temp.hnd');
  putpattern('temp.pat');
  if erroraddr<>nil then
    begin
      textmode(BW80);
      textcolor(black);
      textbackground(white);
      window(20,3,60,20);
      clrscr;
      writeln('----------------------------------------');
      writeln('I feel sick...  Please jot down the');
      writeln('following numbers and let my programmer');
      writeln('know what happened.  All data saved in');
      writeln('temp files.  Thank you!');
      writeln;
      writeln('Address = ',seg(errorAddr^),':',ofs(errorAddr^));
      writeln('Code    = ',exitcode);
      writeln;
      writeln('Programmer: Ed Carstens   (314) 364-7536');
      writeln('            email ecarsten@cs.umr.edu');
      writeln('----------------------------------------');
      erroraddr:=nil;
      exitcode:=0;
    end;
      exitproc:=savedexitproc;
end;

procedure welcome;
var
  ch:char;

begin
  graphdriver:=detect;
  initgraph(graphdriver,graphmode,'graph');
  cleardevice;
  setcolor(1);
  settextstyle(0,0,4);
  outtextxy(0,20,' J U G G L E P R O');
  settextstyle(0,0,2);
  setcolor(4);
  outtextxy(0,90,' V3.5 (c) May 23, 1993  Ed Carstens');

  setcolor(2);
  outtextxy(0,140,' If you have suggestions, comments, or');
  outtextxy(0,160,' questions, please contact me:');

  outtextxy(0,200,' Ed Carstens          Registration: $15');
  outtextxy(0,220,' RR2 Box 645          Updates: $5');
  outtextxy(0,240,' Rolla, MO 65401');
  outtextxy(0,260,' (314) 364-7536');
  outtextxy(0,280,' email: ecarsten@cs.umr.edu');

  outtextxy(0,320,' Special thanks to Jack Boyce for his');
  outtextxy(0,340,' pattern generator, j2.exe.');

  setcolor(white);
  outtextxy(0,390,'           - Hit any key -');
  ch:=readkey;
end;

begin
  savedexitproc:=exitproc;  {In case of error, save current exitproc and}
  exitproc:=@customexit;    {have exitproc point to customexit}
  endflg:=false;
  welcome;
  setupmenu;                {Initialization of main menus screen}
  display;                  {and pattern display}
  getdemo('demo1');         {load demo1 as default demo}
  repeat
    getmenuoption;
    eras(w);                {erase current main options window}
    case w of               {execute user-selected option}
      1: case opt of
           1: loadpattern;
           2: savepattern;
           3: editpath;
           4: directory;
           5: endflg:=true;
         end;
      2: case opt of
           1: gballs;
           2: gmaxthrow;
           3: gperiod;
           4: gswitches;
           5: generate;
           6: begin
                window(1,2,79,8);
                clrscr;
                genfile:=getfilename('gen');
                clrscr;
              end;
           7: gload;
         end;
      3: case opt of
           1: permute;
           2: translate;
           3: define;
           4: hands;
           5: period;
           6: multiplex;
           7: clear;
           8: conversions;
           9: synctoasync;
          10: editstartup;
          11: invertpattern;
         end;
      4: begin
          case opt of
           1: show(opt);
           2: show(opt);
           3: asyncon;
           4: syncon;
           5: rundemo;
           6: changedelay;
           7: createdemo;
           8: savedemo;
           9: loaddemo;
          end;
          if opt<3 then setupmenu;
         end;
      5: case opt of
           1: speed;
           2: dwellratio;
           3: hite;                {I do know how to spell, really!}
           4: holdflag:=true;
           5: holdflag:=false;
           6: changepalette(pt);
           7: changepalette(ipt);
           8: editfirstthrow;
         end;
      6: case opt of
           1: setuphands;
           2: loadhands;
           3: savehands;
           4: edithands2;
           5: permhands;
         end;
      7: help;
    end;
    if memoryflg then
      begin
        errmsg:='Not enough memory!';
        memoryflg:=false;
        h:=1;
        m:=1;
        l:=1;
        zerohilite;
        clear;
        resetpw;
      end;
    display;                {display pattern window}
    window(36,13,79,13);
    if length(errmsg)>0
      then
        begin
          write(errmsg);
          errmsg:='';
        end
      else clrscr;
  until endflg;                 {leave program when endflg on}
end.