/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1996 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3849 7731
 * Bellara                       http://www.gu.edu.au/gwis/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: directry.h 2.1 1995/06/24 16:29:35 MH Rel MH $
*/

#if defined(DOS) && defined(TC)

#define F_RO FA_RDONLY
#define F_HI FA_HIDDEN
#define F_SY FA_SYSTEM
#define F_DI FA_DIREC
#define F_AR FA_ARCH

#define FSTR_TYPE struct ffblk

#define ATTR_TYPE CHARTYPE
#define DATE_TYPE short
#define TIME_TYPE short
#define SIZE_TYPE long
#define D_TYPE    DATE_TYPE
#define T_TYPE    TIME_TYPE
#define DONE_TYPE short

#define ATTR_NAME ff_attrib
#define DATE_NAME ff_fdate
#define TIME_NAME ff_ftime
#define SIZE_NAME ff_fsize
#define NAME_NAME ff_name
#define D_NAME    dp->fdate
#define T_NAME    dp->ftime

#define HOUR_MASK ((time & 0xf800) >> 11)
#define MINU_MASK ((time & 0x07e0) >> 5)
#define DAYS_MASK (date & 0x001f)
#define MONT_MASK (mon[((date & 0x01e0) >> 5)-1])
#define YEAR_MASK (((date & 0xfe00) >> 9)+80)

#endif

#if defined(DOS) && defined(MSC)
#include <dos.h>
#define F_RO _A_RDONLY
#define F_HI _A_HIDDEN
#define F_SY _A_SYSTEM
#define F_DI _A_SUBDIR
#define F_AR _A_ARCH

#define FSTR_TYPE struct find_t

#define ATTR_TYPE CHARTYPE
#define DATE_TYPE unsigned short
#define TIME_TYPE unsigned short
#define SIZE_TYPE long
#define D_TYPE    DATE_TYPE
#define T_TYPE    TIME_TYPE
#define DONE_TYPE short

#define ATTR_NAME attrib
#define DATE_NAME wr_date
#define TIME_NAME wr_time
#define SIZE_NAME size
#define NAME_NAME name
#define D_NAME    dp->fdate
#define T_NAME    dp->ftime

#define HOUR_MASK ((time & 0xf800) >> 11)
#define MINU_MASK ((time & 0x07e0) >> 5)
#define DAYS_MASK (date & 0x001f)
#define MONT_MASK (mon[((date & 0x01e0) >> 5)-1])
#define YEAR_MASK (((date & 0xfe00) >> 9)+80)

#endif

#if defined(DOS) && defined(GO32)

#define F_RO FA_RDONLY
#define F_HI FA_HIDDEN
#define F_SY FA_SYSTEM
#define F_DI FA_DIREC
#define F_AR FA_ARCH

#define FSTR_TYPE struct ffblk

#define ATTR_TYPE CHARTYPE
#define DATE_TYPE short
#define TIME_TYPE short
#define SIZE_TYPE long
#define D_TYPE    DATE_TYPE
#define T_TYPE    TIME_TYPE
#define DONE_TYPE short

#define ATTR_NAME ff_attrib
#define DATE_NAME ff_fdate
#define TIME_NAME ff_ftime
#define SIZE_NAME ff_fsize
#define NAME_NAME ff_name
#define D_NAME    dp->fdate
#define T_NAME    dp->ftime

#define HOUR_MASK ((time & 0xf800) >> 11)
#define MINU_MASK ((time & 0x07e0) >> 5)
#define DAYS_MASK (date & 0x001f)
#define MONT_MASK (mon[((date & 0x01e0) >> 5)-1])
#define YEAR_MASK (((date & 0xfe00) >> 9)+80)

#endif

#ifdef OS2
#define F_RO FILE_READONLY
#define F_HI FILE_HIDDEN
#define F_SY FILE_SYSTEM
#define F_DI FILE_DIRECTORY
#define F_AR FILE_ARCHIVED

#define FSTR_TYPE FILEFINDBUF

#define ATTR_TYPE USHORT
#define DATE_TYPE FDATE
#define TIME_TYPE FTIME
#define SIZE_TYPE ULONG
#define D_TYPE    DATE_TYPE
#define T_TYPE    TIME_TYPE
#define DONE_TYPE USHORT

#define ATTR_NAME attrFile
#define DATE_NAME fdateLastWrite
#define TIME_NAME ftimeLastWrite
#define SIZE_NAME cbFile
#define NAME_NAME achName
#define D_NAME    dp->fdate
#define T_NAME    dp->ftime

#define HOUR_MASK (time.hours)
#define MINU_MASK (time.minutes)
#define DAYS_MASK (date.day)
#define MONT_MASK (mon[date.month-1])
#define YEAR_MASK (date.year+80)

#endif

#if defined(UNIX)
#   if defined(M_XENIX)
#      include <sys/dirent.h>
#      include <sys/ndir.h>
#   else
#      include <dirent.h>
#   endif
#   include <time.h>

#define F_RO 0
#define F_HI 0
#define F_SY 0
#define F_DI 0
#define F_AR 0

#if defined(ATT) || defined(M_XENIX)
#define mode_t ushort
#endif

#define ATTR_TYPE mode_t
#define SIZE_TYPE long
#define TIME_TYPE time_t
#define DATE_TYPE CHARTYPE
#define D_TYPE    struct tm *
#define T_TYPE    struct tm *
#define DONE_TYPE short

#define D_NAME    timp
#define T_NAME    timp

#define HOUR_MASK (time->tm_hour)
#define MINU_MASK (time->tm_min)
#define DAYS_MASK (date->tm_mday)
#define MONT_MASK (mon[date->tm_mon])
#define YEAR_MASK (date->tm_year)

#endif

struct dirfile {
	CHARTYPE	*fname;		/* file name */
	ATTR_TYPE	fattr;		/* file attributes */
	SIZE_TYPE	fsize;		/* size of file */
	TIME_TYPE	ftime;		/* time (last write) */
	DATE_TYPE	fdate;		/* date (if seperate to time) */
	int	facl;		/* acl */
};

#ifdef HAVE_PROTO
int fcomp();               /* this has been deliberatly left undefined */
CHARTYPE *make_full(CHARTYPE *,CHARTYPE *);
short getfiles(CHARTYPE *,CHARTYPE *,struct dirfile **,struct dirfile **);
CHARTYPE *file_attrs(ATTR_TYPE,CHARTYPE *,int);
CHARTYPE *file_date(D_TYPE,CHARTYPE *);
CHARTYPE *file_time(T_TYPE,CHARTYPE *);
short set_dirtype(CHARTYPE *);
#else
int fcomp();
CHARTYPE *make_full();
short getfiles();
CHARTYPE *file_attrs();
CHARTYPE *file_date();
CHARTYPE *file_time();
short set_dirtype();
#endif
