#include "pt.h"
#include "malloc.h"
#include "string.h"

void pascal
/* XTAG:mouseCommand */
mouseCommand(which, w, cp, menuRow, menuCol, evhead)
	struct window *w;
	long cp;
	int which, menuRow, menuCol, evhead;
{
	extern unsigned char msgBuffer[];
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern struct window *pendWindow;
	extern int searchMode;
	extern int mouseVec1[];
	extern int mouseVec2[];
	extern int quad67, quad45, quad22;
	extern int descrFileId;
	extern struct event events[];
	extern int helpMode;
	extern unsigned char selColor;
	extern unsigned char *screenChars;
	extern unsigned char *userMessages[];
	extern int scrRows, scrCols;
	extern struct SREGS segRegs;
	extern int debug;

	int deltaRow, deltaCol;
	int row1, col1, row2, col2;
	int i, fn, zz;
	int initalButtons, cancelled;
	int *vector;
	unsigned char *p1, *p2, *p3;
	unsigned char far *sBuffer;
	unsigned char *sOffset;
	unsigned int sizeOfBuffer;

	/* check for error cases */
	if( w == NULL || selWindow == NULL )
		return;
	
	/* see which vector to use */
	if( which == FMOUSECOM1 )
		vector = &mouseVec1[0];
	else
		vector = &mouseVec2[0];

	/* find the limit of the markers */
	row1 = menuRow - 1;
	row2 = menuRow + 1;
	col1 = menuCol - 1;
	col2 = menuCol + 1;
	zz = 0;		/* indicates which direction */
	p1 = screenChars + (scrCols<<1)*(row1) + ((col1)<<1);
	p2 = p1 + (scrCols<<1);
	p3 = p2 + (scrCols<<1);

	/* save the present screen characters */
	/* allocate some memory to hold the screen image */
	sizeOfBuffer = (unsigned)((scrCols<<1)*(row2-row1+1));
	sBuffer = _fmalloc(sizeOfBuffer);
	if( sBuffer == 0L ) {
		msg(userMessages[NOSPACEMSG], 3);
		return;	/* getBox cancelled */
	}
	sOffset = screenChars+(scrCols<<1)*row1;
	movedata(segRegs.ds, (unsigned int)sOffset, FP_SEG(sBuffer),
		FP_OFF(sBuffer), sizeOfBuffer);

	/*memcpy(screenBuffer, screenChars+(scrCols<<1)*row1,
		(unsigned)((scrCols<<1)*(row2-row1+1)));*/

	/* the first time we will use the original mouse event */
	initalButtons = events[evhead].buttons;
	cancelled = 0;
	goto firstTime;

/* this loop follows the mouse cursor and ends when the button */
/* is up.  While following the mouse it displays the command */
/* that would be executed if the button came up at that point */
while( 1) {
	/* wait for the mouse to move or the buttons to change */
	while( !isMouseEvent(0) )
		;
	evhead = getMouseEvent();
firstTime:
	deltaRow = events[evhead].vertical>>3;
	deltaCol = events[evhead].horizontal>>3;

	/* now figure out which way we moved */
	deltaRow = menuRow - deltaRow;
	deltaCol -= menuCol;
	if( deltaCol == 0 ) {
		if( deltaRow == 0 ) {
			zz = 0;
		} else if( deltaRow > 0 ) {
			zz = 1;
		} else {
			zz = 5;
		}
	} else {
		fn = (100 * deltaRow) / deltaCol;
		if( fn > quad67 ) {
			zz = deltaRow > 0 ? 1 : 5;
		} else if( fn > quad45 ) {
			zz = deltaRow > 0 ? 2 : 6;
			if( vector[zz] == FDONOTHING )
				zz = deltaRow > 0 ? 1 : 5;
		} else if( fn > quad22 ) {
			zz = deltaRow > 0 ? 2 : 6;
			if( vector[zz] == FDONOTHING )
				zz = deltaRow > 0 ? 3 : 7;
		} else if( fn > -quad22 ) {
			zz = deltaCol > 0 ? 3 : 7;
		} else if( fn > -quad45 ) {
			zz = deltaRow > 0 ? 8 : 4;
			if( vector[zz] == FDONOTHING )
				zz = deltaRow > 0 ? 7 : 3;
		} else if( fn > -quad67 ) {
			zz = deltaRow > 0 ? 8 : 4;
			if( vector[zz] == FDONOTHING )
				zz = deltaRow > 0 ? 1 : 5;
		} else {
			zz = deltaRow > 0 ? 1 : 5;
		}
	}
	fn = vector[zz];

	if( events[evhead].buttons == 0 )
		break;
	if( events[evhead].buttons != initalButtons )
		cancelled = 1;
	if( cancelled )
		fn = 31;

	/* set up the map and draw the menu */
	movedata(FP_SEG(sBuffer), FP_OFF(sBuffer), segRegs.ds,
		(unsigned int)sOffset, sizeOfBuffer);
	/*memcpy(screenChars+(scrCols<<1)*row1, screenBuffer,
		(scrCols<<1)*(row2-row1+1));*/

	if( fn == 31 ) {
	} else switch( zz ) {
		case 0:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			break;
		case 1:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p1+2) = 30;
			*(p1+3) = (unsigned char)(w->selColor);
			break;
		case 2:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p1+4) = (char)187;
			*(p1+5) = (unsigned char)(w->selColor);
			break;
		case 3:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p2+4) = 16;
			*(p2+5) = (unsigned char)(w->selColor);
			break;
		case 4:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p3+4) = (char)188;
			*(p3+5) = (unsigned char)(w->selColor);
			break;
		case 5:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p3+2) = 31;
			*(p3+3) = (unsigned char)(w->selColor);
			break;
		case 6:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p3) = (char)200;
			*(p3+1) = (unsigned char)(w->selColor);
			break;
		case 7:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p2) = 17;
			*(p2+1) = (unsigned char)(w->selColor);
			break;
		case 8:
			*(p2+2) = 7;
			*(p2+3) = (unsigned char)(w->selColor);
			*(p1) = (char)201;
			*(p1+1) = (unsigned char)(w->selColor);
			break;
	}
	updateScreen(row1, row2);
	if( helpMode > 0 ) {
		readLine(descrFileId, 80L*(long)(fn), &msgBuffer[0], 0);
		msgBuffer[78] = '\0';
		msg(msgBuffer, 1);
	}
}

if( !cancelled ) {
	/* find the indicated command */
	switch( fn ) {
	case FCOPYTO:	/* copy selection to this point */
		zz = COPY;
		goto moveAndCopy;

	case FMOVETO:	/* move selection to this point */
		zz = MOVE;
	moveAndCopy:
		/* find out what window (if any) and where the mouse was */
		xyToPos(&menuRow, &menuCol, &i, &cp, &w);
		/* adjust to the selection mode */
		cp = adjustSelMode(w->fileId, cp);
		copyMove(selWindow, selBegin, selEnd, w, cp, zz);
		break;

	default:
		command(fn, 0, w);
	}
}
_ffree(sBuffer);
redrawBox(row1, col1, row2, col2);
if( helpMode > 0 )
	msg("", 1);
}

long pascal
/* XTAG:adjustSelMode */
adjustSelMode(fid, cp)
	int fid;
	long cp;
{
	extern unsigned char msgBuffer[];
	extern int selMode;
	
	unsigned char ch;

	/* get the first character so we can handle the special cases */
	ch = readChar(fid, cp);

	switch( selMode ) {
	case SELLINE:
		if( ch == '\n' )
			--cp;
		while( 1 ) {
			ch = readChar(fid, cp);
			if( ch == '\n' || ch == '\0' )
				break;
			--cp;
		}
		++cp;
		break;
	case SELWORD:
		/* only search if cp is inside a word */
		if( isalnum(ch) || ch == '_' ) {
			while( 1 ) {
				ch = readChar(fid, cp);
				if( !isalnum(ch) && ch != '_' )
					break;
				--cp;
			}
			++cp;
		}
		break;
	default:
		/* no adjustment for character mode */
		break;
	}
	if( readChar(fid, cp) == '\n' ) {
		if( readChar(fid, --cp) != '\r' )
			++cp;
	}
	return cp;
}
