#include "pt.h"
#include "io.h"
#include "string.h"
#include "stdlib.h"
#include "direct.h"

int pascal
/* XTAG:quitPoint */
quitPoint(fn, noSave)
	int fn, noSave;
{
	extern unsigned char msgBuffer[];
	extern struct window *windowList;
	extern struct window *hiddenList;
	extern struct openFile *files;
	extern int i43lines;
#ifdef OVERLAYS
	extern int overlayState;
#endif
	extern unsigned char startDirectory[];
	extern unsigned char startDrive;
	extern struct openFile *files;

	register struct window *w2;
	register int j;
	unsigned char *fileName;
	int i, n;
	int fid;

	/* create (or truncate) the last state file */
	setDefaultDrive(startDrive);
	chdir(startDirectory);
	fid = creatls("pt.las", 0);
	if( fid >= 0 ) {
		sprintf(msgBuffer, "%d \r\n", i43lines);
		writels(fid, msgBuffer, strlen(msgBuffer));
	}
	if( !noSave )
		goto noChanges;
	n = 0;
	w2 = windowList;
	while( 1 ) {
		if( w2 == NULL ) {
			/* gone through both windowList and hiddenList? */
			if( n == 1 )
				break;	/* ifm we are done */
			/* if not do hiddenList */
			n = 1;	/* remember that we already did windowList */
			w2 = hiddenList;
			continue;
		}
		/* see if the file has been edited */
		if( files[w2->fileId].isChanged )
			goto areChanges;
		w2 = w2->nextWindow;
	}
	goto noChanges;
areChanges:
	fileName = getInput(
		"Are you sure you want to discard all changes?  ", "y", 1);
	if( tolower(fileName[0]) != 'y' ) {
		msg("Quit-Discard Edits cancelled", 1);
		return 0;
	}
noChanges:
	n = 0;
	w2 = windowList;
	while( 1 ) {
		if( w2 == NULL ) {
			/* gone through both windowList and hiddenList? */
			if( n == 1 )
				break;	/* ifm we are done */
			/* if not do hiddenList */
			n = 1;	/* remember that we already did windowList */
			w2 = hiddenList;
			continue;
		}
		if( fn == FQUITASK )
			j = 1;	/* ask about saving */
		else
			j = 0;	/* save without asking */
		if( fn == FQUITNOSAVE )
			j = 2;	/* do not ask or save */
		i = closeWindow(w2, j, 0);
		if( i == -1 ) {
			msg("Window close failed, quit cancelled", 3);
			goto noQuit;
		}
		/* record the state in the last state file */
		if( fid >= 0 ) {
			sprintf(msgBuffer, "%d %d %d %d %d %s \r\n",
				w2->row1, w2->col1, w2->row2, w2->col2,
				w2->numTopline, files[w2->fileId].origName);
			writels(fid, msgBuffer, strlen(msgBuffer));
		}
		w2 = w2->nextWindow;
	}
	/* reset the mouse */
	termMouse();
	n = 1;
	goto ret;
noQuit:
	n = 0;
ret:
	if( fid >= 0 )
		closels(fid);
	return n;
}

unsigned char * pascal
/* XTAG:getSelection */
getSelection(s)
	unsigned char *s;
{
	extern long selBegin, selEnd;
	extern struct window *selWindow;

	register unsigned char *p;
	long cp;
	register int fid;
	
	p = s;
	cp = selBegin;
	fid = selWindow->fileId;
	while( cp <= selEnd ) {
		*p++ =  readChar(fid, cp++);
		if( p-s >= 63 )
			break;
	}
	*p = '\0';
	return s;
}

void pascal
/* XTAG:matchChar */
matchChar()
{
	extern struct window *selWindow;
	extern long selBegin, selEnd;

	register unsigned char ch;
	long cp, fSize;
	unsigned char ch1, ch2;
	int n, matchDirection, nLines;

	cp = selBegin;
	ch = readChar(selWindow->fileId, cp);
	switch( ch ) {
	case '(': ch1 = '('; ch2 = ')'; matchDirection =  1; break;
	case ')': ch1 = ')'; ch2 = '('; matchDirection = -1; break;
	case '[': ch1 = '['; ch2 = ']'; matchDirection =  1; break;
	case ']': ch1 = ']'; ch2 = '['; matchDirection = -1; break;
	case '{': ch1 = '{'; ch2 = '}'; matchDirection =  1; break;
	case '}': ch1 = '}'; ch2 = '{'; matchDirection = -1; break;
	default:  ch1 = ' '; ch2 = ' '; matchDirection = -1; break;
	}
	if( ch1 == ' ' ) {
		msg("Matching for (, ), [, ], {, and } only", 1);
		return;
	}
	n = 1;	/* n==0 ==> we found the matching character */
	nLines = 0;
	fSize = fileSize(selWindow->fileId);
	while( 1 ) {
		cp += matchDirection;
		ch = readChar(selWindow->fileId, cp);
		if( ch == ch1 )
			++n;
		else if( ch == ch2 )
			--n;
		else if( ch == '\n' )
			++nLines;
		if( n == 0 || cp == 0 || cp >= fSize )
			break;
	}
	if( n == 0 ) {
		selBegin = selEnd = cp;
		/* put the selection on the third line */
		if( selBegin >= selWindow->posBotline 
		 || selBegin < selWindow->posTopline ) {
			/* remember where we came from */
			selWindow->rowLastline = selWindow->numTopline;
			n = 3;
			cp = prevLine(selWindow->fileId, selBegin, &n);
			selWindow->posTopline = cp;
			/* recalculate the line number by letting */
			/* prevLine count as far back as it can */
			n = 30000;
			prevLine(selWindow->fileId, cp, &n);
			selWindow->numTopline = n + 1;
		}
		redrawBox(selWindow->row1, selWindow->col1,
			selWindow->row2, selWindow->col2);
		updateScreen(selWindow->row1, selWindow->row2);
	} else
		msg("No matching character was found.", 1);
}

int pascal
/* XTAG:getUnixState */
getUnixState(fileId)
	int fileId;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern int unixMode;

	long cp, limit;
	int fileUnixMode;

	/* if unixMode is 0 or 1 then that+1 is the window's unixMode */
	if( unixMode == 0 )
		return 1;
	else if( unixMode == 1 )
		return 3;
	/* otherwise, sample the first 300 characters */
	/* if no CRs are found then assume it is a UNIX file */
	/* if a CR is found, then it is a DOS file */
	cp = 0L;
	limit = fileSize(fileId) - 1;
	if( limit > 300 )
		limit = 300;
	fileUnixMode = 3;
	while( cp < limit ) {
		if( readChar(fileId, cp) == '\r' ) {
			fileUnixMode = 1;
			break;
		}
		++cp;
	}
	return fileUnixMode;
}

int pascal
/* XTAG:indentToShowSelection */
/* CPC 4-26-88 */
indentToShowSelection(selCol)
	int selCol;	/* the column where the first character of */
			/* the selection is */
/* CPC 4-26-88 */
{
	extern unsigned char msgBuffer[];
	extern struct window *selWindow;
	extern long selBegin, selEnd;

	register struct window *rselWindow;
	long longIndent;
	int dummy, col, windowWidth, indent;
	int originalIndent;

	rselWindow = selWindow;
	originalIndent = rselWindow->indent;

	/* find the column the selection starts in */
/* CPC 4-26-88 */
	if( selCol == -1 )
		(void)posToxy(rselWindow, selBegin, &dummy, &col);
	else
		col = selCol;
/* CPC 4-26-88 */

	/* posToxy subtracts off the current indent so add it back in */
	/* posToxy adds in rselWindow->col1 so subtract it off */
	col += rselWindow->indent - rselWindow->col1;
	windowWidth = rselWindow->col2 - rselWindow->col1 - 1;

	/* if the selection is right of the window, change the indent */
	if( (col > (windowWidth+rselWindow->indent)) ) {
		indent = col - (windowWidth>>1);
		/* figure the column of the end of the selection */
		/* 	add window width / 2 to put it in the  */
		/*	middle of the window */
		longIndent = (selEnd - selBegin) + (long)indent;
		if( longIndent < (long)col )
			rselWindow->indent = (int)longIndent;
		else
			rselWindow->indent = indent;
	} else if( (col < rselWindow->indent) ) {
		/* if the selection is left of the window change the indent */
		/* change the indent back to zero if this will still leave */
		/* the beginning of the selection in the left half of the */
		/* window */
		indent = col - (windowWidth>>1);
		if( indent < 0 )
			indent = 0;
		rselWindow->indent = indent;
	}
	/* indicate on return whether you actually changed the indent */
	return (originalIndent != rselWindow->indent);
}

void pascal
/* XTAG:doGoSel */
doGoSel(w)
	struct window *w;
{
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int linesOverFind;
	extern int debug;

	register struct window *rselWindow;
	register int n;
	int i, fid;
	long cp, toCp;

	rselWindow = selWindow;

	/* remember where we came from */
	w->rowLastline = w->numTopline;

	/* n is the number of lines to move */
	fid = rselWindow->fileId;
	cp = rselWindow->posTopline;
	i = linesOverFind;
	/* find the number of lines in the window */
	i = rselWindow->row2 - rselWindow->row1 - 2;
	if( linesOverFind > i )
		/* if linesOverFind would place it outside the */
		/* window then put it in the middle of the window */
		i >>= 1;
	else
		/* otherwise put it linesOverFind lines down */
		i = linesOverFind;
	toCp = prevLine(fid, selBegin, &i);
	n = rselWindow->numTopline;
	if( cp <= toCp ) {
		while( cp < toCp ) {
			i = 1;
			cp = nextLine(fid, cp, &i);
			++n;
		}
	} else {	/* cp > toCp */
		while( cp > toCp ) {
			i = 1;
			cp = prevLine(fid, cp, &i);
			--n;
		}
	}
	rselWindow->posTopline = toCp;
	rselWindow->numTopline = n;
	(void)indentToShowSelection(-1);
	doTopWindow(rselWindow, 0);
	redrawWindow(rselWindow);
}

void pascal
/* XTAG:doInform */
doInform()
{
	extern unsigned char msgBuffer[];
	extern long selBegin, selEnd;
	extern struct diskBuffer *buffers;
	extern struct openFile *files;
	extern struct changeItem *change;
	extern struct window *windowList;
	extern int nextChange;
	extern struct changeItem scrapBuffer;
	extern struct piece *freePList;
	extern unsigned int piecesLeft;
	extern int nBuffers;
	extern unsigned int bytesLeft;
	extern int nextSpace;
	extern int addHandle;
#ifdef OVERLAYS
	extern unsigned char primaryOverlay[];
	extern unsigned char secondaryOverlay[];
	extern int overlayState;
#endif
	extern int maxFiles;

	register int i;
	int j;
	long fs;
	char ch;
	struct piece *pp;

	msg("f(ree space), s(election)", 2);
	ch = incon();

	switch( ch ) {
	
	case 'f':	/* free space */
		sprintf(msgBuffer,
"Free bytes = %d   Free pieces = %d  Free menu bytes = %d",
			bytesLeft, piecesLeft, MENUSPACE - nextSpace);
		msg(msgBuffer, 1);
		break;

	case 's':	/* selection */
		sprintf(msgBuffer,
			"Selection: first char=%ld  last char=%ld",
			selBegin, selEnd);
		msg(msgBuffer, 1);
		break;

#ifdef DOINFORMS
#ifdef OVERLAYS
	case 'o':	/* overlays */
		sprintf(msgBuffer, "state=0x%X primary <%s> secondary <%s>",
			overlayState, primaryOverlay, secondaryOverlay);
		msg(msgBuffer, 1); incon();
		break;
#endif

	case 'p':
		for(i = 0; i < maxFiles; i++) {
			if( files[i].origHandle == -1 )
				continue;
			sprintf(msgBuffer,
"%s(%d): handle=%d piece=%x lo=%ld hi=%ld size=%ld",
			  files[i].origName, i, files[i].origHandle,
			  files[i].logPiece, files[i].loLogPiece,
			  files[i].hiLogPiece, files[i].fileSize );
			msg(msgBuffer, 1); incon();
			sprintf(msgBuffer,
"%s(%d): buffer cache: lo=%ld hi=%ld addr=%X %X",
			  files[i].origName, i, files[i].loLogBuffer,
			  files[i].hiLogBuffer, files[i].logBufOffset,
			  files[i].logBufSegment);
			msg(msgBuffer, 1); incon();
			fs = 0;
			j = 0;
			for(pp=files[i].pieceList;pp!=NULL;pp=pp->nextPiece){
				sprintf(msgBuffer,
		 "        piece[%d] @%x  position=%ld  length=%ld  file=%d",
				  j++, pp, pp->position, pp->length, pp->file);
				msg(msgBuffer, 1); incon();
				fs += pp->length;
			}
			sprintf(msgBuffer,
			"    #pieces=%d  fileSize=%ld  pieceTotals=%ld",
			j, files[i].fileSize, fs);
			msg(msgBuffer, 1);
			if( incon() == 'z' )
				break;
		}
		break;

	case 'i':	/* information */
		sprintf(msgBuffer, "buffers = %d", nBuffers);
		msg(msgBuffer, 1);
		break;

	case 'h':
		for(i = 0; i <= nextChange; i++) {
			sprintf(msgBuffer,
		"change[%d]: type=%d fileId=%d position=%ld length=%ld",
				i, change[i].type, change[i].fileId,
				change[i].position, change[i].length);
			msg(msgBuffer, 1); incon();
		}
		break;

	case 'b':
		msg("***********IN BUFFERS************", 1);
		sprintf(msgBuffer, "addHandle=%d", addHandle);
		msg(msgBuffer, 1); incon();
		for(i = 0; i < nBuffers; i++) {
			if( buffers[i].handle == -1 )
				continue;
			sprintf(msgBuffer,
"buffer %d: header=%x  address=%lx  handle=%d  block=%ld",
			  i, &buffers[i], buffers[i].bufferAddress,
			  buffers[i].handle, buffers[i].blockNumber);
			msg(msgBuffer, 1); incon();
		}
		break;

	case 'c':
		msg("********** CHANGES ***********", 1); incon();
		for(i = 0; i < NHISTORY; i++) {
			pp = change[i].firstPiece;
			if( pp == NULL )
				continue;
			sprintf(msgBuffer, "change[%d]:", i);
			msg(msgBuffer, 1); incon();
			for( ; pp != NULL; pp = pp->nextPiece ) {
				sprintf(msgBuffer,
		 "        piece[%d] @%x  position=%ld  length=%ld  file=%d",
				  j++, pp, pp->position, pp->length, pp->file);
				msg(msgBuffer, 1); incon();
			}
			sprintf(msgBuffer,"#pieces=%d", j);
			msg(msgBuffer, 1); incon();
		}
		msg("********* SCRAPBUFFER *********", 1); incon();
		sprintf(msgBuffer, "    type=%d", scrapBuffer.type);
		msg(msgBuffer, 1); incon();
		j = 0;
		for(pp=scrapBuffer.firstPiece;pp!=NULL;pp=pp->nextPiece){
			sprintf(msgBuffer,
"        piece[%d] @%x  position=%ld  length=%ld  file=%d",
			  j++, pp, pp->position, pp->length, pp->file);
			msg(msgBuffer, 1); incon();
		}
		j = 0;
		pp = freePList;
		while( pp != NULL ) {
			++j;
			pp = pp->nextPiece;
		}
		sprintf(msgBuffer,"Number of free pieces = %d", j);
		msg(msgBuffer, 1); incon();
		break;
#endif
	default:
		break;
	}
}

void pascal
/* XTAG:doGoto */
doGoto(w, i)
	register struct window *w;
	int i;
{
	extern unsigned char msgBuffer[];

	int n, fid;
	unsigned char ch, *fileName;

	if( i == -1 ) {
		fileName = getInput("Line number to go to: ", "", 0);
		if( fileName == NULL ) {
			msg("Go to line number cancelled", 1);
			return;
		}
		/* skip past any non-numeric characters at the front */
		while( 1 ) {
			ch = *fileName;
			if( ch == '\0' || ('0'<=ch && ch<='9') )
				break;
			++fileName;
		}
		i = atoi(fileName);
	}

	/* remember where we came from */
	w->rowLastline = w->numTopline;

	/* n is the number of lines to move */
	n = i - w->numTopline;
	fid = w->fileId;
	if( n > 0 ) {
		w->posTopline = nextLine(fid, w->posTopline, &n);
		w->numTopline += n;
		w->posBotline = nextLine(fid, w->posBotline, &n);
		w->numBotline += n;
	} else {	/* n < 0 */
		n = -n;
		w->posTopline = prevLine(fid, w->posTopline, &n);
		w->numTopline -= n;
		w->posBotline = prevLine(fid, w->posBotline, &n);
		w->numBotline -= n;
	}
	w->indent = 0;
	redrawWindow(w);
}

void pascal
/* XTAG:initKeymaps */
initKeymaps()
{
	extern int asciiMap[];
	register int i;

	for(i = 0; i < 132; i++)
		asciiMap[i] = FCHARACTER;
	asciiMap[27] = FCANCEL;	/* ESCape */
}
