/*
 * Copyright (c) 1982, 1986 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)mtio.h	7.6 (Berkeley) 2/5/91
 */

/*
 * Structures and definitions for mag tape io control commands
 */

/* Modified for use with DOS Archive QIC02 device driver by
 * Eddy Olk, eddy@duteca.et.tudelft.nl
 */

/* structure for MTIOCTOP - mag tape op command */
struct mtop {
	short	mt_op;		/* operations defined below */
	long	mt_count;	/* how many of them */
};

/* operations */
#define MTWEOF		0	/* write an end-of-file record */
#define MTFSF		1	/* forward space file */
#define MTBSF		2	/* backward space file */
#define MTFSR		3	/* forward space record */
#define MTBSR		4	/* backward space record */
#define MTREW		5	/* rewind */
#define MTOFFL		6	/* rewind and put the drive offline */
#define MTNOP		7	/* no operation, sets status only */
#define MTRESET		8	/* reset tape drive */
#define MTERASE		9	/* erase */
#define MTRETENSION	10	/* retension */
#define MTEOD		11	/* seek eod */

/* structure for MTIOCGET - mag tape get status command */

struct mtget {
	short	mt_type;	/* type of magtape device */
/* the following two registers are grossly device dependent */
	short	mt_dsreg;	/* ``drive status'' register */
	short	mt_erreg;	/* ``error count'' register */
/* end device-dependent registers */
	short	mt_resid;	/* residual count */
	short   mt_unrun;       /* underrun count */

	long	mt_fileno;	/* file number of current position */
	long	mt_blkno;	/* block number of current position in file */
};

/*
 * Constants for mt_type byte.  These are the same
 * for controllers compatible with the types listed.
 */
#define	MT_ISAR		0x01	/* Archive SC402/499 QIC-02 controller */

/* mag tape io control commands */
#define	MTIOCTOP	3	/* do a mag tape op */
#define	MTIOCGET	2	/* get tape status */

#define	DEFTAPE	"tape$"

/* error/status bit positions */
#define MT_FIL     0x0001	/* File mark detected */
#define MT_BNL     0x0002	/* Block not located */
#define MT_UDE     0x0004	/* Unrecoverable data error */
#define MT_EOM     0x0008	/* End of medium */
#define MT_WRP     0x0010	/* Write protected cartridge */
#define MT_DFF     0x0020	/* Device fault or SELF TEST failed */
#define MT_CNI     0x0040	/* Cartridge not in place */
#define MT_ST0     0x0080	/* Flag(s) set in this byte (0) */

#define MT_POR     0x0100	/* Power on or RESET occurred */
#define MT_EOD     0x0200	/* End of recorded data */
#define MT_PAR     0x0400	/* Bus parity error */
#define MT_BOM     0x0800	/* Beginning of medium */
#define MT_MBD     0x1000	/* Marginal block detected */
#define MT_NDT     0x2000	/* No data detected */
#define MT_ILL     0x4000	/* Illegal command */
#define MT_ST1     0x8000	/* Flag(s) set in this byte (1) */
