Rem compile with BDS 7.1:
Rem BC STRUCT/O;
Rem LINK STRUCT,,,QBX/E;

DefInt A-Z

Rem $Include: 'qbx.bi'

Dim InRegister As RegType, OutRegister As RegType

Type RegRecType
  Description As String*60
  InterruptNum As Integer
  Registers As RegType
End Type

Dim RegRecord As RegRecType

Open "register.dat" For Random As #1 Len=Len(RegRecord)
If Lof(1)=0 Then
   RegRecord.Description="Video Interrupt Hex 10, Function 6, Scroll Screen."
   RegRecord.InterruptNum=&H10
   RegRecord.Registers.AX=&H0600
   RegRecord.Registers.BX=&H0700
   RegRecord.Registers.CX=&H0000
   RegRecord.Registers.DX=&H184F
   RegRecord.Registers.BP=&H0000
   RegRecord.Registers.SI=&H0000
   RegRecord.Registers.DI=&H0000
   RegRecord.Registers.FLAGS=&H0000
   Put 1,1,RegRecord
   Print "Initialized record 1 of register.dat"
Endif

Do
  Print
  Print "Enter option:"
  Print "A:add record"
  Print "E:edit record"
  Print "I:do interrupt"
  Print "L:list records"
  Print "Q:quit"
  Print "?";
  I$=""
  While I$=""
    I$=Inkey$
  Wend
  Print I$
  Select Case Ucase$(I$)
  Case "L"
    For I=1 To Lof(1)/Len(RegRecord)
      Get 1,I,RegRecord
      Print "Record Number:";I
      Print "Interrupt Number Hex ";Hex$(RegRecord.InterruptNum)
      Print "Description: ";RegRecord.Description
      Print "AX:";Hex$(RegRecord.Registers.AX)
      Print "BX:";Hex$(RegRecord.Registers.BX)
      Print "CX:";Hex$(RegRecord.Registers.CX)
      Print "DX:";Hex$(RegRecord.Registers.DX)
      Print "BP:";Hex$(RegRecord.Registers.BP)
      Print "SI:";Hex$(RegRecord.Registers.SI)
      Print "DI:";Hex$(RegRecord.Registers.DI)
      Print "FLAGS:";Hex$(RegRecord.Registers.FLAGS)
      Print "-more(y/n)-";
      I$=""
      While I$=""
        I$=Inkey$
      Wend
      Print
      If Ucase$(I$)="N" Then
        Exit For
      Endif
    Next
  Case "E"
    Print "Enter record number(1 -"+Str$(Lof(1)/Len(RegRecord))+")";
    Input X:X=Int(X)
    Print
    If X<1 Or X>Lof(1)/Len(RegRecord) Then
       Print "Record number out of file range."
    Else
      Get 1,X,RegRecord
      Do
        Print "Enter edit option:"
        Print "[1]interrupt number"
        Print "[2]registers"
        Print "[3]description"
        Print "[4]store changes"
        Input Y
        Select Case Y
        Case 1
          Print "Input interrupt number(in Hex):"
          Input X$
          RegRecord.InterruptNum=Val("&H"+X$)
        Case 2
          Print "Enter register fields(In Hex):"
          Print "AX:";
          Input X$
          RegRecord.Registers.AX=Val("&H"+X$)
          Print "BX:";
          Input X$
          RegRecord.Registers.BX=Val("&H"+X$)
          Print "CX:";
          Input X$
          RegRecord.Registers.CX=Val("&H"+X$)
          Print "DX:";
          Input X$
          RegRecord.Registers.DX=Val("&H"+X$)
          Print "BP:";
          Input X$
          RegRecord.Registers.BP=Val("&H"+X$)
          Print "SI:";
          Input X$
          RegRecord.Registers.SI=Val("&H"+X$)
          Print "DI:";
          Input X$
          RegRecord.Registers.DI=Val("&H"+X$)
          Print "FLAGS:";
          Input X$
          RegRecord.Registers.FLAGS=Val("&H"+X$)
        Case 3
          Print "Input interrupt description:"
          Line Input "?",X$
          RegRecord.Description=X$
        Case 4
          Put 1,X,RegRecord
          Print "Record";X;" stored."
          Exit Do
        End Select
      Loop
    Endif
  Case "I"
    Do
      Print "Enter record number(1 -"+Str$(Lof(1)/Len(RegRecord))+")";
      Input X:X=Int(X)
      Print
      If X<1 Or X>Lof(1)/Len(RegRecord) Then
        Print "Record number out of file range."
        Exit Do
      Endif
      Get 1,X,RegRecord
      RegNum=RegRecord.InterruptNum
      Print RegRecord.Description
      Print "Before implementation, interrupt Hex ";
      Print Hex$(RegNum);" in registers are:"
      InRegister=RegRecord.Registers
      Print "AX:";Hex$(InRegister.AX)
      Print "BX:";Hex$(InRegister.BX)
      Print "CX:";Hex$(InRegister.CX)
      Print "DX:";Hex$(InRegister.DX)
      Print "BP:";Hex$(InRegister.BP)
      Print "SI:";Hex$(InRegister.SI)
      Print "DI:";Hex$(InRegister.DI)
      Print "FLAGS:";Hex$(InRegister.FLAGS)
      Print "Press any key to implement interrupt Hex ";Hex$(RegNum)
      While Inkey$=""
      Wend
      Call Interrupt(RegNum,InRegister,OutRegister)
      Print "After implementation, interrupt Hex ";
      Print Hex$(RegNum);" out registers are:"
      Print "AX:";Hex$(OutRegister.AX)
      Print "BX:";Hex$(OutRegister.BX)
      Print "CX:";Hex$(OutRegister.CX)
      Print "DX:";Hex$(OutRegister.DX)
      Print "BP:";Hex$(OutRegister.BP)
      Print "SI:";Hex$(OutRegister.SI)
      Print "DI:";Hex$(OutRegister.DI)
      Print "FLAGS:";Hex$(OutRegister.FLAGS)
      Exit Do
    Loop
  Case "A"
    X=Lof(1)/Len(RegRecord)+1
    RegRecord.InterruptNum=0
    RegRecord.Description=""
    RegRecord.Registers.AX=0
    RegRecord.Registers.BX=0
    RegRecord.Registers.CX=0
    RegRecord.Registers.DX=0
    RegRecord.Registers.BP=0
    RegRecord.Registers.SI=0
    RegRecord.Registers.DI=0
    RegRecord.Registers.FLAGS=0
    Put 1,X,RegRecord
    Print "Record added."
  Case "Q"
    Exit Do
  End Select
Loop
End
