   REM Prime3 -- calculates primes by divisors of primes.
   REM    Note: Since any integer is the product of primes,
   REM          testing for primes is faster by dividing them by primes.
   REM    Also note: Since the square of a divisor is the highest fator
   REM               of a number, testing for primes stops at the square
   REM               root of the prime.
   DEFDBL A-Z
   ' this program compiled with pds 7.1 and is public domain 2000.
10 PRINT "Enter upper array size";
   INPUT i
   j = i
   ' since the array is double (8 bytes),
   ' dimensioning the array with the compiler switch /fs/ah
   ' for far heap huge array will use memory beyond the 64k near data segment
   ' allowing for arrays greater than 64k.

   DO ' test for array size a power of 2 to use far heap.
      IF i / 2 = i \ 2 THEN
         i = i / 2
         IF i = 1 THEN EXIT DO
      ELSE
         PRINT "Size must be a power of 2."
         GOTO 10
      END IF
   LOOP
   DIM p(j) AS DOUBLE
   ' first we load the primes which will be the divisors.

   PRINT "Loading array with the first"; j; "primes";
   T! = TIMER
   q = 0
   z = 1
   DO
      z = z + 1
      f = 0
      FOR l = 2 TO INT(SQR(z)) ' no need to divide by greater than the square
         IF z / l = z \ l THEN
            f = -1
            EXIT FOR
         END IF
      NEXT
      IF f = 0 THEN
         q = q + 1
         p(q) = z
      END IF
      IF q = j THEN
         EXIT DO
      END IF
      o! = TIMER - T!
      IF o! < 0! THEN
         o! = o! + 86400!
      END IF
      IF o! >= 10! THEN
         T! = TIMER
         PRINT ".";
      END IF
   LOOP
   PRINT
   ' get the group counter.
20 PRINT "Calculate primes in groups of 1000, 10000, 1000000";
   INPUT u
   IF u = 1000 OR u = 10000 OR u = 1000000 THEN
      PRINT "Calculating primes in groups of"; u
   ELSE
      GOTO 20
   END IF
   ' since the highest divisor we stored is the square of the highest prime,
   ' the tester knows the last prime which will be calculated.
   PRINT "Last prime will be at approximately:"; p(j) * p(j)
   PRINT "Press <escape> to quit:"

   T! = TIMER ' time the testing
   w = 1
   z = 1
   DO
      z = z + 2
      q = 1
      f = 0
      DO
         ' divide by the primes in the array
         q = q + 1
         ' already tested all prime divisors up to the square, so it is prime.
         IF p(q) > INT(SQR(z)) THEN
            EXIT DO
         END IF
         ' an even divide is not a prime.
         IF z / p(q) = z \ p(q) THEN
            f = -1
            EXIT DO
         END IF
      LOOP
      IF f = 0 THEN
         w = w + 1
         s = z
         ' check for escape every 10 primes.
         IF w / 10 = w \ 10 THEN
            IF INKEY$ = CHR$(27) THEN
               EXIT DO
            END IF
         END IF
         ' check counted up to group.
         IF w / u = w \ u THEN
            o! = TIMER - T!
            IF o! < 0! THEN
               o! = o! + 86400!
            END IF
            PRINT "Prime"; w; "equals:"; z; "-"; o!; "sec."
         END IF
      END IF
      ' check the highest prime which can be tested.
      IF z > (p(j) * p(j)) THEN
         EXIT DO
      END IF
   LOOP
   ' display the last prime found.
   PRINT "Prime"; w; "equals:"; s; "-"; TIMER - T!; "sec."
   END ' end-of-program

